untrusted comment: signature from openbsd 6.2 base secret key
RWRVWzAMgtyg7nkjfnAPRwyFx09o2p4+LauwncXnLq0YVgz+FmD3OdXAPyseWeBJKQOD1iq2H3rR/0J/1D4gHK/v6SBPWVDq9Qs=

OpenBSD 6.2 errata 010, March 20, 2018:

The IPsec AH header could be longer than the network packet.
This may cause a kernel crash.

Apply by doing:
    signify -Vep /etc/signify/openbsd-62-base.pub -x 010_ahauth.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/netinet/ip_ah.c
===================================================================
RCS file: /cvs/src/sys/netinet/ip_ah.c,v
retrieving revision 1.131.4.1
diff -u -p -r1.131.4.1 ip_ah.c
--- sys/netinet/ip_ah.c	1 Feb 2018 21:58:25 -0000	1.131.4.1
+++ sys/netinet/ip_ah.c	14 Mar 2018 23:23:17 -0000
@@ -583,7 +583,16 @@ ah_input(struct mbuf *m, struct tdb *tdb
 		    "in SA %s/%08x\n", hl * sizeof(u_int32_t),
 		    ipsp_address(&tdb->tdb_dst, buf, sizeof(buf)),
 		    ntohl(tdb->tdb_spi)));
-
+		ahstat.ahs_badauthl++;
+		m_freem(m);
+		return EACCES;
+	}
+	if (skip + ahx->authsize + rplen > m->m_pkthdr.len) {
+		DPRINTF(("%s: bad mbuf length %d (expecting %d) "
+		    "for packet in SA %s/%08x\n", __func__,
+		    m->m_pkthdr.len, skip + ahx->authsize + rplen,
+		    ipsp_address(&tdb->tdb_dst, buf, sizeof(buf)),
+		    ntohl(tdb->tdb_spi)));
 		ahstat.ahs_badauthl++;
 		m_freem(m);
 		return EACCES;
