/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec2(10ul, 12ul) >> 0ul) => u64vec2(10ul, 12ul)
 * (u64vec2(10ul, 12ul) >> 1ul) => u64vec2(5ul, 6ul)
 * (u64vec2(10ul, 12ul) >> 2ul) => u64vec2(2ul, 3ul)
 * (u64vec2(10ul, 12ul) >> 5ul) => u64vec2(0ul, 0ul)
 * (u64vec2(10ul, 12ul) >> 25ul) => u64vec2(0ul, 0ul)
 * (u64vec2(10ul, 12ul) >> 31ul) => u64vec2(0ul, 0ul)
 * (u64vec2(10ul, 12ul) >> 32ul) => u64vec2(0ul, 0ul)
 * (u64vec2(10ul, 12ul) >> 47ul) => u64vec2(0ul, 0ul)
 * (u64vec2(10ul, 12ul) >> 63ul) => u64vec2(0ul, 0ul)
 * (u64vec2(42ul, 48ul) >> 0ul) => u64vec2(42ul, 48ul)
 * (u64vec2(42ul, 48ul) >> 1ul) => u64vec2(21ul, 24ul)
 * (u64vec2(42ul, 48ul) >> 2ul) => u64vec2(10ul, 12ul)
 * (u64vec2(42ul, 48ul) >> 5ul) => u64vec2(1ul, 1ul)
 * (u64vec2(42ul, 48ul) >> 25ul) => u64vec2(0ul, 0ul)
 * (u64vec2(42ul, 48ul) >> 31ul) => u64vec2(0ul, 0ul)
 * (u64vec2(42ul, 48ul) >> 32ul) => u64vec2(0ul, 0ul)
 * (u64vec2(42ul, 48ul) >> 47ul) => u64vec2(0ul, 0ul)
 * (u64vec2(42ul, 48ul) >> 63ul) => u64vec2(0ul, 0ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec2(10ul, 12ul) >> 0ul), u64vec2(10ul, 12ul))) ? 1 : -1] array0;
  float[all(equal((u64vec2(10ul, 12ul) >> 1ul), u64vec2(5ul, 6ul))) ? 1 : -1] array1;
  float[all(equal((u64vec2(10ul, 12ul) >> 2ul), u64vec2(2ul, 3ul))) ? 1 : -1] array2;
  float[all(equal((u64vec2(10ul, 12ul) >> 5ul), u64vec2(0ul, 0ul))) ? 1 : -1] array3;
  float[all(equal((u64vec2(10ul, 12ul) >> 25ul), u64vec2(0ul, 0ul))) ? 1 : -1] array4;
  float[all(equal((u64vec2(10ul, 12ul) >> 31ul), u64vec2(0ul, 0ul))) ? 1 : -1] array5;
  float[all(equal((u64vec2(10ul, 12ul) >> 32ul), u64vec2(0ul, 0ul))) ? 1 : -1] array6;
  float[all(equal((u64vec2(10ul, 12ul) >> 47ul), u64vec2(0ul, 0ul))) ? 1 : -1] array7;
  float[all(equal((u64vec2(10ul, 12ul) >> 63ul), u64vec2(0ul, 0ul))) ? 1 : -1] array8;
  float[all(equal((u64vec2(42ul, 48ul) >> 0ul), u64vec2(42ul, 48ul))) ? 1 : -1] array9;
  float[all(equal((u64vec2(42ul, 48ul) >> 1ul), u64vec2(21ul, 24ul))) ? 1 : -1] array10;
  float[all(equal((u64vec2(42ul, 48ul) >> 2ul), u64vec2(10ul, 12ul))) ? 1 : -1] array11;
  float[all(equal((u64vec2(42ul, 48ul) >> 5ul), u64vec2(1ul, 1ul))) ? 1 : -1] array12;
  float[all(equal((u64vec2(42ul, 48ul) >> 25ul), u64vec2(0ul, 0ul))) ? 1 : -1] array13;
  float[all(equal((u64vec2(42ul, 48ul) >> 31ul), u64vec2(0ul, 0ul))) ? 1 : -1] array14;
  float[all(equal((u64vec2(42ul, 48ul) >> 32ul), u64vec2(0ul, 0ul))) ? 1 : -1] array15;
  float[all(equal((u64vec2(42ul, 48ul) >> 47ul), u64vec2(0ul, 0ul))) ? 1 : -1] array16;
  float[all(equal((u64vec2(42ul, 48ul) >> 63ul), u64vec2(0ul, 0ul))) ? 1 : -1] array17;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
