/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.handler.BaseConditionModuleHandler;
import org.openhab.core.automation.internal.module.exception.UncomparableException;
import org.openhab.core.types.State;
import org.openhab.core.types.TypeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class CompareConditionHandler
extends BaseConditionModuleHandler {
    public static final String MODULE_TYPE = "core.GenericCompareCondition";
    public static final String INPUT_LEFT_OBJECT = "input";
    public static final String INPUT_LEFT_FIELD = "inputproperty";
    public static final String RIGHT_OP = "right";
    public static final String OPERATOR = "operator";
    public final Logger logger = LoggerFactory.getLogger(CompareConditionHandler.class);

    public CompareConditionHandler(Condition module) {
        super(module);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isSatisfied(Map<String, @Nullable Object> context) {
        String string;
        Object leftObjFieldNameObj;
        String string2;
        Object rightObj;
        String string3;
        Object operatorObj = ((Condition)this.module).getConfiguration().get(OPERATOR);
        Object object = operatorObj;
        if (object instanceof String) {
            void s;
            String string4 = (String)object;
            String cfr_ignored_0 = (String)object;
            string3 = s;
        } else {
            string3 = null;
        }
        String operator = string3;
        Object object2 = rightObj = ((Condition)this.module).getConfiguration().get(RIGHT_OP);
        if (object2 instanceof String) {
            void s;
            String string5 = (String)object2;
            String cfr_ignored_1 = (String)object2;
            string2 = s;
        } else {
            string2 = null;
        }
        String rightOperandString = string2;
        Object object3 = leftObjFieldNameObj = ((Condition)this.module).getConfiguration().get(INPUT_LEFT_FIELD);
        if (object3 instanceof String) {
            void s;
            String string6 = (String)object3;
            String cfr_ignored_2 = (String)object3;
            string = s;
        } else {
            string = null;
        }
        String leftObjectFieldName = string;
        if (rightOperandString == null) return false;
        if (operator == null) {
            return false;
        }
        Object leftObj = context.get(INPUT_LEFT_OBJECT);
        Object toCompare = this.getCompareValue(leftObj, leftObjectFieldName);
        Object rightValue = this.getRightOperandValue(rightOperandString, toCompare);
        if (rightValue == null) {
            if (leftObj != null) {
                this.logger.info("unsupported type for compare condition: {}", leftObj.getClass());
                return false;
            }
            this.logger.info("unsupported type for compare condition: null ({})", (Object)((Condition)this.module).getInputs().get(INPUT_LEFT_FIELD));
            return false;
        }
        try {
            switch (operator) {
                case "equals": 
                case "=": 
                case "==": 
                case "EQ": 
                case "eq": 
                case "EQUALS": {
                    if (toCompare != null) return toCompare.equals(rightValue);
                    if ("null".equals(rightOperandString)) return true;
                    if ("".equals(rightOperandString)) return true;
                    return false;
                }
                case ">": 
                case "GT": 
                case "gt": {
                    if (toCompare == null) {
                        return false;
                    }
                    if (this.compare(toCompare, rightValue) <= 0) return false;
                    return true;
                }
                case "=>": 
                case ">=": 
                case "GTE": 
                case "gte": {
                    if (toCompare == null) {
                        return false;
                    }
                    if (this.compare(toCompare, rightValue) < 0) return false;
                    return true;
                }
                case "<": 
                case "LT": 
                case "lt": {
                    if (toCompare == null) {
                        return false;
                    }
                    if (this.compare(toCompare, rightValue) >= 0) return false;
                    return true;
                }
                case "<=": 
                case "=<": 
                case "LTE": 
                case "lte": {
                    if (toCompare == null) {
                        return false;
                    }
                    if (this.compare(toCompare, rightValue) > 0) return false;
                    return true;
                }
                case "matches": {
                    void string22;
                    void string1;
                    Object object4 = toCompare;
                    if (!(object4 instanceof String)) return false;
                    String string7 = (String)object4;
                    String cfr_ignored_3 = (String)object4;
                    Object object5 = rightValue;
                    if (!(object5 instanceof String)) return false;
                    String string8 = (String)object5;
                    String cfr_ignored_4 = (String)object5;
                    return string1.matches((String)string22);
                }
            }
            return false;
        }
        catch (UncomparableException e) {
            return false;
        }
    }

    private int compare(Object a, Object b) throws UncomparableException {
        if (Comparable.class.isAssignableFrom(a.getClass()) && a.getClass().equals(b.getClass())) {
            try {
                return ((Comparable)a).compareTo(b);
            }
            catch (ClassCastException e) {
                throw new UncomparableException();
            }
        }
        throw new UncomparableException();
    }

    /*
     * WARNING - void declaration
     */
    private @Nullable Object getRightOperandValue(String rightOperandString2, @Nullable Object toCompare) {
        if ("null".equals(rightOperandString2)) {
            return rightOperandString2;
        }
        Object object = toCompare;
        if (object instanceof State) {
            void state;
            State state2 = (State)object;
            State cfr_ignored_0 = (State)object;
            return TypeParser.parseState(List.of(state.getClass()), (String)rightOperandString2);
        }
        if (toCompare instanceof Integer) {
            return Integer.parseInt(rightOperandString2);
        }
        if (toCompare instanceof String) {
            return rightOperandString2;
        }
        if (toCompare instanceof Long) {
            return Long.parseLong(rightOperandString2);
        }
        if (toCompare instanceof Double) {
            return Double.parseDouble(rightOperandString2);
        }
        return null;
    }

    private @Nullable Object getCompareValue(@Nullable Object leftObj, @Nullable String leftObjFieldName) {
        if (leftObj == null || leftObjFieldName == null || leftObjFieldName.isEmpty() || leftObj instanceof String || leftObj instanceof Integer || leftObj instanceof Long || leftObj instanceof Double) {
            return leftObj;
        }
        try {
            Method m = leftObj.getClass().getMethod("get" + leftObjFieldName.substring(0, 1).toUpperCase() + leftObjFieldName.substring(1), new Class[0]);
            return m.invoke(leftObj, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | StringIndexOutOfBoundsException | InvocationTargetException e) {
            return null;
        }
    }
}

