/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueingThreadPoolExecutor
extends ThreadPoolExecutor {
    private final Logger logger = LoggerFactory.getLogger(QueueingThreadPoolExecutor.class);
    static final int CORE_THREAD_POOL_SIZE = 1;
    private final BlockingQueue<Runnable> taskQueue;
    private Thread queueThread;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final Object semaphore = new Object();
    private final String threadPoolName;

    protected QueueingThreadPoolExecutor(String name, int threadPoolSize) {
        this(name, new CommonThreadFactory(name), threadPoolSize, new LinkedTransferQueue<Runnable>(), new QueueingRejectionHandler());
    }

    private QueueingThreadPoolExecutor(String threadPoolName, ThreadFactory threadFactory, int threadPoolSize, BlockingQueue<Runnable> taskQueue, RejectedExecutionHandler rejectionHandler) {
        super(1, threadPoolSize, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, rejectionHandler);
        this.threadPoolName = threadPoolName;
        this.taskQueue = taskQueue;
        this.logger.debug("Using {} as taskQueue implementation", (Object)taskQueue.getClass().getCanonicalName());
        this.allowCoreThreadTimeOut(true);
    }

    public static QueueingThreadPoolExecutor createInstance(String name, int threadPoolSize) {
        return QueueingThreadPoolExecutor.createInstance(name, threadPoolSize, new LinkedTransferQueue<Runnable>());
    }

    public static QueueingThreadPoolExecutor createInstance(String name, int threadPoolSize, BlockingQueue<Runnable> taskQueue) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("A thread pool name must be provided!");
        }
        return new QueueingThreadPoolExecutor(name, new CommonThreadFactory(name), threadPoolSize, taskQueue, new QueueingRejectionHandler());
    }

    protected void addToQueue(Runnable runnable) {
        this.lock.readLock().lock();
        if (this.queueThread == null || !this.queueThread.isAlive()) {
            this.lock.readLock().unlock();
            this.lock.writeLock().lock();
            try {
                if (this.queueThread == null || !this.queueThread.isAlive()) {
                    this.logger.info("Thread pool '{}' exhausted, queueing tasks now.", (Object)this.threadPoolName);
                    this.queueThread = this.createNewQueueThread();
                    this.queueThread.start();
                }
                this.lock.readLock().lock();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        try {
            this.taskQueue.add(runnable);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        Object object = this.semaphore;
        synchronized (object) {
            this.semaphore.notify();
        }
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        return this.taskQueue;
    }

    @Override
    public void execute(Runnable command) {
        if (this.taskQueue.isEmpty()) {
            super.execute(command);
        } else {
            if (command == null) {
                throw new NullPointerException();
            }
            if (!this.isShutdown()) {
                this.addToQueue(command);
            }
        }
    }

    private Thread createNewQueueThread() {
        Thread thread = this.getThreadFactory().newThread(() -> {
            while (true) {
                if (this.getActiveCount() < this.getMaximumPoolSize()) {
                    try {
                        Runnable runnable = this.taskQueue.poll(2L, TimeUnit.SECONDS);
                        if (runnable != null) {
                            this.logger.debug("Executing queued task of thread pool '{}'.", (Object)this.threadPoolName);
                            QueueingThreadPoolExecutor.super.execute(runnable);
                            continue;
                        }
                        this.lock.writeLock().lock();
                        try {
                            if (!this.taskQueue.isEmpty()) continue;
                            this.queueThread = null;
                            break;
                        }
                        finally {
                            this.lock.writeLock().unlock();
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    Object object = this.semaphore;
                    synchronized (object) {
                        this.semaphore.wait(1000L);
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            this.logger.debug("Queue for thread pool '{}' fully processed - terminating queue thread.", (Object)this.threadPoolName);
        });
        thread.setName(this.threadPoolName + "-queue");
        return thread;
    }

    private static class CommonThreadFactory
    implements ThreadFactory {
        protected final ThreadGroup group;
        protected final AtomicInteger threadNumber = new AtomicInteger(1);
        protected final String name;

        public CommonThreadFactory(String name) {
            this.name = name;
            this.group = Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.name + "-" + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private static class QueueingRejectionHandler
    extends ThreadPoolExecutor.DiscardPolicy {
        private QueueingRejectionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            if (!threadPoolExecutor.isShutdown()) {
                QueueingThreadPoolExecutor queueingThreadPoolExecutor = (QueueingThreadPoolExecutor)threadPoolExecutor;
                queueingThreadPoolExecutor.addToQueue(runnable);
            }
        }
    }
}

