/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl.collect;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import shaded.org.eclipse.aether.RepositoryCache;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.artifact.Artifact;
import shaded.org.eclipse.aether.collection.DependencyManager;
import shaded.org.eclipse.aether.collection.DependencySelector;
import shaded.org.eclipse.aether.collection.DependencyTraverser;
import shaded.org.eclipse.aether.collection.VersionFilter;
import shaded.org.eclipse.aether.graph.Dependency;
import shaded.org.eclipse.aether.graph.DependencyNode;
import shaded.org.eclipse.aether.internal.impl.collect.ObjectPool;
import shaded.org.eclipse.aether.repository.ArtifactRepository;
import shaded.org.eclipse.aether.repository.RemoteRepository;
import shaded.org.eclipse.aether.resolution.ArtifactDescriptorException;
import shaded.org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import shaded.org.eclipse.aether.resolution.ArtifactDescriptorResult;
import shaded.org.eclipse.aether.resolution.VersionRangeRequest;
import shaded.org.eclipse.aether.resolution.VersionRangeResult;
import shaded.org.eclipse.aether.version.Version;
import shaded.org.eclipse.aether.version.VersionConstraint;

public final class DataPool {
    private static final String ARTIFACT_POOL = DataPool.class.getName() + "$Artifact";
    private static final String DEPENDENCY_POOL = DataPool.class.getName() + "$Dependency";
    private static final String DESCRIPTORS = DataPool.class.getName() + "$Descriptors";
    public static final ArtifactDescriptorResult NO_DESCRIPTOR = new ArtifactDescriptorResult(new ArtifactDescriptorRequest());
    private ObjectPool<Artifact> artifacts;
    private ObjectPool<Dependency> dependencies;
    private Map<Object, WeakReference<Descriptor>> descriptors;
    private final Map<Object, Constraint> constraints = new HashMap<Object, Constraint>();
    private final Map<Object, List<DependencyNode>> nodes = new HashMap<Object, List<DependencyNode>>(256);

    public DataPool(RepositorySystemSession session) {
        RepositoryCache cache = session.getCache();
        if (cache != null) {
            this.artifacts = (ObjectPool)cache.get(session, ARTIFACT_POOL);
            this.dependencies = (ObjectPool)cache.get(session, DEPENDENCY_POOL);
            this.descriptors = (Map)cache.get(session, DESCRIPTORS);
        }
        if (this.artifacts == null) {
            this.artifacts = new ObjectPool();
            if (cache != null) {
                cache.put(session, ARTIFACT_POOL, this.artifacts);
            }
        }
        if (this.dependencies == null) {
            this.dependencies = new ObjectPool();
            if (cache != null) {
                cache.put(session, DEPENDENCY_POOL, this.dependencies);
            }
        }
        if (this.descriptors == null) {
            this.descriptors = Collections.synchronizedMap(new WeakHashMap(256));
            if (cache != null) {
                cache.put(session, DESCRIPTORS, this.descriptors);
            }
        }
    }

    public Artifact intern(Artifact artifact) {
        return this.artifacts.intern(artifact);
    }

    public Dependency intern(Dependency dependency) {
        return this.dependencies.intern(dependency);
    }

    public Object toKey(ArtifactDescriptorRequest request) {
        return request.getArtifact();
    }

    public ArtifactDescriptorResult getDescriptor(Object key, ArtifactDescriptorRequest request) {
        Descriptor descriptor;
        WeakReference<Descriptor> descriptorRef = this.descriptors.get(key);
        Descriptor descriptor2 = descriptor = descriptorRef != null ? (Descriptor)descriptorRef.get() : null;
        if (descriptor != null) {
            return descriptor.toResult(request);
        }
        return null;
    }

    public void putDescriptor(Object key, ArtifactDescriptorResult result) {
        this.descriptors.put(key, new WeakReference<GoodDescriptor>(new GoodDescriptor(result)));
    }

    public void putDescriptor(Object key, ArtifactDescriptorException e) {
        this.descriptors.put(key, new WeakReference<BadDescriptor>(BadDescriptor.INSTANCE));
    }

    public Object toKey(VersionRangeRequest request) {
        return new ConstraintKey(request);
    }

    public VersionRangeResult getConstraint(Object key, VersionRangeRequest request) {
        Constraint constraint = this.constraints.get(key);
        if (constraint != null) {
            return constraint.toResult(request);
        }
        return null;
    }

    public void putConstraint(Object key, VersionRangeResult result) {
        this.constraints.put(key, new Constraint(result));
    }

    public Object toKey(Artifact artifact, List<RemoteRepository> repositories, DependencySelector selector, DependencyManager manager, DependencyTraverser traverser, VersionFilter filter) {
        return new GraphKey(artifact, repositories, selector, manager, traverser, filter);
    }

    public List<DependencyNode> getChildren(Object key) {
        return this.nodes.get(key);
    }

    public void putChildren(Object key, List<DependencyNode> children) {
        this.nodes.put(key, children);
    }

    static final class GraphKey {
        private final Artifact artifact;
        private final List<RemoteRepository> repositories;
        private final DependencySelector selector;
        private final DependencyManager manager;
        private final DependencyTraverser traverser;
        private final VersionFilter filter;
        private final int hashCode;

        GraphKey(Artifact artifact, List<RemoteRepository> repositories, DependencySelector selector, DependencyManager manager, DependencyTraverser traverser, VersionFilter filter) {
            this.artifact = artifact;
            this.repositories = repositories;
            this.selector = selector;
            this.manager = manager;
            this.traverser = traverser;
            this.filter = filter;
            this.hashCode = Objects.hash(artifact, repositories, selector, manager, traverser, filter);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof GraphKey)) {
                return false;
            }
            GraphKey that = (GraphKey)obj;
            return Objects.equals(this.artifact, that.artifact) && Objects.equals(this.repositories, that.repositories) && Objects.equals(this.selector, that.selector) && Objects.equals(this.manager, that.manager) && Objects.equals(this.traverser, that.traverser) && Objects.equals(this.filter, that.filter);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    static final class ConstraintKey {
        private final Artifact artifact;
        private final List<RemoteRepository> repositories;
        private final int hashCode;

        ConstraintKey(VersionRangeRequest request) {
            this.artifact = request.getArtifact();
            this.repositories = request.getRepositories();
            this.hashCode = this.artifact.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ConstraintKey)) {
                return false;
            }
            ConstraintKey that = (ConstraintKey)obj;
            return this.artifact.equals(that.artifact) && ConstraintKey.equals(this.repositories, that.repositories);
        }

        private static boolean equals(List<RemoteRepository> repos1, List<RemoteRepository> repos2) {
            if (repos1.size() != repos2.size()) {
                return false;
            }
            Iterator<RemoteRepository> it1 = repos1.iterator();
            Iterator<RemoteRepository> it2 = repos2.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                RemoteRepository repo1 = it1.next();
                RemoteRepository repo2 = it2.next();
                if (repo1.isRepositoryManager() != repo2.isRepositoryManager()) {
                    return false;
                }
                if (repo1.isRepositoryManager()) {
                    if (ConstraintKey.equals(repo1.getMirroredRepositories(), repo2.getMirroredRepositories())) continue;
                    return false;
                }
                if (!repo1.getUrl().equals(repo2.getUrl())) {
                    return false;
                }
                if (repo1.getPolicy(true).isEnabled() != repo2.getPolicy(true).isEnabled()) {
                    return false;
                }
                if (repo1.getPolicy(false).isEnabled() == repo2.getPolicy(false).isEnabled()) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static final class Constraint {
        final VersionRepo[] repositories;
        final VersionConstraint versionConstraint;

        Constraint(VersionRangeResult result) {
            this.versionConstraint = result.getVersionConstraint();
            List<Version> versions = result.getVersions();
            this.repositories = new VersionRepo[versions.size()];
            int i = 0;
            for (Version version : versions) {
                this.repositories[i++] = new VersionRepo(version, result.getRepository(version));
            }
        }

        VersionRangeResult toResult(VersionRangeRequest request) {
            VersionRangeResult result = new VersionRangeResult(request);
            for (VersionRepo vr : this.repositories) {
                result.addVersion(vr.version);
                result.setRepository(vr.version, vr.repo);
            }
            result.setVersionConstraint(this.versionConstraint);
            return result;
        }

        static final class VersionRepo {
            final Version version;
            final ArtifactRepository repo;

            VersionRepo(Version version, ArtifactRepository repo) {
                this.version = version;
                this.repo = repo;
            }
        }
    }

    static final class BadDescriptor
    extends Descriptor {
        static final BadDescriptor INSTANCE = new BadDescriptor();

        BadDescriptor() {
        }

        @Override
        public ArtifactDescriptorResult toResult(ArtifactDescriptorRequest request) {
            return NO_DESCRIPTOR;
        }
    }

    static final class GoodDescriptor
    extends Descriptor {
        final Artifact artifact;
        final List<Artifact> relocations;
        final Collection<Artifact> aliases;
        final List<RemoteRepository> repositories;
        final List<Dependency> dependencies;
        final List<Dependency> managedDependencies;

        GoodDescriptor(ArtifactDescriptorResult result) {
            this.artifact = result.getArtifact();
            this.relocations = result.getRelocations();
            this.aliases = result.getAliases();
            this.dependencies = result.getDependencies();
            this.managedDependencies = result.getManagedDependencies();
            this.repositories = result.getRepositories();
        }

        @Override
        public ArtifactDescriptorResult toResult(ArtifactDescriptorRequest request) {
            ArtifactDescriptorResult result = new ArtifactDescriptorResult(request);
            result.setArtifact(this.artifact);
            result.setRelocations(this.relocations);
            result.setAliases(this.aliases);
            result.setDependencies(this.dependencies);
            result.setManagedDependencies(this.managedDependencies);
            result.setRepositories(this.repositories);
            return result;
        }
    }

    static abstract class Descriptor {
        Descriptor() {
        }

        public abstract ArtifactDescriptorResult toResult(ArtifactDescriptorRequest var1);
    }
}

