/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTradeItem;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoldTradeItem;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsTradeItem;
import net.sf.freecol.common.model.InciteTradeItem;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StanceTradeItem;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitTradeItem;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;

public class DiplomaticTrade
extends FreeColGameObject {
    public static final String TAG = "diplomaticTrade";
    private TradeContext context;
    private TradeStatus status;
    private Player sender;
    private Player recipient;
    private final List<TradeItem> items = new ArrayList<TradeItem>();
    private int version;
    private static final String CONTEXT_TAG = "context";
    private static final String RECIPIENT_TAG = "recipient";
    private static final String SENDER_TAG = "sender";
    private static final String STATUS_TAG = "status";
    private static final String VERSION_TAG = "version";

    public DiplomaticTrade(Game game, String id) {
        super(game, "");
    }

    public DiplomaticTrade(Game game, TradeContext context, Player sender, Player recipient, List<TradeItem> items, int version) {
        this(game, "");
        this.context = context;
        this.sender = sender;
        this.recipient = recipient;
        this.status = TradeStatus.PROPOSE_TRADE;
        this.items.clear();
        if (items != null) {
            this.items.addAll(items);
        }
        this.version = version;
    }

    public static DiplomaticTrade makePeaceTreaty(TradeContext context, Player sender, Player recipient) {
        Game game = sender.getGame();
        DiplomaticTrade dt = new DiplomaticTrade(game, context, sender, recipient, null, 0);
        dt.add(new StanceTradeItem(game, sender, recipient, Stance.PEACE));
        dt.add(new StanceTradeItem(game, recipient, sender, Stance.PEACE));
        return dt;
    }

    public TradeContext getContext() {
        return this.context;
    }

    public TradeStatus getStatus() {
        return this.status;
    }

    public void setStatus(TradeStatus status) {
        this.status = status;
    }

    public final Player getSender() {
        return this.sender;
    }

    public final void setSender(Player newSender) {
        this.sender = newSender;
    }

    public final Player getRecipient() {
        return this.recipient;
    }

    public final void setRecipient(Player newRecipient) {
        this.recipient = newRecipient;
    }

    public Player getOtherPlayer(Player player) {
        return this.sender == player ? this.recipient : this.sender;
    }

    public StringTemplate getSendMessage(Player player, Settlement settlement) {
        return ((StringTemplate)StringTemplate.template("model.diplomaticTrade.send." + this.getContext().getKey()).addStringTemplate("%nation%", settlement.getOwner().getCountryLabel())).addStringTemplate("%settlement%", settlement.getLocationLabelFor(player));
    }

    public StringTemplate getReceiveMessage(Player player) {
        return StringTemplate.template("model.diplomaticTrade.receive." + this.getContext().getKey()).addStringTemplate("%nation%", player.getCountryLabel());
    }

    public void add(TradeItem newItem) {
        if (newItem.isUnique()) {
            this.removeType(newItem.getClass());
        }
        this.items.add(newItem);
    }

    public void remove(TradeItem newItem) {
        this.items.remove(newItem);
    }

    public void remove(int index) {
        this.items.remove(index);
    }

    public void removeType(Class<? extends TradeItem> itemClass) {
        CollectionUtils.removeInPlace(this.items, CollectionUtils.matchKey(itemClass, Object::getClass));
    }

    public void clear() {
        this.items.clear();
    }

    public final List<TradeItem> getItems() {
        return this.items;
    }

    public final boolean isEmpty() {
        return this.items.isEmpty();
    }

    public List<TradeItem> getItemsGivenBy(Player player) {
        return CollectionUtils.transform(this.items, CollectionUtils.matchKey(player, TradeItem::getSource));
    }

    public Stance getStance() {
        TradeItem ti = CollectionUtils.find(this.items, i -> i instanceof StanceTradeItem);
        return ti == null ? null : ti.getStance();
    }

    public List<Colony> getColoniesGivenBy(Player player) {
        return CollectionUtils.transform(this.items, ti -> ti instanceof ColonyTradeItem && ti.getSource() == player, ti -> ti.getColony(player.getGame()));
    }

    public int getGoldGivenBy(Player player) {
        TradeItem ti = CollectionUtils.find(this.items, i -> i instanceof GoldTradeItem && player == i.getSource());
        return ti == null ? -1 : ti.getGold();
    }

    public List<Goods> getGoodsGivenBy(Player player) {
        return CollectionUtils.transform(this.items, ti -> ti instanceof GoodsTradeItem && ti.getSource() == player, TradeItem::getGoods);
    }

    public Player getVictim() {
        TradeItem ti = CollectionUtils.find(this.items, i -> i instanceof InciteTradeItem);
        return ti == null ? null : ti.getVictim();
    }

    public List<Unit> getUnitsGivenBy(Player player) {
        return CollectionUtils.transform(this.items, ti -> ti instanceof UnitTradeItem && ti.getSource() == player, TradeItem::getUnit);
    }

    public int getVersion() {
        return this.version;
    }

    public void incrementVersion() {
        ++this.version;
    }

    @Override
    public boolean isInternable() {
        return false;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        DiplomaticTrade o = this.copyInCast(other, DiplomaticTrade.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        Game game = this.getGame();
        this.context = o.getContext();
        this.status = o.getStatus();
        this.sender = game.updateRef(o.getSender());
        this.recipient = game.updateRef(o.getRecipient());
        this.items.clear();
        this.items.addAll(game.updateRef(o.getItems()));
        this.version = o.getVersion();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(CONTEXT_TAG, this.context);
        xw.writeAttribute(SENDER_TAG, this.sender);
        xw.writeAttribute(RECIPIENT_TAG, this.recipient);
        xw.writeAttribute(STATUS_TAG, this.status);
        xw.writeAttribute(VERSION_TAG, this.version);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (TradeItem item : this.items) {
            item.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.context = xr.getAttribute(CONTEXT_TAG, TradeContext.class, null);
        this.sender = xr.getAttribute(this.getGame(), SENDER_TAG, Player.class, (Player)null);
        this.recipient = xr.getAttribute(this.getGame(), RECIPIENT_TAG, Player.class, (Player)null);
        this.status = xr.getAttribute(STATUS_TAG, TradeStatus.class, TradeStatus.REJECT_TRADE);
        this.version = xr.getAttribute(VERSION_TAG, 0);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.items.clear();
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if ("colonyTradeItem".equals(tag)) {
            this.add(new ColonyTradeItem(this.getGame(), xr));
        } else if ("goldTradeItem".equals(tag)) {
            this.add(new GoldTradeItem(this.getGame(), xr));
        } else if ("goodsTradeItem".equals(tag)) {
            this.add(new GoodsTradeItem(this.getGame(), xr));
        } else if ("inciteTradeItem".equals(tag)) {
            this.add(new InciteTradeItem(this.getGame(), xr));
        } else if ("stanceTradeItem".equals(tag)) {
            this.add(new StanceTradeItem(this.getGame(), xr));
        } else if ("unitTradeItem".equals(tag)) {
            this.add(new UnitTradeItem(this.getGame(), xr));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append('[').append(this.getId()).append(' ').append((Object)this.getContext()).append(' ').append((Object)this.getStatus()).append(" from=").append(this.getSender().getId()).append(" to=").append(this.getRecipient().getId()).append(" version=").append(this.getVersion()).append(" [");
        for (TradeItem item : this.getItems()) {
            sb.append(' ').append(item);
        }
        sb.append(" ]]");
        return sb.toString();
    }

    public static enum TradeStatus {
        PROPOSE_TRADE,
        ACCEPT_TRADE,
        REJECT_TRADE;

    }

    public static enum TradeContext {
        CONTACT,
        DIPLOMATIC,
        TRADE,
        TRIBUTE;


        public String getKey() {
            return StringUtils.getEnumKey(this);
        }
    }
}

