/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.bulk;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.bulk.BulkProcessor;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.bulk.Retry;
import org.opensearch.core.action.ActionListener;
import org.opensearch.threadpool.Scheduler;

public final class BulkRequestHandler {
    private final Logger logger;
    private final BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer;
    private final BulkProcessor.Listener listener;
    private final Semaphore semaphore;
    private final Retry retry;
    private final int concurrentRequests;

    BulkRequestHandler(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, BackoffPolicy backoffPolicy, BulkProcessor.Listener listener, Scheduler scheduler, int concurrentRequests) {
        assert (concurrentRequests >= 0);
        this.logger = LogManager.getLogger(this.getClass());
        this.consumer = consumer;
        this.listener = listener;
        this.concurrentRequests = concurrentRequests;
        this.retry = new Retry(backoffPolicy, scheduler);
        this.semaphore = new Semaphore(concurrentRequests > 0 ? concurrentRequests : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(final BulkRequest bulkRequest, final long executionId) {
        Runnable toRelease = () -> {};
        boolean bulkRequestSetupSuccessful = false;
        try {
            this.listener.beforeBulk(executionId, bulkRequest);
            this.semaphore.acquire();
            toRelease = this.semaphore::release;
            CountDownLatch latch = new CountDownLatch(1);
            this.retry.withBackoff(this.consumer, bulkRequest, (ActionListener<BulkResponse>)ActionListener.runAfter((ActionListener)new ActionListener<BulkResponse>(){
                final /* synthetic */ BulkRequestHandler this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(BulkResponse response) {
                    this.this$0.listener.afterBulk(executionId, bulkRequest, response);
                }

                public void onFailure(Exception e) {
                    this.this$0.listener.afterBulk(executionId, bulkRequest, e);
                }
            }, () -> {
                this.semaphore.release();
                latch.countDown();
            }));
            bulkRequestSetupSuccessful = true;
            if (this.concurrentRequests == 0) {
                latch.await();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.info(() -> new ParameterizedMessage("Bulk request {} has been cancelled.", (Object)executionId), (Throwable)e);
            this.listener.afterBulk(executionId, bulkRequest, e);
        }
        catch (Exception e) {
            this.logger.warn(() -> new ParameterizedMessage("Failed to execute bulk request {}.", (Object)executionId), (Throwable)e);
            this.listener.afterBulk(executionId, bulkRequest, e);
        }
        finally {
            if (!bulkRequestSetupSuccessful) {
                toRelease.run();
            }
        }
    }

    boolean awaitClose(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.semaphore.tryAcquire(this.concurrentRequests, timeout, unit)) {
            this.semaphore.release(this.concurrentRequests);
            return true;
        }
        return false;
    }
}

