/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search.collector;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Sort;
import org.opensearch.common.Nullable;
import org.opensearch.neuralsearch.search.HitsThresholdChecker;
import org.opensearch.neuralsearch.search.collector.HybridTopFieldDocSortCollector;

public final class PagingFieldCollector
extends HybridTopFieldDocSortCollector {
    private final FieldDoc after;

    public PagingFieldCollector(int numHits, HitsThresholdChecker hitsThresholdChecker, Sort sort, @Nullable FieldDoc after) {
        super(numHits, hitsThresholdChecker, sort, after);
        this.after = after;
    }

    public LeafCollector getLeafCollector(final LeafReaderContext context) {
        this.docBase = context.docBase;
        final int afterDoc = this.after.doc - this.docBase;
        return new HybridTopFieldDocSortCollector.HybridTopDocSortLeafCollector(this){
            final /* synthetic */ PagingFieldCollector this$0;
            {
                this.this$0 = this$0;
            }

            public void collect(int doc) throws IOException {
                if (Objects.isNull((Object)this.compoundQueryScorer)) {
                    throw new IllegalArgumentException("scorers are null for all sub-queries in hybrid query");
                }
                float[] subScoresByQuery = this.compoundQueryScorer.getSubQueryScores();
                this.initializePriorityQueuesWithComparators(context, subScoresByQuery.length);
                this.incrementTotalHitCount();
                for (int i = 0; i < subScoresByQuery.length; ++i) {
                    float score = subScoresByQuery[i];
                    if (score == 0.0f) continue;
                    if (this.this$0.queueFull[i] && this.thresholdCheck(doc, i)) {
                        return;
                    }
                    boolean resultsFoundOnPreviousPage = this.checkIfSearchAfterResultsAreFound(i, doc);
                    if (resultsFoundOnPreviousPage) {
                        return;
                    }
                    this.this$0.maxScore = Math.max(score, this.this$0.maxScore);
                    if (this.this$0.queueFull[i]) {
                        this.collectCompetitiveHit(doc, i);
                        continue;
                    }
                    int n = i;
                    this.this$0.collectedHits[n] = this.this$0.collectedHits[n] + 1;
                    this.collectHit(doc, this.this$0.collectedHits[i], i, score);
                }
            }

            private boolean checkIfSearchAfterResultsAreFound(int subQueryNumber, int doc) throws IOException {
                int topComparison = this.this$0.reverseMul * this.this$0.comparators[subQueryNumber].compareTop(doc);
                return topComparison > 0 || topComparison == 0 && doc <= afterDoc;
            }
        };
    }
}

