/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ltr.stats.suppliers;

import com.o19s.es.ltr.feature.store.index.Caches;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.opensearch.common.cache.Cache;

public class CacheStatsOnNodeSupplier
implements Supplier<Map<String, Map<String, Object>>> {
    private static final String LTR_CACHE_OBJECT_FEATURE = "feature";
    private static final String LTR_CACHE_OBJECT_FEATURESET = "featureset";
    private static final String LTR_CACHE_OBJECT_MODEL = "model";
    private static final String LTR_CACHE_METRIC_HIT_COUNT = "hit_count";
    private static final String LTR_CACHE_METRIC_MISS_COUNT = "miss_count";
    private static final String LTR_CACHE_METRIC_EVICTION_COUNT = "eviction_count";
    private static final String LTR_CACHE_METRIC_ENTRY_COUNT = "entry_count";
    private static final String LTR_CACHE_METRIC_MEMORY_USAGE_IN_BYTES = "memory_usage_in_bytes";
    private final Caches caches;

    public CacheStatsOnNodeSupplier(Caches caches) {
        this.caches = caches;
    }

    @Override
    public Map<String, Map<String, Object>> get() {
        HashMap<String, Map<String, Object>> values = new HashMap<String, Map<String, Object>>();
        values.put(LTR_CACHE_OBJECT_FEATURE, this.getCacheStats(this.caches.featureCache()));
        values.put(LTR_CACHE_OBJECT_FEATURESET, this.getCacheStats(this.caches.featureSetCache()));
        values.put(LTR_CACHE_OBJECT_MODEL, this.getCacheStats(this.caches.modelCache()));
        return Collections.unmodifiableMap(values);
    }

    private Map<String, Object> getCacheStats(Cache<Caches.CacheKey, ?> cache) {
        HashMap<String, Number> stat = new HashMap<String, Number>();
        stat.put(LTR_CACHE_METRIC_HIT_COUNT, cache.stats().getHits());
        stat.put(LTR_CACHE_METRIC_MISS_COUNT, cache.stats().getMisses());
        stat.put(LTR_CACHE_METRIC_EVICTION_COUNT, cache.stats().getEvictions());
        stat.put(LTR_CACHE_METRIC_ENTRY_COUNT, cache.count());
        stat.put(LTR_CACHE_METRIC_MEMORY_USAGE_IN_BYTES, cache.weight());
        return Collections.unmodifiableMap(stat);
    }
}

