/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ltr.stats;

import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.ltr.stats.LTRStat;

public class LTRStats {
    private final Map<String, LTRStat<?>> stats;

    public LTRStats(Map<String, LTRStat<?>> stats) {
        this.stats = stats;
    }

    public Map<String, LTRStat<?>> getStats() {
        return this.stats;
    }

    public LTRStat<?> getStat(String key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("Stat name cannot be null");
        }
        if (!this.stats.containsKey(key)) {
            throw new IllegalArgumentException("Stat=\"" + key + "\" does not exist");
        }
        return this.stats.get(key);
    }

    public void addStats(String key, LTRStat<?> stat) {
        if (key == null) {
            throw new IllegalArgumentException("Stat name cannot be null");
        }
        this.stats.put(key, stat);
    }

    public Map<String, LTRStat<?>> getNodeStats() {
        return this.getClusterOrNodeStats(false);
    }

    public Map<String, LTRStat<?>> getClusterStats() {
        return this.getClusterOrNodeStats(true);
    }

    private Map<String, LTRStat<?>> getClusterOrNodeStats(Boolean isClusterStats) {
        return this.stats.entrySet().stream().filter(e -> ((LTRStat)e.getValue()).isClusterLevel() == isClusterStats).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

