/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.rest;

import com.o19s.es.ltr.rest.FeatureStoreBaseRestHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.ltr.settings.LTRSettings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestStatusToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestSearchStoreElements
extends FeatureStoreBaseRestHandler {
    private final String type;

    public RestSearchStoreElements(String type) {
        this.type = type;
    }

    public String getName() {
        return "Search for " + this.type + " elements in the LTR feature store";
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_ltr/{store}/_" + this.type), new RestHandler.Route(RestRequest.Method.GET, "/_ltr/_" + this.type)));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        if (!LTRSettings.isLTRPluginEnabled()) {
            throw new IllegalStateException("LTR plugin is disabled. To enable, update ltr.plugin.enabled to true");
        }
        return this.search(client, this.type, this.indexName(request), request);
    }

    BaseRestHandler.RestChannelConsumer search(NodeClient client, String type, String indexName, RestRequest request) {
        String prefix = request.param("prefix");
        int from = request.paramAsInt("from", 0);
        int size = request.paramAsInt("size", 20);
        BoolQueryBuilder qb = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"type", (String)type));
        if (prefix != null && !prefix.isEmpty()) {
            qb.must((QueryBuilder)QueryBuilders.matchQuery((String)"name.prefix", (Object)prefix));
        }
        return channel -> {
            try (ThreadContext.StoredContext threadContext = client.threadPool().getThreadContext().stashContext();){
                RestStatusToXContentListener searchListener = new RestStatusToXContentListener(channel);
                ActionListener wrappedListener = ActionListener.runBefore((ActionListener)searchListener, () -> threadContext.restore());
                client.prepareSearch(new String[]{indexName}).setQuery((QueryBuilder)qb).setSize(size).setFrom(from).execute(wrappedListener);
            }
            catch (Exception e) {
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, e.getMessage()));
            }
        };
    }
}

