/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.feature.store.index;

import com.o19s.es.ltr.feature.Feature;
import com.o19s.es.ltr.feature.FeatureSet;
import com.o19s.es.ltr.feature.store.CompiledLtrModel;
import com.o19s.es.ltr.feature.store.FeatureStore;
import com.o19s.es.ltr.feature.store.index.Caches;
import java.io.IOException;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.cache.Cache;

public class CachedFeatureStore
implements FeatureStore {
    private final FeatureStore inner;
    private final Caches caches;

    public CachedFeatureStore(FeatureStore inner, Caches caches) {
        this.inner = inner;
        this.caches = caches;
    }

    @Override
    public String getStoreName() {
        return this.inner.getStoreName();
    }

    @Override
    public Feature load(String id) throws IOException {
        return this.caches.loadFeature(this.key(id), (CheckedFunction<String, Feature, IOException>)((CheckedFunction)this.inner::load));
    }

    @Override
    public FeatureSet loadSet(String id) throws IOException {
        return this.caches.loadFeatureSet(this.key(id), (CheckedFunction<String, FeatureSet, IOException>)((CheckedFunction)this.inner::loadSet));
    }

    @Override
    public CompiledLtrModel loadModel(String id) throws IOException {
        return this.caches.loadModel(this.key(id), (CheckedFunction<String, CompiledLtrModel, IOException>)((CheckedFunction)this.inner::loadModel));
    }

    Feature getCachedFeature(String id) {
        return this.innerGet(id, this.caches.featureCache());
    }

    FeatureSet getCachedFeatureSet(String id) {
        return this.innerGet(id, this.caches.featureSetCache());
    }

    CompiledLtrModel getCachedModel(String id) {
        return this.innerGet(id, this.caches.modelCache());
    }

    public long totalWeight() {
        return this.featuresWeight() + this.featureSetWeight() + this.modelWeight();
    }

    public long featuresWeight() {
        return this.caches.featureCache().weight();
    }

    public long featureSetWeight() {
        return this.caches.featureSetCache().weight();
    }

    public long modelWeight() {
        return this.caches.modelCache().weight();
    }

    private <T> T innerGet(String id, Cache<Caches.CacheKey, T> cache) {
        return (T)cache.get((Object)this.key(id));
    }

    private Caches.CacheKey key(String id) {
        return new Caches.CacheKey(this.inner.getStoreName(), id);
    }
}

