/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.rules.model;

import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

public enum GroupingType {
    NONE("none"),
    SIMILARITY("similarity");

    private final String stringValue;

    private GroupingType(String stringValue) {
        this.stringValue = stringValue;
    }

    public String getValue() {
        return this.stringValue;
    }

    public static Set<GroupingType> allGroupingTypes() {
        return Arrays.stream(GroupingType.values()).collect(Collectors.toSet());
    }

    public static GroupingType getGroupingTypeFromSettingAndValidate(String settingValue) {
        try {
            return GroupingType.valueOf(settingValue.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid grouping type [%s], type should be one of %s", settingValue, GroupingType.allGroupingTypes()));
        }
    }
}

