/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.model.WorkflowValidator;
import org.opensearch.flowframework.transport.GetWorkflowStepResponse;
import org.opensearch.flowframework.transport.WorkflowRequest;
import org.opensearch.flowframework.workflow.WorkflowStepFactory;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetWorkflowStepTransportAction
extends HandledTransportAction<WorkflowRequest, GetWorkflowStepResponse> {
    private final Logger logger = LogManager.getLogger(GetWorkflowStepTransportAction.class);
    private final WorkflowStepFactory workflowStepFactory;

    @Inject
    public GetWorkflowStepTransportAction(TransportService transportService, ActionFilters actionFilters, WorkflowStepFactory workflowStepFactory) {
        super("cluster:admin/opensearch/flow_framework/workflow_step/get", transportService, actionFilters, WorkflowRequest::new);
        this.workflowStepFactory = workflowStepFactory;
    }

    protected void doExecute(Task task, WorkflowRequest request, ActionListener<GetWorkflowStepResponse> listener) {
        try {
            this.logger.info("Getting workflow validator from the WorkflowStepFactory");
            List<String> steps = !request.getParams().isEmpty() ? Arrays.asList(Strings.splitStringByCommaToArray((String)request.getParams().get("workflow_step"))) : Collections.emptyList();
            WorkflowValidator workflowValidator = steps.isEmpty() ? this.workflowStepFactory.getWorkflowValidator() : this.workflowStepFactory.getWorkflowValidatorByStep(steps);
            listener.onResponse((Object)new GetWorkflowStepResponse(workflowValidator));
        }
        catch (Exception e) {
            String errorMessage = "Failed to retrieve workflow step json.";
            this.logger.error(errorMessage, (Throwable)e);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e))));
        }
    }
}

