/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.internal.Utils;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import org.apache.commons.lang3.Validate;
import software.amazon.cryptography.materialproviders.model.AlgorithmSuiteInfo;

public abstract class TrailingSignatureAlgorithm {
    private static final String SEC_PRIME_FIELD_PREFIX = "secp";
    private static final ECDSASignatureAlgorithm SHA256_ECDSA_P256 = new ECDSASignatureAlgorithm(new ECGenParameterSpec("secp256r1"), "SHA-256", "SHA256withECDSA");
    private static final ECDSASignatureAlgorithm SHA384_ECDSA_P384 = new ECDSASignatureAlgorithm(new ECGenParameterSpec("secp384r1"), "SHA-384", "SHA384withECDSA");

    private TrailingSignatureAlgorithm() {
    }

    public abstract String getMessageDigestAlgorithm();

    public abstract String getRawSignatureAlgorithm();

    public abstract String getHashAndSignAlgorithm();

    public abstract PublicKey deserializePublicKey(String var1);

    public abstract PublicKey decompressPublicKey(byte[] var1);

    public abstract String serializePublicKey(PublicKey var1);

    public abstract KeyPair generateKey() throws GeneralSecurityException;

    public abstract PrivateKey privateKeyFromByteBuffer(ByteBuffer var1);

    public static TrailingSignatureAlgorithm forCryptoAlgorithm(CryptoAlgorithm algorithm) {
        switch (algorithm) {
            case ALG_AES_128_GCM_IV12_TAG16_HKDF_SHA256_ECDSA_P256: {
                return SHA256_ECDSA_P256;
            }
            case ALG_AES_192_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384: 
            case ALG_AES_256_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384: 
            case ALG_AES_256_GCM_HKDF_SHA512_COMMIT_KEY_ECDSA_P384: {
                return SHA384_ECDSA_P384;
            }
        }
        throw new IllegalStateException("Algorithm does not support trailing signature");
    }

    public static TrailingSignatureAlgorithm forCryptoAlgorithm(AlgorithmSuiteInfo algorithmSuiteInfo) {
        Validate.notNull((Object)algorithmSuiteInfo, (String)"algorithmSuiteInfo is required", (Object[])new Object[0]);
        return TrailingSignatureAlgorithm.forCryptoAlgorithm(CryptoAlgorithm.valueOf(algorithmSuiteInfo.id().ESDK().name()));
    }

    private static final class ECDSASignatureAlgorithm
    extends TrailingSignatureAlgorithm {
        private static final String ELLIPTIC_CURVE_ALGORITHM = "EC";
        private static final BigInteger TWO = BigInteger.valueOf(2L);
        private static final BigInteger THREE = BigInteger.valueOf(3L);
        private static final BigInteger FOUR = BigInteger.valueOf(4L);
        private final ECGenParameterSpec ecSpec;
        private final ECParameterSpec ecParameterSpec;
        private final String messageDigestAlgorithm;
        private final String hashAndSignAlgorithm;

        private ECDSASignatureAlgorithm(ECGenParameterSpec ecSpec, String messageDigestAlgorithm, String hashAndSignAlgorithm) {
            if (!ecSpec.getName().startsWith(TrailingSignatureAlgorithm.SEC_PRIME_FIELD_PREFIX)) {
                throw new IllegalStateException("Non-prime curves are not supported at this time");
            }
            this.ecSpec = ecSpec;
            this.messageDigestAlgorithm = messageDigestAlgorithm;
            this.hashAndSignAlgorithm = hashAndSignAlgorithm;
            try {
                AlgorithmParameters parameters = AlgorithmParameters.getInstance(ELLIPTIC_CURVE_ALGORITHM);
                parameters.init(ecSpec);
                this.ecParameterSpec = parameters.getParameterSpec(ECParameterSpec.class);
            }
            catch (NoSuchAlgorithmException | InvalidParameterSpecException e) {
                throw new IllegalStateException("Invalid algorithm", e);
            }
        }

        public String toString() {
            return "ECDSASignatureAlgorithm(curve=" + this.ecSpec.getName() + ")";
        }

        @Override
        public String getMessageDigestAlgorithm() {
            return this.messageDigestAlgorithm;
        }

        @Override
        public String getRawSignatureAlgorithm() {
            return "NONEwithECDSA";
        }

        @Override
        public String getHashAndSignAlgorithm() {
            return this.hashAndSignAlgorithm;
        }

        @Override
        public PublicKey deserializePublicKey(String keyString) {
            Validate.notNull((Object)keyString, (String)"keyString is required", (Object[])new Object[0]);
            byte[] decodedKey = Utils.decodeBase64String(keyString);
            return this.decompressPublicKey(decodedKey);
        }

        @Override
        public PublicKey decompressPublicKey(byte[] decodedKey) {
            BigInteger y;
            BigInteger yOrder;
            Validate.notNull((Object)decodedKey, (String)"decodedKey is required", (Object[])new Object[0]);
            BigInteger x = new BigInteger(1, Arrays.copyOfRange(decodedKey, 1, decodedKey.length));
            byte compressedY = decodedKey[0];
            if (compressedY == TWO.byteValue()) {
                yOrder = BigInteger.ZERO;
            } else if (compressedY == THREE.byteValue()) {
                yOrder = BigInteger.ONE;
            } else {
                throw new IllegalArgumentException("Compressed y value was invalid");
            }
            BigInteger p = ((ECFieldFp)this.ecParameterSpec.getCurve().getField()).getP();
            BigInteger a = this.ecParameterSpec.getCurve().getA();
            BigInteger b = this.ecParameterSpec.getCurve().getB();
            BigInteger alpha = x.modPow(THREE, p).add(a.multiply(x).mod(p)).add(b).mod(p);
            if (!p.mod(FOUR).equals(THREE)) {
                throw new IllegalArgumentException("Curve not supported at this time");
            }
            BigInteger beta = alpha.modPow(p.add(BigInteger.ONE).divide(FOUR), p);
            BigInteger bigInteger = y = beta.mod(TWO).equals(yOrder) ? beta : p.subtract(beta);
            if (!alpha.equals(y.modPow(TWO, p))) {
                throw new IllegalArgumentException("Y was invalid");
            }
            try {
                return KeyFactory.getInstance(ELLIPTIC_CURVE_ALGORITHM).generatePublic(new ECPublicKeySpec(new ECPoint(x, y), this.ecParameterSpec));
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw new IllegalStateException("Invalid algorithm", e);
            }
        }

        @Override
        public String serializePublicKey(PublicKey key) {
            Validate.notNull((Object)key, (String)"key is required", (Object[])new Object[0]);
            Validate.isInstanceOf(ECPublicKey.class, (Object)key, (String)"key must be an instance of ECPublicKey", (Object[])new Object[0]);
            BigInteger x = ((ECPublicKey)key).getW().getAffineX();
            BigInteger y = ((ECPublicKey)key).getW().getAffineY();
            BigInteger compressedY = y.mod(TWO).equals(BigInteger.ZERO) ? TWO : THREE;
            byte[] xBytes = Utils.bigIntegerToByteArray(x, this.ecParameterSpec.getCurve().getField().getFieldSize() / 8);
            byte[] compressedKey = new byte[xBytes.length + 1];
            System.arraycopy(xBytes, 0, compressedKey, 1, xBytes.length);
            compressedKey[0] = compressedY.byteValue();
            return Utils.encodeBase64String(compressedKey);
        }

        @Override
        public PrivateKey privateKeyFromByteBuffer(ByteBuffer privateKey) {
            Validate.notNull((Object)privateKey, (String)"privateKey is required", (Object[])new Object[0]);
            BigInteger privateKeyValue = new BigInteger(1, privateKey.array());
            ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(privateKeyValue, this.ecParameterSpec);
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(ELLIPTIC_CURVE_ALGORITHM);
                return keyFactory.generatePrivate(privateKeySpec);
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw new IllegalStateException("Invalid algorithm", e);
            }
        }

        @Override
        public KeyPair generateKey() throws GeneralSecurityException {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(ELLIPTIC_CURVE_ALGORITHM);
            keyGen.initialize(this.ecSpec, Utils.getSecureRandom());
            return keyGen.generateKeyPair();
        }
    }
}

