/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import software.amazon.cryptography.materialproviders.model.ESDKCommitmentPolicy;

public enum CommitmentPolicy {
    ForbidEncryptAllowDecrypt(ESDKCommitmentPolicy.FORBID_ENCRYPT_ALLOW_DECRYPT),
    RequireEncryptAllowDecrypt(ESDKCommitmentPolicy.REQUIRE_ENCRYPT_ALLOW_DECRYPT),
    RequireEncryptRequireDecrypt(ESDKCommitmentPolicy.REQUIRE_ENCRYPT_REQUIRE_DECRYPT);

    private final software.amazon.cryptography.materialproviders.model.CommitmentPolicy mplCommitmentPolicy;

    private CommitmentPolicy(ESDKCommitmentPolicy esdkCommitmentPolicy) {
        this.mplCommitmentPolicy = software.amazon.cryptography.materialproviders.model.CommitmentPolicy.builder().ESDK(esdkCommitmentPolicy).build();
    }

    public software.amazon.cryptography.materialproviders.model.CommitmentPolicy getMplCommitmentPolicy() {
        return this.mplCommitmentPolicy;
    }

    public boolean algorithmAllowedForEncrypt(CryptoAlgorithm algorithm) {
        switch (this) {
            case ForbidEncryptAllowDecrypt: {
                return !algorithm.isCommitting();
            }
            case RequireEncryptAllowDecrypt: 
            case RequireEncryptRequireDecrypt: {
                return algorithm.isCommitting();
            }
        }
        throw new UnsupportedOperationException("Support for commitment policy " + (Object)((Object)this) + " not yet built.");
    }

    public boolean algorithmAllowedForDecrypt(CryptoAlgorithm algorithm) {
        switch (this) {
            case ForbidEncryptAllowDecrypt: 
            case RequireEncryptAllowDecrypt: {
                return true;
            }
            case RequireEncryptRequireDecrypt: {
                return algorithm.isCommitting();
            }
        }
        throw new UnsupportedOperationException("Support for commitment policy " + (Object)((Object)this) + " not yet built.");
    }
}

