/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.feedMetadata;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.settings.SettingsException;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.securityanalytics.threatIntel.model.TIFMetadata;
import org.opensearch.securityanalytics.util.FileUtils;

public class BuiltInTIFMetadataLoader
extends AbstractLifecycleComponent {
    private static final Logger logger = LogManager.getLogger(BuiltInTIFMetadataLoader.class);
    private static final String BASE_PATH = "threatIntelFeed/";
    private List<TIFMetadata> tifMetadataList = null;
    private Map<String, TIFMetadata> tifMetadataByName;

    public List<TIFMetadata> getTifMetadataList() {
        this.ensureTifMetadataLoaded();
        return this.tifMetadataList;
    }

    public TIFMetadata getTifMetadataByName(String name) {
        this.ensureTifMetadataLoaded();
        return this.tifMetadataByName.get(name);
    }

    public boolean tifMetadataExists(String name) {
        this.ensureTifMetadataLoaded();
        return this.tifMetadataByName.containsKey(name);
    }

    public void ensureTifMetadataLoaded() {
        try {
            if (this.tifMetadataList != null) {
                return;
            }
            this.loadBuiltInTifMetadata();
            this.tifMetadataByName = this.tifMetadataList.stream().collect(Collectors.toMap(TIFMetadata::getName, Function.identity()));
        }
        catch (Exception e) {
            logger.error("Failed loading builtin log types from disk!", (Throwable)e);
        }
    }

    protected void loadBuiltInTifMetadata() throws URISyntaxException, IOException {
        String url = Objects.requireNonNull(BuiltInTIFMetadataLoader.class.getClassLoader().getResource(BASE_PATH), "Built-in threat intel feed metadata file not found").toURI().toString();
        Path dirPath = null;
        if (url.contains("!")) {
            String[] paths = url.split("!");
            dirPath = FileUtils.getFs().getPath(paths[1], new String[0]);
        } else {
            dirPath = Path.of(url, new String[0]);
        }
        Stream<Path> folder = Files.list(dirPath);
        Path tifMetadataPath = (Path)folder.filter(e -> e.toString().endsWith("feedMetadata.json")).collect(Collectors.toList()).get(0);
        try (InputStream is = BuiltInTIFMetadataLoader.class.getResourceAsStream(tifMetadataPath.toString());){
            String tifMetadataFilePayload = new String(Objects.requireNonNull(is).readAllBytes(), StandardCharsets.UTF_8);
            if (tifMetadataFilePayload != null) {
                if (this.tifMetadataList == null) {
                    this.tifMetadataList = new ArrayList<TIFMetadata>();
                }
                Map tifMetadataFileAsMap = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)tifMetadataFilePayload, (boolean)false);
                for (Map.Entry mapEntry : tifMetadataFileAsMap.entrySet()) {
                    Map tifMetadataMap = (Map)mapEntry.getValue();
                    this.tifMetadataList.add(new TIFMetadata(tifMetadataMap));
                }
            }
        }
        catch (Exception e2) {
            throw new SettingsException("Failed to load builtin threat intel feed metadata", (Throwable)e2);
        }
    }

    protected void doStart() {
        this.ensureTifMetadataLoaded();
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
    }
}

