/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.rules.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.securityanalytics.rules.aggregation.AggregationItem;
import org.opensearch.securityanalytics.rules.aggregation.AggregationTraverseVisitor;
import org.opensearch.securityanalytics.rules.condition.ConditionFieldEqualsValueExpression;
import org.opensearch.securityanalytics.rules.condition.ConditionIdentifier;
import org.opensearch.securityanalytics.rules.condition.ConditionItem;
import org.opensearch.securityanalytics.rules.condition.ConditionLexer;
import org.opensearch.securityanalytics.rules.condition.ConditionParser;
import org.opensearch.securityanalytics.rules.condition.ConditionSelector;
import org.opensearch.securityanalytics.rules.condition.ConditionTraverseVisitor;
import org.opensearch.securityanalytics.rules.condition.ConditionValueExpression;
import org.opensearch.securityanalytics.rules.condition.aggregation.AggregationLexer;
import org.opensearch.securityanalytics.rules.condition.aggregation.AggregationParser;
import org.opensearch.securityanalytics.rules.exceptions.SigmaConditionError;
import org.opensearch.securityanalytics.rules.objects.SigmaDetections;
import org.opensearch.securityanalytics.rules.utils.AnyOneOf;
import org.opensearch.securityanalytics.rules.utils.Either;

public class SigmaCondition {
    private final String identifier = "[a-zA-Z0-9-_]+";
    private final List<String> quantifier = List.of("1", "any", "all");
    private final String identifierPattern = "[a-zA-Z0-9*_]+";
    private final List<Either<List<String>, String>> selector = List.of(Either.left(this.quantifier), Either.right("of"), Either.right("[a-zA-Z0-9*_]+"));
    private final List<String> operators = List.of("not ", " and ", " or ");
    private String condition;
    private String aggregation;
    private SigmaDetections detections;
    private ConditionParser parser;
    private AggregationParser aggParser;
    private ConditionTraverseVisitor conditionVisitor;
    private AggregationTraverseVisitor aggVisitor;

    public SigmaCondition(String condition, SigmaDetections detections) {
        if (condition.contains(" | ")) {
            this.condition = condition.split(" \\| ")[0];
            this.aggregation = condition.split(" \\| ")[1];
        } else {
            this.condition = condition;
            this.aggregation = "";
        }
        this.detections = detections;
        ConditionLexer lexer = new ConditionLexer((CharStream)CharStreams.fromString((String)this.condition));
        this.parser = new ConditionParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        this.conditionVisitor = new ConditionTraverseVisitor(this);
        AggregationLexer aggLexer = new AggregationLexer((CharStream)CharStreams.fromString((String)this.aggregation));
        this.aggParser = new AggregationParser((TokenStream)new CommonTokenStream((TokenSource)aggLexer));
        this.aggVisitor = new AggregationTraverseVisitor();
    }

    public Pair<ConditionItem, AggregationItem> parsed() throws SigmaConditionError {
        Either itemOrCondition = (Either)this.conditionVisitor.visit((ParseTree)this.parser.start());
        ConditionItem parsedConditionItem = itemOrCondition.isLeft() ? (ConditionItem)itemOrCondition.getLeft() : (Objects.requireNonNull(this.parsed(this.condition)).isLeft() ? (ConditionItem)Objects.requireNonNull(this.parsed(this.condition)).getLeft() : (Objects.requireNonNull(this.parsed(this.condition)).isMiddle() ? (ConditionItem)Objects.requireNonNull(this.parsed(this.condition)).getMiddle() : (ConditionItem)Objects.requireNonNull(this.parsed(this.condition)).get()));
        AggregationItem parsedAggItem = null;
        if (!this.aggregation.isEmpty()) {
            this.aggVisitor.visit((ParseTree)this.aggParser.comparison_expr());
            parsedAggItem = this.aggVisitor.getAggregationItem();
        }
        return Pair.of((Object)parsedConditionItem, parsedAggItem);
    }

    public List<Either<AnyOneOf<ConditionItem, ConditionFieldEqualsValueExpression, ConditionValueExpression>, String>> convertArgs(List<Either<AnyOneOf<ConditionItem, ConditionFieldEqualsValueExpression, ConditionValueExpression>, String>> parsedArgs) throws SigmaConditionError {
        ArrayList<Either<AnyOneOf<ConditionItem, ConditionFieldEqualsValueExpression, ConditionValueExpression>, String>> newArgs = new ArrayList<Either<AnyOneOf<ConditionItem, ConditionFieldEqualsValueExpression, ConditionValueExpression>, String>>();
        for (Either<AnyOneOf<ConditionItem, ConditionFieldEqualsValueExpression, ConditionValueExpression>, String> parsedArg : parsedArgs) {
            if (parsedArg.isRight()) {
                AnyOneOf<ConditionItem, ConditionFieldEqualsValueExpression, ConditionValueExpression> newItem = this.parsed(parsedArg.get());
                newArgs.add(Either.left(newItem));
                continue;
            }
            newArgs.add(parsedArg);
        }
        return newArgs;
    }

    private AnyOneOf<ConditionItem, ConditionFieldEqualsValueExpression, ConditionValueExpression> parsed(String token) throws SigmaConditionError {
        List<String> subTokens = List.of(token.split(" "));
        if (subTokens.size() < 3 && token.matches("[a-zA-Z0-9-_]+")) {
            ConditionIdentifier conditionIdentifier = new ConditionIdentifier(Collections.singletonList(Either.right(token)));
            ConditionItem item = conditionIdentifier.postProcess(this.detections, null);
            return item instanceof ConditionFieldEqualsValueExpression ? AnyOneOf.middleVal((ConditionFieldEqualsValueExpression)item) : (item instanceof ConditionValueExpression ? AnyOneOf.rightVal((ConditionValueExpression)item) : AnyOneOf.leftVal(item));
        }
        if (subTokens.size() == 3 && this.quantifier.contains(subTokens.get(0)) && this.selector.get(1).get().equals(subTokens.get(1)) && subTokens.get(2).matches("[a-zA-Z0-9*_]+")) {
            ConditionSelector conditionSelector = new ConditionSelector(subTokens.get(0), subTokens.get(2));
            ConditionItem item = conditionSelector.postProcess(this.detections, null);
            return item instanceof ConditionFieldEqualsValueExpression ? AnyOneOf.middleVal((ConditionFieldEqualsValueExpression)item) : (item instanceof ConditionValueExpression ? AnyOneOf.rightVal((ConditionValueExpression)item) : AnyOneOf.leftVal(item));
        }
        return null;
    }
}

