/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.rules.modifiers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.securityanalytics.rules.exceptions.SigmaRegularExpressionError;
import org.opensearch.securityanalytics.rules.exceptions.SigmaTypeError;
import org.opensearch.securityanalytics.rules.exceptions.SigmaValueError;
import org.opensearch.securityanalytics.rules.objects.SigmaDetectionItem;
import org.opensearch.securityanalytics.rules.types.SigmaExpansion;
import org.opensearch.securityanalytics.rules.types.SigmaType;
import org.opensearch.securityanalytics.rules.utils.Either;

public abstract class SigmaModifier {
    private SigmaDetectionItem detectionItem;
    private List<Class<? extends SigmaModifier>> appliedModifiers;

    public SigmaModifier(SigmaDetectionItem detectionItem, List<Class<? extends SigmaModifier>> appliedModifiers) {
        this.detectionItem = detectionItem;
        this.appliedModifiers = appliedModifiers;
    }

    public boolean typeCheck(Either<SigmaType, List<SigmaType>> val) {
        Pair<Class<?>, Class<?>> typePair = this.getTypeHints();
        return typePair.getLeft() != null && val.isLeft() && ((Class)typePair.getLeft()).equals(val.getLeft().getClass()) || typePair.getRight() != null && val.isLeft() && ((Class)typePair.getRight()).equals(val.getLeft().getClass()) || typePair.getLeft() != null && val.isRight() && ((Class)typePair.getLeft()).equals(val.get().getClass()) || typePair.getRight() != null && val.isRight() && ((Class)typePair.getRight()).equals(val.get().getClass());
    }

    public abstract Either<SigmaType, List<SigmaType>> modify(Either<SigmaType, List<SigmaType>> var1) throws SigmaValueError, SigmaRegularExpressionError, SigmaTypeError;

    public abstract Pair<Class<?>, Class<?>> getTypeHints();

    public List<SigmaType> apply(Either<SigmaType, List<SigmaType>> val) throws SigmaTypeError, SigmaValueError, SigmaRegularExpressionError {
        if (val.isLeft() && val.getLeft() instanceof SigmaExpansion) {
            ArrayList<SigmaType> values = new ArrayList<SigmaType>();
            for (SigmaType value : ((SigmaExpansion)val.getLeft()).getValues()) {
                List<SigmaType> va = this.apply(Either.left(value));
                values.addAll(va);
            }
            return Collections.singletonList(new SigmaExpansion(values));
        }
        if (!this.typeCheck(val)) {
            throw new SigmaTypeError("Modifier " + this.getClass().getName() + " incompatible to value type of '" + String.valueOf(val) + "'");
        }
        Either<SigmaType, List<SigmaType>> r = this.modify(val);
        if (r.isRight()) {
            return r.get();
        }
        return Collections.singletonList(r.getLeft());
    }

    public SigmaDetectionItem getDetectionItem() {
        return this.detectionItem;
    }

    public List<Class<? extends SigmaModifier>> getAppliedModifiers() {
        return this.appliedModifiers;
    }
}

