/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class LogType
implements Writeable {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String IS_BUILTIN = "is_builtin";
    private static final String MAPPINGS = "mappings";
    private static final String RAW_FIELD = "raw_field";
    public static final String ECS = "ecs";
    public static final String OCSF = "ocsf";
    public static final String OCSF11 = "ocsf11";
    public static final String IOC_FIELDS = "ioc_fields";
    public static final String IOC = "ioc";
    public static final String FIELDS = "fields";
    private String id;
    private String name;
    private String description;
    private Boolean isBuiltIn;
    private List<Mapping> mappings;
    private List<IocFields> iocFieldsList;

    public LogType(StreamInput sin) throws IOException {
        this.id = sin.readString();
        this.isBuiltIn = sin.readOptionalBoolean();
        this.name = sin.readString();
        this.description = sin.readString();
        this.mappings = sin.readList(Mapping::readFrom);
        this.iocFieldsList = sin.readList(IocFields::readFrom);
    }

    public LogType(String id, String name, String description, boolean isBuiltIn, List<Mapping> mappings, List<IocFields> iocFieldsList) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.isBuiltIn = isBuiltIn;
        this.mappings = mappings == null ? List.of() : mappings;
        this.iocFieldsList = iocFieldsList == null ? List.of() : iocFieldsList;
    }

    public LogType(Map<String, Object> logTypeAsMap) {
        List mappings;
        this.id = (String)logTypeAsMap.get(ID);
        this.name = (String)logTypeAsMap.get(NAME);
        this.description = (String)logTypeAsMap.get(DESCRIPTION);
        if (logTypeAsMap.containsKey(IS_BUILTIN)) {
            this.isBuiltIn = (Boolean)logTypeAsMap.get(IS_BUILTIN);
        }
        if ((mappings = (List)logTypeAsMap.get(MAPPINGS)).size() > 0) {
            this.mappings = new ArrayList<Mapping>(mappings.size());
            this.mappings = mappings.stream().map(e -> new Mapping((String)e.get(RAW_FIELD), (String)e.get(ECS), (String)e.get(OCSF), (String)e.get(OCSF11))).collect(Collectors.toList());
        }
        if (logTypeAsMap.containsKey(IOC_FIELDS)) {
            List iocFieldsList = (List)logTypeAsMap.get(IOC_FIELDS);
            this.iocFieldsList = iocFieldsList.stream().map(e -> new IocFields(e.get(IOC).toString(), (List)e.get(FIELDS))).collect(Collectors.toList());
        } else {
            this.iocFieldsList = Collections.emptyList();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getIsBuiltIn() {
        return this.isBuiltIn;
    }

    public List<IocFields> getIocFieldsList() {
        return this.iocFieldsList;
    }

    public List<Mapping> getMappings() {
        return this.mappings;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeOptionalBoolean(this.isBuiltIn);
        out.writeString(this.name);
        out.writeString(this.description);
        out.writeCollection(this.mappings);
        out.writeCollection(this.iocFieldsList);
    }

    public String toString() {
        return this.name;
    }

    public static class IocFields
    implements Writeable,
    ToXContentObject {
        private final String ioc;
        private final List<String> fields;

        public IocFields(String ioc, List<String> fields) {
            this.ioc = ioc;
            this.fields = fields;
        }

        public IocFields(StreamInput sin) throws IOException {
            this.ioc = sin.readString();
            this.fields = sin.readStringList();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.ioc);
            out.writeStringCollection(this.fields);
        }

        public String getIoc() {
            return this.ioc;
        }

        public List<String> getFields() {
            return this.fields;
        }

        public static IocFields readFrom(StreamInput sin) throws IOException {
            return new IocFields(sin);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            String[] fieldsArray = new String[]{};
            fieldsArray = this.fields.toArray(fieldsArray);
            builder.startObject().field(LogType.IOC, this.ioc).field(LogType.FIELDS, (Object)fieldsArray).endObject();
            return builder;
        }
    }

    public static class Mapping
    implements Writeable {
        private String rawField;
        private String ecs;
        private String ocsf;
        private String ocsf11;

        public Mapping(StreamInput sin) throws IOException {
            this.rawField = sin.readString();
            this.ecs = sin.readOptionalString();
            this.ocsf = sin.readOptionalString();
            this.ocsf11 = sin.readOptionalString();
        }

        public Mapping(String rawField, String ecs, String ocsf, String ocsf11) {
            this.rawField = rawField;
            this.ecs = ecs;
            this.ocsf = ocsf;
            this.ocsf11 = ocsf11;
        }

        public String getRawField() {
            return this.rawField;
        }

        public String getEcs() {
            return this.ecs;
        }

        public String getOcsf() {
            return this.ocsf;
        }

        public String getOcsf11() {
            return this.ocsf11;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.rawField);
            out.writeOptionalString(this.ecs);
            out.writeOptionalString(this.ocsf);
            out.writeOptionalString(this.ocsf11);
        }

        public static Mapping readFrom(StreamInput sin) throws IOException {
            return new Mapping(sin);
        }
    }
}

