/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.rest.RestRequest;

public class IndexRuleRequest
extends ActionRequest {
    private String ruleId;
    private WriteRequest.RefreshPolicy refreshPolicy;
    private String logType;
    private RestRequest.Method method;
    private String rule;
    private Boolean forced;

    public IndexRuleRequest(String ruleId, WriteRequest.RefreshPolicy refreshPolicy, String logType, RestRequest.Method method, String rule, Boolean forced) {
        this.ruleId = ruleId;
        this.refreshPolicy = refreshPolicy;
        this.logType = logType.toLowerCase(Locale.ROOT);
        this.method = method;
        this.rule = rule;
        this.forced = forced;
    }

    public IndexRuleRequest(StreamInput sin) throws IOException {
        this(sin.readString(), WriteRequest.RefreshPolicy.readFrom((StreamInput)sin), sin.readString(), (RestRequest.Method)sin.readEnum(RestRequest.Method.class), sin.readString(), sin.readBoolean());
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.logType == null || this.logType.length() == 0) {
            validationException = ValidateActions.addValidationError((String)"rule categoty is missing", validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.ruleId);
        this.refreshPolicy.writeTo(out);
        out.writeString(this.logType);
        out.writeEnum((Enum)this.method);
        out.writeString(this.rule);
        out.writeBoolean(this.forced.booleanValue());
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public String getLogType() {
        return this.logType;
    }

    public RestRequest.Method getMethod() {
        return this.method;
    }

    public String getRule() {
        return this.rule;
    }

    public Boolean isForced() {
        return this.forced;
    }
}

