/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.commons.alerting.model.Table;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class GetFindingsRequest
extends ActionRequest {
    private List<String> findingIds;
    private Instant startTime;
    private Instant endTime;
    private String logType;
    private String detectorId;
    private Table table;
    private String severity;
    private String detectionType;
    public static final String DETECTOR_ID = "detector_id";

    public GetFindingsRequest(String detectorId) {
        this.detectorId = detectorId;
    }

    public GetFindingsRequest(StreamInput sin) throws IOException {
        this(sin.readOptionalString(), sin.readOptionalString(), Table.readFrom((StreamInput)sin), sin.readOptionalString(), sin.readOptionalString(), sin.readOptionalStringList(), sin.readOptionalInstant(), sin.readOptionalInstant());
    }

    public GetFindingsRequest(String detectorId, String logType, Table table, String severity, String detectionType, List<String> findingIds, Instant startTime, Instant endTime) {
        this.detectorId = detectorId;
        this.logType = logType;
        this.table = table;
        this.severity = severity;
        this.detectionType = detectionType;
        this.findingIds = findingIds;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.detectorId != null && this.detectorId.length() == 0) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.getDefault(), "detector_id is missing", new Object[0]), validationException);
        } else if (this.startTime != null && this.endTime != null && this.startTime.isAfter(this.endTime)) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.getDefault(), "startTime should be less than endTime", new Object[0]), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.detectorId);
        out.writeOptionalString(this.logType);
        this.table.writeTo(out);
        out.writeOptionalString(this.severity);
        out.writeOptionalString(this.detectionType);
        out.writeOptionalStringCollection(this.findingIds);
        out.writeOptionalInstant(this.startTime);
        out.writeOptionalInstant(this.endTime);
    }

    public String getDetectorId() {
        return this.detectorId;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getDetectionType() {
        return this.detectionType;
    }

    public String getLogType() {
        return this.logType;
    }

    public Table getTable() {
        return this.table;
    }

    public List<String> getFindingIds() {
        return this.findingIds;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }
}

