/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.DocValuesPropertyBase;
import org.opensearch.client.opensearch._types.mapping.IndexOptions;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class KeywordProperty
extends DocValuesPropertyBase
implements PropertyVariant,
ToCopyableBuilder<Builder, KeywordProperty> {
    @Nullable
    private final Double boost;
    @Nullable
    private final Boolean eagerGlobalOrdinals;
    @Nullable
    private final Boolean index;
    @Nullable
    private final IndexOptions indexOptions;
    @Nullable
    private final String normalizer;
    @Nullable
    private final Boolean norms;
    @Nullable
    private final String nullValue;
    @Nullable
    private final Boolean splitQueriesOnWhitespace;
    public static final JsonpDeserializer<KeywordProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KeywordProperty::setupKeywordPropertyDeserializer);

    private KeywordProperty(Builder builder) {
        super(builder);
        this.boost = builder.boost;
        this.eagerGlobalOrdinals = builder.eagerGlobalOrdinals;
        this.index = builder.index;
        this.indexOptions = builder.indexOptions;
        this.normalizer = builder.normalizer;
        this.norms = builder.norms;
        this.nullValue = builder.nullValue;
        this.splitQueriesOnWhitespace = builder.splitQueriesOnWhitespace;
    }

    public static KeywordProperty of(Function<Builder, ObjectBuilder<KeywordProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Keyword;
    }

    @Nullable
    public final Double boost() {
        return this.boost;
    }

    @Nullable
    public final Boolean eagerGlobalOrdinals() {
        return this.eagerGlobalOrdinals;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Nullable
    public final IndexOptions indexOptions() {
        return this.indexOptions;
    }

    @Nullable
    public final String normalizer() {
        return this.normalizer;
    }

    @Nullable
    public final Boolean norms() {
        return this.norms;
    }

    @Nullable
    public final String nullValue() {
        return this.nullValue;
    }

    @Nullable
    public final Boolean splitQueriesOnWhitespace() {
        return this.splitQueriesOnWhitespace;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "keyword");
        super.serializeInternal(generator, mapper);
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost.doubleValue());
        }
        if (this.eagerGlobalOrdinals != null) {
            generator.writeKey("eager_global_ordinals");
            generator.write(this.eagerGlobalOrdinals.booleanValue());
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.indexOptions != null) {
            generator.writeKey("index_options");
            this.indexOptions.serialize(generator, mapper);
        }
        if (this.normalizer != null) {
            generator.writeKey("normalizer");
            generator.write(this.normalizer);
        }
        if (this.norms != null) {
            generator.writeKey("norms");
            generator.write(this.norms.booleanValue());
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue);
        }
        if (this.splitQueriesOnWhitespace != null) {
            generator.writeKey("split_queries_on_whitespace");
            generator.write(this.splitQueriesOnWhitespace.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupKeywordPropertyDeserializer(ObjectDeserializer<Builder> op) {
        KeywordProperty.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::boost, JsonpDeserializer.doubleDeserializer(), "boost");
        op.add(Builder::eagerGlobalOrdinals, JsonpDeserializer.booleanDeserializer(), "eager_global_ordinals");
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index");
        op.add(Builder::indexOptions, IndexOptions._DESERIALIZER, "index_options");
        op.add(Builder::normalizer, JsonpDeserializer.stringDeserializer(), "normalizer");
        op.add(Builder::norms, JsonpDeserializer.booleanDeserializer(), "norms");
        op.add(Builder::nullValue, JsonpDeserializer.stringDeserializer(), "null_value");
        op.add(Builder::splitQueriesOnWhitespace, JsonpDeserializer.booleanDeserializer(), "split_queries_on_whitespace");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.boost);
        result = 31 * result + Objects.hashCode(this.eagerGlobalOrdinals);
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + Objects.hashCode(this.indexOptions);
        result = 31 * result + Objects.hashCode(this.normalizer);
        result = 31 * result + Objects.hashCode(this.norms);
        result = 31 * result + Objects.hashCode(this.nullValue);
        result = 31 * result + Objects.hashCode(this.splitQueriesOnWhitespace);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeywordProperty other = (KeywordProperty)o;
        return Objects.equals(this.boost, other.boost) && Objects.equals(this.eagerGlobalOrdinals, other.eagerGlobalOrdinals) && Objects.equals(this.index, other.index) && Objects.equals(this.indexOptions, other.indexOptions) && Objects.equals(this.normalizer, other.normalizer) && Objects.equals(this.norms, other.norms) && Objects.equals(this.nullValue, other.nullValue) && Objects.equals(this.splitQueriesOnWhitespace, other.splitQueriesOnWhitespace);
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, KeywordProperty> {
        @Nullable
        private Double boost;
        @Nullable
        private Boolean eagerGlobalOrdinals;
        @Nullable
        private Boolean index;
        @Nullable
        private IndexOptions indexOptions;
        @Nullable
        private String normalizer;
        @Nullable
        private Boolean norms;
        @Nullable
        private String nullValue;
        @Nullable
        private Boolean splitQueriesOnWhitespace;

        public Builder() {
        }

        private Builder(KeywordProperty o) {
            super(o);
            this.boost = o.boost;
            this.eagerGlobalOrdinals = o.eagerGlobalOrdinals;
            this.index = o.index;
            this.indexOptions = o.indexOptions;
            this.normalizer = o.normalizer;
            this.norms = o.norms;
            this.nullValue = o.nullValue;
            this.splitQueriesOnWhitespace = o.splitQueriesOnWhitespace;
        }

        private Builder(Builder o) {
            super(o);
            this.boost = o.boost;
            this.eagerGlobalOrdinals = o.eagerGlobalOrdinals;
            this.index = o.index;
            this.indexOptions = o.indexOptions;
            this.normalizer = o.normalizer;
            this.norms = o.norms;
            this.nullValue = o.nullValue;
            this.splitQueriesOnWhitespace = o.splitQueriesOnWhitespace;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder boost(@Nullable Double value) {
            this.boost = value;
            return this;
        }

        @Nonnull
        public final Builder eagerGlobalOrdinals(@Nullable Boolean value) {
            this.eagerGlobalOrdinals = value;
            return this;
        }

        @Nonnull
        public final Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder indexOptions(@Nullable IndexOptions value) {
            this.indexOptions = value;
            return this;
        }

        @Nonnull
        public final Builder normalizer(@Nullable String value) {
            this.normalizer = value;
            return this;
        }

        @Nonnull
        public final Builder norms(@Nullable Boolean value) {
            this.norms = value;
            return this;
        }

        @Nonnull
        public final Builder nullValue(@Nullable String value) {
            this.nullValue = value;
            return this;
        }

        @Nonnull
        public final Builder splitQueriesOnWhitespace(@Nullable Boolean value) {
            this.splitQueriesOnWhitespace = value;
            return this;
        }

        @Override
        @Nonnull
        public KeywordProperty build() {
            this._checkSingleUse();
            return new KeywordProperty(this);
        }
    }
}

