/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.agent.tools;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.reflect.TypeToken;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.agent.tools.AbstractRetrieverTool;
import org.opensearch.agent.tools.utils.BrainLogParser;
import org.opensearch.agent.tools.utils.ToolHelper;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.logging.LoggerMessageFormat;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.common.utils.ToolUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.sql.plugin.transport.PPLQueryAction;
import org.opensearch.sql.plugin.transport.TransportPPLQueryRequest;
import org.opensearch.sql.plugin.transport.TransportPPLQueryResponse;
import org.opensearch.sql.ppl.domain.PPLQueryRequest;
import org.opensearch.transport.client.Client;

@ToolAnnotation(value="LogPatternTool")
public class LogPatternTool
extends AbstractRetrieverTool {
    @Generated
    private static final Logger log = LogManager.getLogger(LogPatternTool.class);
    public static final String TYPE = "LogPatternTool";
    public static final String DEFAULT_DESCRIPTION = "Log Pattern Tool";
    public static final String TOP_N_PATTERN = "top_n_pattern";
    public static final String SAMPLE_LOG_SIZE = "sample_log_size";
    public static final String PATTERN_FIELD = "pattern_field";
    public static final String PPL_FIELD = "ppl";
    public static final String VARIABLE_COUNT_THRESHOLD = "variable_count_threshold";
    public static final int LOG_PATTERN_DEFAULT_DOC_SIZE = 1000;
    public static final int DEFAULT_TOP_N_PATTERN = 3;
    public static final int DEFAULT_SAMPLE_LOG_SIZE = 20;
    public static final int DEFAULT_VARIABLE_COUNT_THRESHOLD = 5;
    private static final float DEFAULT_THRESHOLD_PERCENTAGE = 0.3f;
    private static final String PPL_SCHEMA_NAME = "name";
    private String name = "LogPatternTool";
    private int topNPattern;
    private int sampleLogSize;
    private BrainLogParser logParser;
    private Map<String, Object> attributes;

    public LogPatternTool(Client client, NamedXContentRegistry xContentRegistry, int docSize, int topNPattern, int sampleLogSize, int variableCountThreshold) {
        super(client, xContentRegistry, null, null, docSize);
        LogPatternTool.checkPositive(topNPattern, TOP_N_PATTERN);
        LogPatternTool.checkPositive(sampleLogSize, SAMPLE_LOG_SIZE);
        LogPatternTool.checkPositive(variableCountThreshold, VARIABLE_COUNT_THRESHOLD);
        this.topNPattern = topNPattern;
        this.sampleLogSize = sampleLogSize;
        this.logParser = new BrainLogParser(variableCountThreshold, 0.3f);
    }

    @Override
    protected String getQueryBody(String queryText) {
        return this.removeDSLAggregations(queryText);
    }

    @Override
    public <T> void run(Map<String, String> originalParameters, ActionListener<T> listener) {
        Map parameters = ToolUtils.extractInputParameters(originalParameters, this.attributes);
        String dsl = (String)parameters.get("input");
        String ppl = (String)parameters.get(PPL_FIELD);
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dsl)) {
            SearchRequest searchRequest;
            try {
                searchRequest = this.buildSearchRequest(parameters);
            }
            catch (Exception e2) {
                log.error("Failed to build search request.", (Throwable)e2);
                listener.onFailure(e2);
                return;
            }
            ActionListener actionListener = ActionListener.wrap(r -> {
                Object[] hits = r.getHits().getHits();
                if (!CollectionUtils.isEmpty((Object[])hits)) {
                    Map firstLogSource = hits[0].getSourceAsMap();
                    Function<String, List<String>> logMessagesProvider = arg_0 -> LogPatternTool.lambda$run$1((SearchHit[])hits, arg_0);
                    this.onResponseSortedLogPatterns(parameters, listener, firstLogSource, logMessagesProvider);
                } else {
                    listener.onResponse((Object)"Can not get any match from search result.");
                }
            }, e -> {
                log.error("Failed to search index.", (Throwable)e);
                listener.onFailure(e);
            });
            this.client.search(searchRequest, actionListener);
        } else if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ppl)) {
            String prunedPPL = this.removePPLAggregations(ppl);
            PPLQueryRequest pplQueryRequest = new PPLQueryRequest(prunedPPL, null, null, "jdbc");
            TransportPPLQueryRequest transportPPLQueryRequest = new TransportPPLQueryRequest(pplQueryRequest);
            ActionListener actionListener = ActionListener.wrap(r -> {
                List firstDataRow;
                String results = r.getResult();
                Map pplResult = (Map)StringUtils.gson.fromJson(results, new TypeToken<Map<String, Object>>(this){}.getType());
                List schema = pplResult.getOrDefault("schema", new ArrayList());
                List dataRows = pplResult.getOrDefault("datarows", new ArrayList());
                List list = firstDataRow = dataRows.isEmpty() ? new ArrayList() : (List)dataRows.getFirst();
                if (!firstDataRow.isEmpty()) {
                    HashMap<String, Object> firstLogSource = new HashMap<String, Object>();
                    IntStream.range(0, schema.size()).boxed().filter(i -> schema.get((int)i) != null && !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)((Map)schema.get((int)i)).get(PPL_SCHEMA_NAME)))).forEach(i -> firstLogSource.put((String)((Map)schema.get((int)i)).get(PPL_SCHEMA_NAME), firstDataRow.get((int)i)));
                    Function<String, List<String>> logMessagesProvider = patternField -> IntStream.range(0, schema.size()).boxed().filter(i -> schema.get((int)i) != null && patternField.equals(((Map)schema.get((int)i)).get(PPL_SCHEMA_NAME))).findFirst().map(fieldIndex -> dataRows.stream().map(dataRow -> (String)dataRow.get((int)fieldIndex)).toList()).orElseGet(ArrayList::new);
                    this.onResponseSortedLogPatterns(parameters, listener, firstLogSource, logMessagesProvider);
                } else {
                    listener.onResponse((Object)"Can not get any data row from ppl response.");
                }
            }, e -> {
                log.error("Failed to query ppl.", (Throwable)e);
                listener.onFailure(e);
            });
            this.client.execute((ActionType)PPLQueryAction.INSTANCE, (ActionRequest)transportPPLQueryRequest, ToolHelper.getPPLTransportActionListener((ActionListener<TransportPPLQueryResponse>)actionListener));
        } else {
            IllegalArgumentException e3 = new IllegalArgumentException("Both DSL and PPL input is null or empty, can not process it.");
            log.error("Failed to find searchable query.", (Throwable)e3);
            listener.onFailure((Exception)e3);
        }
    }

    @VisibleForTesting
    static String findLongestField(Map<String, Object> sampleLogSource) {
        String longestField = null;
        int maxLength = 0;
        for (Map.Entry<String, Object> entry : sampleLogSource.entrySet()) {
            String stringValue;
            int length;
            Object value = entry.getValue();
            if (!(value instanceof String) || (length = (stringValue = (String)value).length()) <= maxLength) continue;
            maxLength = length;
            longestField = entry.getKey();
        }
        return longestField;
    }

    public String getType() {
        return TYPE;
    }

    @Override
    public boolean validate(Map<String, String> parameters) {
        return parameters != null && !parameters.isEmpty() && (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)parameters.get("input")) && !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)parameters.get("index")) || !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)parameters.get(PPL_FIELD)));
    }

    private <T> void onResponseSortedLogPatterns(Map<String, String> parameters, ActionListener<T> listener, Map<String, Object> firstLogSource, Function<String, List<String>> logMessagesProvider) throws PrivilegedActionException {
        String patternField = parameters.getOrDefault(PATTERN_FIELD, LogPatternTool.findLongestField(firstLogSource));
        this.validatePatternFieldAndFirstLogSource(parameters, patternField, firstLogSource);
        List<String> logMessages = logMessagesProvider.apply(patternField);
        List<Map<String, Object>> sortedEntries = this.getTopNLogPatterns(parameters, logMessages);
        listener.onResponse((Object)AccessController.doPrivileged(() -> StringUtils.gson.toJson((Object)sortedEntries)));
    }

    private List<Map<String, Object>> getTopNLogPatterns(Map<String, String> parameters, List<String> logMessages) {
        int topNPattern = parameters.containsKey(TOP_N_PATTERN) ? LogPatternTool.getPositiveInteger(parameters, TOP_N_PATTERN) : this.topNPattern;
        int sampleLogSize = parameters.containsKey(SAMPLE_LOG_SIZE) ? LogPatternTool.getPositiveInteger(parameters, SAMPLE_LOG_SIZE) : this.sampleLogSize;
        Map<String, List<String>> logPatternMap = this.logParser.parseAllLogPatterns(logMessages);
        return logPatternMap.entrySet().stream().sorted(Comparator.comparingInt(entry -> -((List)entry.getValue()).size())).limit(topNPattern).map(entry -> Map.of("total count", ((List)entry.getValue()).size(), "pattern", entry.getKey(), "sample logs", ((List)entry.getValue()).subList(0, Math.min(((List)entry.getValue()).size(), sampleLogSize)).stream().map(logId -> (String)logMessages.get(Integer.parseInt(logId))).toList())).toList();
    }

    private void validatePatternFieldAndFirstLogSource(Map<String, String> parameters, String patternField, Map<String, Object> firstLogSource) {
        if (patternField == null) {
            throw new IllegalArgumentException("Pattern field is not set and this index doesn't contain any string field");
        }
        if (!firstLogSource.containsKey(patternField)) {
            throw new IllegalArgumentException(LoggerMessageFormat.format(null, (String)"Invalid parameter pattern_field: index {} does not have a field named {}", (Object[])new Object[]{parameters.getOrDefault("index", this.index), patternField}));
        }
        if (!(firstLogSource.get(patternField) instanceof String)) {
            throw new IllegalArgumentException(LoggerMessageFormat.format(null, (String)"Invalid parameter pattern_field: pattern field {} in index {} is not type of String", (Object[])new Object[]{patternField, parameters.getOrDefault("index", this.index)}));
        }
    }

    private String removeDSLAggregations(String dsl) {
        JSONObject dslObj = new JSONObject(dsl);
        dslObj.remove("aggs");
        dslObj.remove("aggregations");
        return dslObj.toString();
    }

    private String removePPLAggregations(String ppl) {
        String normPPL = ppl.replaceAll("\\s+", " ");
        int idx = normPPL.toUpperCase(Locale.ROOT).indexOf("| STATS");
        return idx != -1 ? normPPL.substring(0, idx).trim() : ppl;
    }

    private static int getPositiveInteger(Map<String, ?> params, String paramName) {
        int value = LogPatternTool.getInteger(params, paramName);
        LogPatternTool.checkPositive(value, paramName);
        return value;
    }

    private static int getInteger(Map<String, ?> params, String paramName) {
        int value;
        try {
            value = Integer.parseInt((String)params.get(paramName));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(LoggerMessageFormat.format((String)"Invalid value {} for parameter {}, it should be a number", (Object[])new Object[]{params.get(paramName), paramName}));
        }
        return value;
    }

    private static void checkPositive(int value, String paramName) {
        if (value <= 0) {
            throw new IllegalArgumentException(LoggerMessageFormat.format((String)"Invalid value {} for parameter {}, it should be positive", (Object[])new Object[]{value, paramName}));
        }
    }

    @Generated
    public static LogPatternToolBuilder builder() {
        return new LogPatternToolBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getTopNPattern() {
        return this.topNPattern;
    }

    @Generated
    public int getSampleLogSize() {
        return this.sampleLogSize;
    }

    @Generated
    public BrainLogParser getLogParser() {
        return this.logParser;
    }

    @Override
    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setTopNPattern(int topNPattern) {
        this.topNPattern = topNPattern;
    }

    @Generated
    public void setSampleLogSize(int sampleLogSize) {
        this.sampleLogSize = sampleLogSize;
    }

    @Generated
    public void setLogParser(BrainLogParser logParser) {
        this.logParser = logParser;
    }

    @Override
    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    private static /* synthetic */ List lambda$run$1(SearchHit[] hits, String patternField) {
        return Arrays.stream(hits).map(hit -> {
            Map source = hit.getSourceAsMap();
            return source.getOrDefault(patternField, "");
        }).toList();
    }

    @Generated
    public static class LogPatternToolBuilder {
        @Generated
        private Client client;
        @Generated
        private NamedXContentRegistry xContentRegistry;
        @Generated
        private int docSize;
        @Generated
        private int topNPattern;
        @Generated
        private int sampleLogSize;
        @Generated
        private int variableCountThreshold;

        @Generated
        LogPatternToolBuilder() {
        }

        @Generated
        public LogPatternToolBuilder client(Client client) {
            this.client = client;
            return this;
        }

        @Generated
        public LogPatternToolBuilder xContentRegistry(NamedXContentRegistry xContentRegistry) {
            this.xContentRegistry = xContentRegistry;
            return this;
        }

        @Generated
        public LogPatternToolBuilder docSize(int docSize) {
            this.docSize = docSize;
            return this;
        }

        @Generated
        public LogPatternToolBuilder topNPattern(int topNPattern) {
            this.topNPattern = topNPattern;
            return this;
        }

        @Generated
        public LogPatternToolBuilder sampleLogSize(int sampleLogSize) {
            this.sampleLogSize = sampleLogSize;
            return this;
        }

        @Generated
        public LogPatternToolBuilder variableCountThreshold(int variableCountThreshold) {
            this.variableCountThreshold = variableCountThreshold;
            return this;
        }

        @Generated
        public LogPatternTool build() {
            return new LogPatternTool(this.client, this.xContentRegistry, this.docSize, this.topNPattern, this.sampleLogSize, this.variableCountThreshold);
        }

        @Generated
        public String toString() {
            return "LogPatternTool.LogPatternToolBuilder(client=" + String.valueOf(this.client) + ", xContentRegistry=" + String.valueOf(this.xContentRegistry) + ", docSize=" + this.docSize + ", topNPattern=" + this.topNPattern + ", sampleLogSize=" + this.sampleLogSize + ", variableCountThreshold=" + this.variableCountThreshold + ")";
        }
    }

    public static class Factory
    extends AbstractRetrieverTool.Factory<LogPatternTool> {
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<LogPatternTool> clazz = LogPatternTool.class;
            synchronized (LogPatternTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public LogPatternTool create(Map<String, Object> params) {
            int docSize = params.containsKey("doc_size") ? LogPatternTool.getPositiveInteger(params, "doc_size") : 1000;
            int topNPattern = params.containsKey(LogPatternTool.TOP_N_PATTERN) ? LogPatternTool.getPositiveInteger(params, LogPatternTool.TOP_N_PATTERN) : 3;
            int sampleLogSize = params.containsKey(LogPatternTool.SAMPLE_LOG_SIZE) ? LogPatternTool.getPositiveInteger(params, LogPatternTool.SAMPLE_LOG_SIZE) : 20;
            int variableCountThreshold = params.containsKey(LogPatternTool.VARIABLE_COUNT_THRESHOLD) ? LogPatternTool.getPositiveInteger(params, LogPatternTool.VARIABLE_COUNT_THRESHOLD) : 5;
            return LogPatternTool.builder().client(this.client).xContentRegistry(this.xContentRegistry).docSize(docSize).topNPattern(topNPattern).sampleLogSize(sampleLogSize).variableCountThreshold(variableCountThreshold).build();
        }

        public String getDefaultType() {
            return LogPatternTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }

        @Override
        public String getDefaultDescription() {
            return LogPatternTool.DEFAULT_DESCRIPTION;
        }
    }
}

