/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.transport.experiment;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.searchrelevance.dao.ExperimentDao;
import org.opensearch.searchrelevance.dao.JudgmentDao;
import org.opensearch.searchrelevance.dao.QuerySetDao;
import org.opensearch.searchrelevance.dao.SearchConfigurationDao;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.executors.ExperimentRunningManager;
import org.opensearch.searchrelevance.executors.ExperimentTaskManager;
import org.opensearch.searchrelevance.experiment.HybridOptimizerExperimentProcessor;
import org.opensearch.searchrelevance.experiment.PointwiseExperimentProcessor;
import org.opensearch.searchrelevance.metrics.MetricsHelper;
import org.opensearch.searchrelevance.model.AsyncStatus;
import org.opensearch.searchrelevance.model.Experiment;
import org.opensearch.searchrelevance.settings.SearchRelevanceSettingsAccessor;
import org.opensearch.searchrelevance.transport.experiment.PutExperimentRequest;
import org.opensearch.searchrelevance.utils.TimeUtils;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class PutExperimentTransportAction
extends HandledTransportAction<PutExperimentRequest, IndexResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(PutExperimentTransportAction.class);
    private final ExperimentDao experimentDao;
    private final QuerySetDao querySetDao;
    private final SearchConfigurationDao searchConfigurationDao;
    private final MetricsHelper metricsHelper;
    private final HybridOptimizerExperimentProcessor hybridOptimizerExperimentProcessor;
    private final PointwiseExperimentProcessor pointwiseExperimentProcessor;
    private final ExperimentRunningManager experimentRunningManager;

    @Inject
    public PutExperimentTransportAction(TransportService transportService, ActionFilters actionFilters, ExperimentDao experimentDao, QuerySetDao querySetDao, SearchConfigurationDao searchConfigurationDao, MetricsHelper metricsHelper, JudgmentDao judgmentDao, ExperimentTaskManager experimentTaskManager, ExperimentRunningManager experimentRunningManager, ThreadPool threadPool, SearchRelevanceSettingsAccessor settingsAccessor) {
        super("cluster:admin/opensearch/search_relevance/experiment/create", transportService, actionFilters, PutExperimentRequest::new);
        this.experimentDao = experimentDao;
        this.querySetDao = querySetDao;
        this.searchConfigurationDao = searchConfigurationDao;
        this.metricsHelper = metricsHelper;
        this.hybridOptimizerExperimentProcessor = new HybridOptimizerExperimentProcessor(judgmentDao, experimentTaskManager);
        this.pointwiseExperimentProcessor = new PointwiseExperimentProcessor(judgmentDao, experimentTaskManager);
        this.experimentRunningManager = experimentRunningManager;
    }

    protected void doExecute(Task task, PutExperimentRequest request, ActionListener<IndexResponse> listener) {
        if (request == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Request cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        try {
            String id = UUID.randomUUID().toString();
            Experiment initialExperiment = new Experiment(id, TimeUtils.getTimestamp(), request.getType(), AsyncStatus.PROCESSING, request.getQuerySetId(), request.getSearchConfigurationList(), request.getJudgmentList(), request.getSize(), new ArrayList<Map<String, Object>>());
            this.experimentDao.putExperiment(initialExperiment, ActionListener.wrap(response -> {
                listener.onResponse((Object)((IndexResponse)response));
                this.experimentRunningManager.startExperimentRun(id, request, null, null);
            }, e -> {
                log.error("Failed to create initial experiment", (Throwable)e);
                listener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to create initial experiment", (Throwable)e, RestStatus.INTERNAL_SERVER_ERROR)));
            }));
        }
        catch (Exception e2) {
            log.error("Failed to process experiment request", (Throwable)e2);
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to process experiment request", e2, RestStatus.INTERNAL_SERVER_ERROR)));
        }
    }
}

