/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.transport.experiment;

import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.searchrelevance.model.ExperimentType;
import reactor.util.annotation.NonNull;

public class PutExperimentRequest
extends ActionRequest {
    private final ExperimentType type;
    private final String scheduledExperimentResultId;
    private final String querySetId;
    private final List<String> searchConfigurationList;
    private final List<String> judgmentList;
    private final int size;

    public PutExperimentRequest(@NonNull ExperimentType type, String scheduledExperimentResultId, @NonNull String querySetId, @NonNull List<String> searchConfigurationList, @NonNull List<String> judgmentList, int size) {
        this.type = type;
        this.scheduledExperimentResultId = scheduledExperimentResultId;
        this.querySetId = querySetId;
        this.searchConfigurationList = searchConfigurationList;
        this.judgmentList = judgmentList;
        this.size = size;
    }

    public PutExperimentRequest(StreamInput in) throws IOException {
        super(in);
        this.type = (ExperimentType)in.readEnum(ExperimentType.class);
        this.scheduledExperimentResultId = in.readOptionalString();
        this.querySetId = in.readString();
        this.searchConfigurationList = in.readStringList();
        this.judgmentList = in.readStringList();
        this.size = in.readInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeEnum((Enum)this.type);
        out.writeOptionalString(this.scheduledExperimentResultId);
        out.writeString(this.querySetId);
        out.writeStringArray(this.searchConfigurationList.toArray(new String[0]));
        out.writeStringArray(this.judgmentList.toArray(new String[0]));
        out.writeInt(this.size);
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    @Generated
    public ExperimentType getType() {
        return this.type;
    }

    @Generated
    public String getScheduledExperimentResultId() {
        return this.scheduledExperimentResultId;
    }

    @Generated
    public String getQuerySetId() {
        return this.querySetId;
    }

    @Generated
    public List<String> getSearchConfigurationList() {
        return this.searchConfigurationList;
    }

    @Generated
    public List<String> getJudgmentList() {
        return this.judgmentList;
    }

    @Generated
    public int getSize() {
        return this.size;
    }
}

