/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.stats.events;

import java.io.IOException;
import java.util.Collection;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.searchrelevance.stats.common.StatSnapshot;
import org.opensearch.searchrelevance.stats.events.EventStatName;

public class TimestampedEventStatSnapshot
implements Writeable,
StatSnapshot<Long> {
    public static final String TRAILING_INTERVAL_KEY = "trailing_interval_value";
    public static final String MINUTES_SINCE_LAST_EVENT_KEY = "minutes_since_last_event";
    private EventStatName statName;
    private long value;
    private long trailingIntervalValue;
    private long minutesSinceLastEvent;

    public TimestampedEventStatSnapshot(StreamInput in) throws IOException {
        this.statName = (EventStatName)in.readEnum(EventStatName.class);
        this.value = in.readLong();
        this.trailingIntervalValue = in.readLong();
        this.minutesSinceLastEvent = in.readLong();
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.statName);
        out.writeLong(this.value);
        out.writeLong(this.trailingIntervalValue);
        out.writeLong(this.minutesSinceLastEvent);
    }

    public static TimestampedEventStatSnapshot aggregateEventStatSnapshots(Collection<TimestampedEventStatSnapshot> snapshots) throws IllegalArgumentException {
        if (snapshots == null || snapshots.isEmpty()) {
            return null;
        }
        EventStatName name = null;
        long totalValue = 0L;
        long totalTrailingValue = 0L;
        Long minMinutes = null;
        for (TimestampedEventStatSnapshot stat : snapshots) {
            if (stat == null) continue;
            if (name == null) {
                name = stat.getStatName();
            } else if (name != stat.getStatName()) {
                throw new IllegalArgumentException("Should not aggregate snapshots across different stat names");
            }
            totalValue += stat.getValue().longValue();
            totalTrailingValue += stat.getTrailingIntervalValue();
            if (minMinutes != null && stat.getMinutesSinceLastEvent() >= minMinutes) continue;
            minMinutes = stat.getMinutesSinceLastEvent();
        }
        return TimestampedEventStatSnapshot.builder().statName(name).value(totalValue).trailingIntervalValue(totalTrailingValue).minutesSinceLastEvent(minMinutes).build();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("value", this.value);
        builder.field("stat_type", this.statName.getStatType().getTypeString());
        builder.field(TRAILING_INTERVAL_KEY, this.trailingIntervalValue);
        builder.field(MINUTES_SINCE_LAST_EVENT_KEY, this.minutesSinceLastEvent);
        builder.endObject();
        return builder;
    }

    @Generated
    public static TimestampedEventStatSnapshotBuilder builder() {
        return new TimestampedEventStatSnapshotBuilder();
    }

    @Generated
    public EventStatName getStatName() {
        return this.statName;
    }

    @Generated
    public long getTrailingIntervalValue() {
        return this.trailingIntervalValue;
    }

    @Generated
    public long getMinutesSinceLastEvent() {
        return this.minutesSinceLastEvent;
    }

    @Generated
    public TimestampedEventStatSnapshot(EventStatName statName, long value, long trailingIntervalValue, long minutesSinceLastEvent) {
        this.statName = statName;
        this.value = value;
        this.trailingIntervalValue = trailingIntervalValue;
        this.minutesSinceLastEvent = minutesSinceLastEvent;
    }

    @Generated
    public static class TimestampedEventStatSnapshotBuilder {
        @Generated
        private EventStatName statName;
        @Generated
        private long value;
        @Generated
        private long trailingIntervalValue;
        @Generated
        private long minutesSinceLastEvent;

        @Generated
        TimestampedEventStatSnapshotBuilder() {
        }

        @Generated
        public TimestampedEventStatSnapshotBuilder statName(EventStatName statName) {
            this.statName = statName;
            return this;
        }

        @Generated
        public TimestampedEventStatSnapshotBuilder value(long value) {
            this.value = value;
            return this;
        }

        @Generated
        public TimestampedEventStatSnapshotBuilder trailingIntervalValue(long trailingIntervalValue) {
            this.trailingIntervalValue = trailingIntervalValue;
            return this;
        }

        @Generated
        public TimestampedEventStatSnapshotBuilder minutesSinceLastEvent(long minutesSinceLastEvent) {
            this.minutesSinceLastEvent = minutesSinceLastEvent;
            return this;
        }

        @Generated
        public TimestampedEventStatSnapshot build() {
            return new TimestampedEventStatSnapshot(this.statName, this.value, this.trailingIntervalValue, this.minutesSinceLastEvent);
        }

        @Generated
        public String toString() {
            return "TimestampedEventStatSnapshot.TimestampedEventStatSnapshotBuilder(statName=" + String.valueOf(this.statName) + ", value=" + this.value + ", trailingIntervalValue=" + this.trailingIntervalValue + ", minutesSinceLastEvent=" + this.minutesSinceLastEvent + ")";
        }
    }
}

