/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.scheduler;

import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.action.ActionListener;
import org.opensearch.jobscheduler.spi.JobExecutionContext;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.ScheduledJobRunner;
import org.opensearch.jobscheduler.spi.utils.LockService;
import org.opensearch.searchrelevance.scheduler.ExperimentCancellationToken;
import org.opensearch.searchrelevance.scheduler.ScheduledExperimentRunnerManager;
import org.opensearch.searchrelevance.scheduler.SearchRelevanceJobParameters;
import org.opensearch.searchrelevance.settings.SearchRelevanceSettingsAccessor;
import org.opensearch.searchrelevance.utils.ConcurrencyUtil;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

@ExperimentalApi
public enum SearchRelevanceJobRunner implements ScheduledJobRunner
{
    INSTANCE;

    private static final Logger log;
    private ThreadPool threadPool;
    private Client client;
    private SearchRelevanceSettingsAccessor settingsAccessor;
    private ScheduledExperimentRunnerManager manager;

    public synchronized void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public synchronized void setClient(Client client) {
        this.client = client;
    }

    public synchronized void setSettingsAccessor(SearchRelevanceSettingsAccessor settingsAccessor) {
        this.settingsAccessor = settingsAccessor;
    }

    public synchronized void setManager(ScheduledExperimentRunnerManager manager) {
        this.manager = manager;
    }

    public void runJob(ScheduledJobParameter jobParameter, JobExecutionContext context) {
        if (!(jobParameter instanceof SearchRelevanceJobParameters)) {
            throw new IllegalStateException("Job parameter is not instance of SearchRelevanceJobParameters, type: " + jobParameter.getClass().getCanonicalName());
        }
        this.checkComponents();
        LockService lockService = context.getLockService();
        String scheduledExperimentResultId = UUID.randomUUID().toString();
        SearchRelevanceJobParameters parameter = (SearchRelevanceJobParameters)jobParameter;
        ExperimentCancellationToken cancellationToken = new ExperimentCancellationToken(scheduledExperimentResultId);
        CountDownLatch actuallyFinished = new CountDownLatch(1);
        Runnable jobRunTask = () -> {
            if (jobParameter.getLockDurationSeconds() != null) {
                lockService.acquireLock(jobParameter, context, ActionListener.wrap(lock -> {
                    if (lock == null) {
                        return;
                    }
                    try {
                        this.manager.runScheduledExperiment(parameter, scheduledExperimentResultId, cancellationToken, actuallyFinished);
                    }
                    catch (IllegalStateException e) {
                        actuallyFinished.countDown();
                    }
                    lockService.release(lock, ActionListener.wrap(released -> log.info("Released lock for job {}", (Object)jobParameter.getName()), exception -> {
                        throw new IllegalStateException("Failed to release lock.");
                    }));
                }, exception -> {
                    actuallyFinished.countDown();
                    throw new IllegalStateException("Failed to acquire lock.");
                }));
            } else {
                actuallyFinished.countDown();
                log.warn("Job Duration Seconds cannot be null, therefore, nothing is run.");
            }
        };
        Runnable timeoutJobWithCleanup = () -> {
            CompletableFuture<Void> searchEvaluationTask = null;
            try {
                long timeoutAmount = this.settingsAccessor.getScheduledExperimentsTimeout().getSeconds();
                try {
                    CompletableFuture<Void> originalExperimentStart = CompletableFuture.runAsync(jobRunTask, this.threadPool.generic());
                    searchEvaluationTask = ConcurrencyUtil.withTimeout(originalExperimentStart, timeoutAmount, cancellationToken, actuallyFinished, this.threadPool);
                }
                catch (Exception e) {
                    actuallyFinished.countDown();
                    log.error("scheduled experiment never started " + e.getMessage());
                }
                searchEvaluationTask.join();
            }
            catch (CancellationException e) {
                log.error("Timeout for scheduled experiment has occured!");
            }
            catch (CompletionException e) {
                log.error("Scheduled experiment has timed out. Moving onto cleanup");
            }
            finally {
                while (actuallyFinished.getCount() > 0L) {
                    actuallyFinished.countDown();
                }
                if (cancellationToken.isCancelled()) {
                    log.info("Search evaluation task has concluded through cancellation.");
                } else {
                    log.info("Search evaluation task has concluded without cancellation");
                }
                this.manager.cleanupResources(parameter.getExperimentId(), scheduledExperimentResultId, cancellationToken);
                cancellationToken.cancel();
            }
        };
        this.threadPool.generic().execute(timeoutJobWithCleanup);
    }

    private void checkComponents() {
        if (this.threadPool == null) {
            throw new IllegalStateException("ThreadPool is not initialized.");
        }
        if (this.client == null) {
            throw new IllegalStateException("Client is not initialized.");
        }
        if (this.settingsAccessor == null) {
            throw new IllegalStateException("Settings accessor is not initialized.");
        }
        if (this.manager == null) {
            throw new IllegalStateException("Manager is not initialized.");
        }
    }

    static {
        log = LogManager.getLogger(SearchRelevanceJobRunner.class);
    }
}

