/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.scheduler;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class ExperimentCancellationToken {
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final List<Runnable> cancellationCallbacks = new CopyOnWriteArrayList<Runnable>();
    private final String scheduledExperimentResultId;

    public ExperimentCancellationToken(String scheduledExperimentResultId) {
        this.scheduledExperimentResultId = scheduledExperimentResultId;
    }

    public String getScheduledExperimentResultId() {
        return this.scheduledExperimentResultId;
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    public void cancel() {
        if (this.cancelled.compareAndSet(false, true)) {
            this.cancellationCallbacks.forEach(Runnable::run);
        }
    }

    public void onCancel(Runnable callback) {
        this.cancellationCallbacks.add(callback);
        if (this.isCancelled()) {
            callback.run();
        }
    }
}

