/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.rest;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.common.util.set.Sets;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestActions;
import org.opensearch.searchrelevance.settings.SearchRelevanceSettingsAccessor;
import org.opensearch.searchrelevance.stats.SearchRelevanceStatsInput;
import org.opensearch.searchrelevance.stats.events.EventStatName;
import org.opensearch.searchrelevance.stats.info.InfoStatName;
import org.opensearch.searchrelevance.transport.stats.SearchRelevanceStatsAction;
import org.opensearch.searchrelevance.transport.stats.SearchRelevanceStatsRequest;
import org.opensearch.searchrelevance.utils.ClusterUtil;
import org.opensearch.transport.client.node.NodeClient;

public class RestSearchRelevanceStatsAction
extends BaseRestHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(RestSearchRelevanceStatsAction.class);
    public static final String STAT_PARAM = "stat";
    public static final String NODE_ID_PARAM = "nodeId";
    public static final String FLATTEN_PARAM = "flat_stat_paths";
    public static final String INCLUDE_METADATA_PARAM = "include_metadata";
    public static final String INCLUDE_INDIVIDUAL_NODES_PARAM = "include_individual_nodes";
    public static final String INCLUDE_ALL_NODES_PARAM = "include_all_nodes";
    public static final String INCLUDE_INFO_PARAM = "include_info";
    public static final String PARAM_REGEX = "^[A-Za-z0-9-_]+$";
    public static final int MAX_PARAM_LENGTH = 255;
    private SearchRelevanceSettingsAccessor settingsAccessor;
    private ClusterUtil clusterUtil;
    private static final String NAME = "search_relevance_stats_action";
    private static final Set<String> EVENT_STAT_NAMES = EnumSet.allOf(EventStatName.class).stream().map(EventStatName::getNameString).map(str -> str.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
    private static final Set<String> INFO_STAT_NAMES = EnumSet.allOf(InfoStatName.class).stream().map(InfoStatName::getNameString).map(str -> str.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
    private static final List<RestHandler.Route> ROUTES = ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_search_relevance/{nodeId}/stats/"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_search_relevance/{nodeId}/stats/{stat}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_search_relevance/stats/"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_search_relevance/stats/{stat}"));
    private static final Set<String> RESPONSE_PARAMS = ImmutableSet.of((Object)"nodeId", (Object)"stat", (Object)"include_metadata", (Object)"flat_stat_paths", (Object)"include_individual_nodes", (Object)"include_all_nodes", (Object[])new String[]{"include_info"});

    public static boolean isValidParamString(String param) {
        return param.matches(PARAM_REGEX) && param.length() < 255;
    }

    public String getName() {
        return NAME;
    }

    public List<RestHandler.Route> routes() {
        return ROUTES;
    }

    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        if (!this.settingsAccessor.isWorkbenchEnabled()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Search Relevance Workbench is disabled"));
        }
        if (!this.settingsAccessor.isStatsEnabled()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Search Relevance Workbench stats is disabled"));
        }
        SearchRelevanceStatsRequest searchRelevanceStatsRequest = this.createStatsRequest(request);
        return channel -> client.execute((ActionType)SearchRelevanceStatsAction.INSTANCE, (ActionRequest)searchRelevanceStatsRequest, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }

    private SearchRelevanceStatsRequest createStatsRequest(RestRequest request) {
        SearchRelevanceStatsInput searchRelevanceStatsInput = this.createSearchRelevanceStatsInputFromRequestParams(request);
        String[] nodeIdsArr = searchRelevanceStatsInput.getNodeIds().toArray(new String[0]);
        SearchRelevanceStatsRequest searchRelevanceStatsRequest = new SearchRelevanceStatsRequest(nodeIdsArr, searchRelevanceStatsInput);
        searchRelevanceStatsRequest.timeout(request.param("timeout"));
        return searchRelevanceStatsRequest;
    }

    private SearchRelevanceStatsInput createSearchRelevanceStatsInputFromRequestParams(RestRequest request) {
        SearchRelevanceStatsInput searchRelevanceStatsInput = new SearchRelevanceStatsInput();
        Optional<String[]> nodeIds = this.splitCommaSeparatedParam(request, NODE_ID_PARAM);
        if (nodeIds.isPresent()) {
            List<String> validFormatNodeIds = Arrays.stream(nodeIds.get()).filter(this::isValidNodeId).toList();
            searchRelevanceStatsInput.getNodeIds().addAll(validFormatNodeIds);
        }
        boolean flatten = request.paramAsBoolean(FLATTEN_PARAM, false);
        searchRelevanceStatsInput.setFlatten(flatten);
        boolean includeMetadata = request.paramAsBoolean(INCLUDE_METADATA_PARAM, false);
        searchRelevanceStatsInput.setIncludeMetadata(includeMetadata);
        boolean includeIndividualNodes = request.paramAsBoolean(INCLUDE_INDIVIDUAL_NODES_PARAM, true);
        searchRelevanceStatsInput.setIncludeIndividualNodes(includeIndividualNodes);
        boolean includeAllNodes = request.paramAsBoolean(INCLUDE_ALL_NODES_PARAM, true);
        searchRelevanceStatsInput.setIncludeAllNodes(includeAllNodes);
        boolean includeInfo = request.paramAsBoolean(INCLUDE_INFO_PARAM, true);
        searchRelevanceStatsInput.setIncludeInfo(includeInfo);
        this.processStatsRequestParameters(request, searchRelevanceStatsInput);
        return searchRelevanceStatsInput;
    }

    private void processStatsRequestParameters(RestRequest request, SearchRelevanceStatsInput searchRelevanceStatsInput) {
        Optional<String[]> optionalStats = this.splitCommaSeparatedParam(request, STAT_PARAM);
        Version minClusterVersion = this.clusterUtil.getClusterMinVersion();
        boolean includeEvents = searchRelevanceStatsInput.isIncludeEvents();
        boolean includeInfo = searchRelevanceStatsInput.isIncludeInfo();
        if (!optionalStats.isPresent() || optionalStats.get().length == 0) {
            this.addAllStats(searchRelevanceStatsInput, minClusterVersion);
            return;
        }
        String[] stats = optionalStats.get();
        HashSet<String> invalidStatNames = new HashSet<String>();
        for (String stat : stats) {
            EventStatName eventStatName;
            String normalizedStat = stat.toLowerCase(Locale.ROOT);
            if (!RestSearchRelevanceStatsAction.isValidParamString(normalizedStat) || !this.isValidEventOrInfoStatName(normalizedStat)) {
                invalidStatNames.add(normalizedStat);
                continue;
            }
            if (includeInfo && InfoStatName.isValidName(normalizedStat)) {
                InfoStatName infoStatName = InfoStatName.from(normalizedStat);
                if (!infoStatName.version().onOrBefore(minClusterVersion)) continue;
                searchRelevanceStatsInput.getInfoStatNames().add(InfoStatName.from(normalizedStat));
                continue;
            }
            if (!includeEvents || !EventStatName.isValidName(normalizedStat) || !(eventStatName = EventStatName.from(normalizedStat)).version().onOrBefore(minClusterVersion)) continue;
            searchRelevanceStatsInput.getEventStatNames().add(EventStatName.from(normalizedStat));
        }
        if (!invalidStatNames.isEmpty()) {
            throw new IllegalArgumentException(this.unrecognized(request, invalidStatNames, Sets.union(EVENT_STAT_NAMES, INFO_STAT_NAMES), STAT_PARAM));
        }
    }

    private void addAllStats(SearchRelevanceStatsInput searchRelevanceStatsInput, Version minVersion) {
        if (minVersion == Version.CURRENT) {
            if (searchRelevanceStatsInput.isIncludeInfo()) {
                searchRelevanceStatsInput.getInfoStatNames().addAll(EnumSet.allOf(InfoStatName.class));
            }
            if (searchRelevanceStatsInput.isIncludeEvents()) {
                searchRelevanceStatsInput.getEventStatNames().addAll(EnumSet.allOf(EventStatName.class));
            }
        } else {
            if (searchRelevanceStatsInput.isIncludeInfo()) {
                searchRelevanceStatsInput.getInfoStatNames().addAll(EnumSet.allOf(InfoStatName.class).stream().filter(statName -> statName.version().onOrBefore(minVersion)).collect(Collectors.toCollection(() -> EnumSet.noneOf(InfoStatName.class))));
            }
            if (searchRelevanceStatsInput.isIncludeEvents()) {
                searchRelevanceStatsInput.getEventStatNames().addAll(EnumSet.allOf(EventStatName.class).stream().filter(statName -> statName.version().onOrBefore(minVersion)).collect(Collectors.toCollection(() -> EnumSet.noneOf(EventStatName.class))));
            }
        }
    }

    private boolean isValidEventOrInfoStatName(String statName) {
        return InfoStatName.isValidName(statName) || EventStatName.isValidName(statName);
    }

    private Optional<String[]> splitCommaSeparatedParam(RestRequest request, String paramName) {
        return Optional.ofNullable(request.param(paramName)).map(s -> s.split(","));
    }

    private boolean isValidNodeId(String nodeId) {
        return RestSearchRelevanceStatsAction.isValidParamString(nodeId) && nodeId.length() == 22;
    }

    @Generated
    public RestSearchRelevanceStatsAction(SearchRelevanceSettingsAccessor settingsAccessor, ClusterUtil clusterUtil) {
        this.settingsAccessor = settingsAccessor;
        this.clusterUtil = clusterUtil;
    }
}

