/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.experiment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.cache.Cache;
import org.opensearch.common.cache.CacheBuilder;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.searchrelevance.dao.JudgmentDao;
import org.opensearch.searchrelevance.executors.ExperimentTaskManager;
import org.opensearch.searchrelevance.model.AsyncStatus;
import org.opensearch.searchrelevance.model.ExperimentType;
import org.opensearch.searchrelevance.model.ExperimentVariant;
import org.opensearch.searchrelevance.model.SearchConfigurationDetails;
import org.opensearch.searchrelevance.scheduler.ExperimentCancellationToken;
import org.opensearch.searchrelevance.utils.TimeUtils;

public class PointwiseExperimentProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(PointwiseExperimentProcessor.class);
    private final JudgmentDao judgmentDao;
    private final ExperimentTaskManager taskManager;
    private final Cache<String, Map<String, String>> judgmentCache;
    private static final long CACHE_SIZE = 100000L;
    private static final TimeValue CACHE_EXPIRE_TIME = TimeValue.timeValueHours((long)1L);

    public PointwiseExperimentProcessor(JudgmentDao judgmentDao, ExperimentTaskManager taskManager) {
        this.judgmentDao = judgmentDao;
        this.taskManager = taskManager;
        this.judgmentCache = CacheBuilder.builder().setMaximumWeight(100000L).setExpireAfterAccess(CACHE_EXPIRE_TIME).build();
    }

    public void processPointwiseExperiment(String experimentId, String queryText, Map<String, SearchConfigurationDetails> searchConfigurations, List<String> judgmentList, int size, AtomicBoolean hasFailure, String scheduledRunId, ExperimentCancellationToken cancellationToken, ActionListener<Map<String, Object>> listener) {
        log.info("Starting pointwise experiment {} with {} search configurations for query: {}", (Object)experimentId, (Object)searchConfigurations.size(), (Object)queryText);
        ((CompletableFuture)this.loadJudgmentsAsync(experimentId, judgmentList, queryText).thenAccept(docIdToScores -> {
            log.info("Loaded {} document ratings for experiment {}", (Object)docIdToScores.size(), (Object)experimentId);
            this.processExperimentWithJudgments(experimentId, queryText, searchConfigurations, judgmentList, size, (Map<String, String>)docIdToScores, hasFailure, scheduledRunId, cancellationToken, listener);
        })).exceptionally(e -> {
            if (hasFailure.compareAndSet(false, true)) {
                listener.onFailure(new Exception("Failed to load judgments", (Throwable)e));
            }
            return null;
        });
    }

    private CompletableFuture<Map<String, String>> loadJudgmentsAsync(String experimentId, List<String> judgmentList, String queryText) {
        String cacheKey = experimentId + ":" + queryText;
        Map cached = (Map)this.judgmentCache.get((Object)cacheKey);
        if (Objects.nonNull(cached)) {
            return CompletableFuture.completedFuture(cached);
        }
        AtomicInteger failureCount = new AtomicInteger(0);
        int failureThreshold = Math.min(5, judgmentList.size());
        List<CompletableFuture> judgmentFutures = judgmentList.stream().map(judgmentId -> {
            CompletableFuture future = new CompletableFuture();
            this.judgmentDao.getJudgment((String)judgmentId, (ActionListener<SearchResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
            return future;
        }).toList();
        return CompletableFuture.allOf(judgmentFutures.toArray(new CompletableFuture[0])).thenApply(v -> {
            HashMap<String, String> docIdToScores = new HashMap<String, String>();
            for (CompletableFuture future : judgmentFutures) {
                try {
                    SearchResponse response = (SearchResponse)future.join();
                    this.extractJudgmentScores(queryText, response, docIdToScores);
                }
                catch (Exception e) {
                    log.error("Failed to process judgment response: {}", (Object)e.getMessage());
                    if (failureCount.incrementAndGet() < failureThreshold) continue;
                    throw new RuntimeException(String.format(Locale.ROOT, "Failed to load judgments: exceeded failure threshold %d/%d", failureCount.get(), failureThreshold), e);
                }
            }
            this.judgmentCache.put((Object)cacheKey, docIdToScores);
            return docIdToScores;
        });
    }

    private void extractJudgmentScores(String queryText, SearchResponse response, Map<String, String> docIdToScores) {
        if (Objects.isNull(response.getHits()) || response.getHits().getTotalHits().value() == 0L) {
            return;
        }
        Map sourceAsMap = response.getHits().getHits()[0].getSourceAsMap();
        List judgmentRatings = sourceAsMap.getOrDefault("judgmentRatings", Collections.emptyList());
        for (Map rating : judgmentRatings) {
            if (!queryText.equals(rating.get("query"))) continue;
            List docScoreRatings = (List)rating.get("ratings");
            if (!Objects.nonNull(docScoreRatings)) break;
            docScoreRatings.forEach(docScoreRating -> docIdToScores.put((String)docScoreRating.get("docId"), (String)docScoreRating.get("rating")));
            break;
        }
    }

    private void processExperimentWithJudgments(String experimentId, String queryText, Map<String, SearchConfigurationDetails> searchConfigurations, List<String> judgmentList, int size, Map<String, String> docIdToScores, AtomicBoolean hasFailure, String scheduledRunId, ExperimentCancellationToken cancellationToken, ActionListener<Map<String, Object>> listener) {
        List<ExperimentVariant> experimentVariants = this.createPointwiseVariants(experimentId, searchConfigurations);
        ConcurrentHashMap configToExperimentVariants = new ConcurrentHashMap();
        ConcurrentLinkedQueue allResults = new ConcurrentLinkedQueue();
        List<CompletableFuture> configFutures = searchConfigurations.entrySet().stream().map(entry -> {
            String searchConfigId = (String)entry.getKey();
            SearchConfigurationDetails configDetails = (SearchConfigurationDetails)entry.getValue();
            String index = configDetails.getIndex();
            String query = configDetails.getQuery();
            List<ExperimentVariant> configVariants = experimentVariants.stream().filter(variant -> searchConfigId.equals(variant.getParameters().get("searchConfigId"))).collect(Collectors.toList());
            CompletableFuture<Map<String, Object>> configFuture = this.taskManager.scheduleTasksAsync(ExperimentType.POINTWISE_EVALUATION, experimentId, searchConfigId, index, query, queryText, size, configVariants, judgmentList, docIdToScores, configToExperimentVariants, hasFailure, scheduledRunId, null, cancellationToken);
            return ((CompletableFuture)configFuture.thenAccept(results -> {
                List configEvaluationResults = (List)results.get("evaluationResults");
                if (Objects.nonNull(configEvaluationResults) && !configEvaluationResults.isEmpty()) {
                    for (Map evalResult : configEvaluationResults) {
                        HashMap result = new HashMap();
                        result.put("evaluationId", evalResult.get("evaluationId"));
                        result.put("searchConfigurationId", searchConfigId);
                        result.put("queryText", queryText);
                        allResults.add(result);
                    }
                } else {
                    HashMap<String, String> result = new HashMap<String, String>();
                    result.put("queryText", queryText);
                    allResults.add(result);
                }
            })).exceptionally(ex -> {
                log.error("Failed to process config {}: {}", (Object)searchConfigId, (Object)ex.getMessage());
                return null;
            });
        }).collect(Collectors.toList());
        ((CompletableFuture)CompletableFuture.allOf(configFutures.toArray(new CompletableFuture[0])).thenAccept(v -> {
            HashMap queryResponse = new HashMap();
            queryResponse.put("results", new ArrayList(allResults));
            log.info("Completed pointwise experiment {} with {} results", (Object)experimentId, (Object)allResults.size());
            listener.onResponse(queryResponse);
        })).exceptionally(e -> {
            if (hasFailure.compareAndSet(false, true)) {
                listener.onFailure(new Exception("Failed to process search configurations", (Throwable)e));
            }
            return null;
        });
    }

    private List<ExperimentVariant> createPointwiseVariants(String experimentId, Map<String, SearchConfigurationDetails> searchConfigurations) {
        return searchConfigurations.entrySet().stream().map(entry -> {
            String searchConfigId = (String)entry.getKey();
            SearchConfigurationDetails configDetails = (SearchConfigurationDetails)entry.getValue();
            String searchPipeline = configDetails.getPipeline();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("searchConfigId", searchConfigId);
            parameters.put("searchPipeline", searchPipeline);
            return new ExperimentVariant(UUID.randomUUID().toString(), TimeUtils.getTimestamp(), ExperimentType.POINTWISE_EVALUATION, AsyncStatus.PROCESSING, experimentId, parameters, Map.of());
        }).collect(Collectors.toList());
    }
}

