/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.executors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.action.ActionListener;
import org.opensearch.searchrelevance.dao.ExperimentVariantDao;
import org.opensearch.searchrelevance.model.ExperimentBatchStatus;
import org.opensearch.searchrelevance.model.ExperimentType;
import org.opensearch.searchrelevance.model.ExperimentVariant;

public class ExperimentTaskContext {
    @Generated
    private static final Logger log = LogManager.getLogger(ExperimentTaskContext.class);
    private final String experimentId;
    private final String searchConfigId;
    private final String queryText;
    private final int totalVariants;
    private final ConcurrentHashMap<String, Object> configToExperimentVariants;
    private final CompletableFuture<Map<String, Object>> resultFuture;
    private final AtomicBoolean hasFailure;
    private final ExperimentVariantDao experimentVariantDao;
    private final ExperimentType experimentType;
    private final AtomicInteger remainingVariants;
    private final AtomicInteger successfulVariants;
    private final AtomicInteger failedVariants;

    public ExperimentTaskContext(String experimentId, String searchConfigId, String queryText, int totalVariants, ConcurrentHashMap<String, Object> configToExperimentVariants, CompletableFuture<Map<String, Object>> resultFuture, AtomicBoolean hasFailure, ExperimentVariantDao experimentVariantDao, ExperimentType experimentType) {
        this.experimentId = experimentId;
        this.searchConfigId = searchConfigId;
        this.queryText = queryText;
        this.totalVariants = totalVariants;
        this.configToExperimentVariants = configToExperimentVariants;
        this.resultFuture = resultFuture;
        this.hasFailure = hasFailure;
        this.experimentVariantDao = experimentVariantDao;
        this.experimentType = experimentType;
        this.remainingVariants = new AtomicInteger(totalVariants);
        this.successfulVariants = new AtomicInteger(0);
        this.failedVariants = new AtomicInteger(0);
        log.info("TaskContext initialized for experiment {} with {} variants", (Object)experimentId, (Object)totalVariants);
    }

    public void scheduleVariantWrite(ExperimentVariant variant, String evaluationId, boolean isSuccess) {
        ConcurrentHashMap map;
        if (isSuccess && (map = (ConcurrentHashMap)this.configToExperimentVariants.get(this.searchConfigId)) != null) {
            map.put(variant.getId(), evaluationId);
        }
        CompletableFuture.runAsync(() -> this.experimentVariantDao.putExperimentVariantEfficient(variant, ActionListener.wrap(response -> log.debug("write successful for variant: {}", (Object)variant.getId()), error -> log.error("write failed for variant {}: {}", (Object)variant.getId(), (Object)error.getMessage()))));
    }

    public void completeVariantSuccess() {
        this.successfulVariants.incrementAndGet();
        this.completeVariant();
    }

    public void completeVariantFailure() {
        this.failedVariants.incrementAndGet();
        this.completeVariant();
    }

    private void completeVariant() {
        if (this.remainingVariants.decrementAndGet() == 0) {
            this.finishExperiment();
        }
    }

    private void finishExperiment() {
        ExperimentBatchStatus status;
        HashMap<String, Object> transformedConfigToExperimentVariants = new HashMap<String, Object>();
        transformedConfigToExperimentVariants.put("searchConfigurationId", this.searchConfigId);
        List<Map<String, Object>> evaluationResults = this.formatEvaluationResults();
        transformedConfigToExperimentVariants.put("evaluationResults", evaluationResults);
        HashMap<String, Integer> summary = new HashMap<String, Integer>();
        summary.put("totalVariants", this.totalVariants);
        summary.put("successfulVariants", this.successfulVariants.get());
        summary.put("failedVariants", this.failedVariants.get());
        transformedConfigToExperimentVariants.put("summary", summary);
        if (this.failedVariants.get() == this.totalVariants) {
            log.error("All {} variants failed for search config {} in experiment {} with query '{}' - continuing experiment", (Object)this.totalVariants, (Object)this.searchConfigId, (Object)this.experimentId, (Object)this.queryText);
            status = ExperimentBatchStatus.ALL_FAILED;
        } else if (this.failedVariants.get() > 0) {
            log.warn("Partial failure for search config {} in experiment {} with query '{}': {}/{} variants succeeded", (Object)this.searchConfigId, (Object)this.experimentId, (Object)this.queryText, (Object)this.successfulVariants.get(), (Object)this.totalVariants);
            status = ExperimentBatchStatus.PARTIAL_SUCCESS;
        } else {
            status = ExperimentBatchStatus.SUCCESS;
        }
        transformedConfigToExperimentVariants.put("status", (Object)status);
        this.resultFuture.complete(transformedConfigToExperimentVariants);
    }

    private List<Map<String, Object>> formatEvaluationResults() {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        ConcurrentHashMap configMap = (ConcurrentHashMap)this.configToExperimentVariants.get(this.searchConfigId);
        if (this.experimentType == ExperimentType.POINTWISE_EVALUATION) {
            if (configMap != null && !configMap.isEmpty()) {
                configMap.forEach((variantId, evalId) -> {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    result.put("evaluationId", evalId);
                    result.put("searchConfigurationId", this.searchConfigId);
                    result.put("queryText", this.queryText);
                    results.add(result);
                });
            } else {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("queryText", this.queryText);
                results.add(result);
            }
        } else if (this.experimentType == ExperimentType.HYBRID_OPTIMIZER) {
            if (configMap != null) {
                configMap.forEach((variantId, evalId) -> {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    result.put("evaluationId", evalId);
                    result.put("experimentVariantId", variantId);
                    results.add(result);
                });
            }
        } else if (configMap != null && !configMap.isEmpty()) {
            configMap.forEach((variantId, evalId) -> {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("evaluationId", evalId);
                result.put("experimentVariantId", variantId);
                results.add(result);
            });
        }
        return results;
    }

    @Generated
    public String getExperimentId() {
        return this.experimentId;
    }

    @Generated
    public String getSearchConfigId() {
        return this.searchConfigId;
    }

    @Generated
    public String getQueryText() {
        return this.queryText;
    }

    @Generated
    public int getTotalVariants() {
        return this.totalVariants;
    }

    @Generated
    public ConcurrentHashMap<String, Object> getConfigToExperimentVariants() {
        return this.configToExperimentVariants;
    }

    @Generated
    public CompletableFuture<Map<String, Object>> getResultFuture() {
        return this.resultFuture;
    }

    @Generated
    public AtomicBoolean getHasFailure() {
        return this.hasFailure;
    }

    @Generated
    public ExperimentVariantDao getExperimentVariantDao() {
        return this.experimentVariantDao;
    }

    @Generated
    public ExperimentType getExperimentType() {
        return this.experimentType;
    }

    @Generated
    public AtomicInteger getRemainingVariants() {
        return this.remainingVariants;
    }

    @Generated
    public AtomicInteger getSuccessfulVariants() {
        return this.successfulVariants;
    }

    @Generated
    public AtomicInteger getFailedVariants() {
        return this.failedVariants;
    }
}

