/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.aggregation;

import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.lucene.index.LeafReaderContext;
import org.opensearch.script.AggregationScript;
import org.opensearch.search.lookup.SearchLookup;
import org.opensearch.search.lookup.SourceLookup;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.storage.script.core.CalciteScript;

class CalciteAggregationScript
extends AggregationScript {
    private final CalciteScript calciteScript;
    private final SourceLookup sourceLookup;
    private final RelDataType type;
    private final Map<String, Integer> parametersToIndex;

    public CalciteAggregationScript(Function1<DataContext, Object[]> function, RelDataType type, SearchLookup lookup, LeafReaderContext context, Map<String, Object> params, Map<String, Integer> parametersToIndex) {
        super(params, lookup, context);
        this.calciteScript = new CalciteScript(function, params);
        this.sourceLookup = lookup.getLeafSearchLookup(context).source();
        this.type = type;
        this.parametersToIndex = parametersToIndex;
    }

    public Object execute() {
        Object value = this.calciteScript.execute(this.getDoc(), this.sourceLookup, this.parametersToIndex)[0];
        ExprType exprType = OpenSearchTypeFactory.convertRelDataTypeToExprType(this.type);
        return switch ((ExprCoreType)exprType) {
            case ExprCoreType.TIME -> ChronoUnit.MILLIS.between(LocalTime.MIN, ExprValueUtils.fromObjectValue(value, ExprCoreType.TIME).timeValue());
            case ExprCoreType.DATE -> ExprValueUtils.fromObjectValue(value, ExprCoreType.DATE).timestampValue().toEpochMilli();
            case ExprCoreType.TIMESTAMP -> ExprValueUtils.fromObjectValue(value, ExprCoreType.TIMESTAMP).timestampValue().toEpochMilli();
            default -> value;
        };
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalciteAggregationScript)) {
            return false;
        }
        CalciteAggregationScript other = (CalciteAggregationScript)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        CalciteScript this$calciteScript = this.calciteScript;
        CalciteScript other$calciteScript = other.calciteScript;
        if (this$calciteScript == null ? other$calciteScript != null : !((Object)this$calciteScript).equals(other$calciteScript)) {
            return false;
        }
        SourceLookup this$sourceLookup = this.sourceLookup;
        SourceLookup other$sourceLookup = other.sourceLookup;
        if (this$sourceLookup == null ? other$sourceLookup != null : !this$sourceLookup.equals(other$sourceLookup)) {
            return false;
        }
        RelDataType this$type = this.type;
        RelDataType other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<String, Integer> this$parametersToIndex = this.parametersToIndex;
        Map<String, Integer> other$parametersToIndex = other.parametersToIndex;
        return !(this$parametersToIndex == null ? other$parametersToIndex != null : !((Object)this$parametersToIndex).equals(other$parametersToIndex));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalciteAggregationScript;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CalciteScript $calciteScript = this.calciteScript;
        result = result * 59 + ($calciteScript == null ? 43 : ((Object)$calciteScript).hashCode());
        SourceLookup $sourceLookup = this.sourceLookup;
        result = result * 59 + ($sourceLookup == null ? 43 : $sourceLookup.hashCode());
        RelDataType $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map<String, Integer> $parametersToIndex = this.parametersToIndex;
        result = result * 59 + ($parametersToIndex == null ? 43 : ((Object)$parametersToIndex).hashCode());
        return result;
    }
}

