/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class AttackRangedMessage
extends AttributeMessage {
    public static final String TAG = "attackRanged";
    private static final String UNIT_TAG = "unit";
    private static final String TARGET_TAG = "target";

    public AttackRangedMessage(Unit unit, Tile target) {
        super(TAG, UNIT_TAG, unit.getId(), TARGET_TAG, target.getId());
    }

    public AttackRangedMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG, TARGET_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Tile tile;
        Unit unit;
        String unitId = this.getStringAttribute(UNIT_TAG);
        String targetId = this.getStringAttribute(TARGET_TAG);
        try {
            unit = serverPlayer.getOurFreeColGameObject(unitId, Unit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        if (unit.getMovesLeft() <= 0) {
            return serverPlayer.clientError("No moves left.");
        }
        try {
            tile = freeColServer.getGame().getFreeColGameObject(targetId, Tile.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        if (!unit.canAttackRanged(tile)) {
            return serverPlayer.clientError("Illegal ranged attack for: " + unitId + " from: " + unit.getLocation().getId() + " to: " + tile.getId());
        }
        Unit defender = tile.getDefendingUnit(unit);
        if (defender == null) {
            return serverPlayer.clientError("Could not find defender in tile: " + tile.getId() + " from: " + unit.getLocation().getId());
        }
        return this.igc(freeColServer).combat(serverPlayer, unit, defender, null);
    }
}

