/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.core.scanner.VariantScript;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptEngineWrapper;
import org.zaproxy.zap.extension.script.ScriptWrapper;
import org.zaproxy.zap.model.SessionStructure;

public class VariantCustom
implements Variant {
    ExtensionScript extension = null;
    private ScriptWrapper wrapper = null;
    private boolean syncAccess;
    private VariantScript script = null;
    private final List<NameValuePair> params = new ArrayList<NameValuePair>();
    private NameValuePair currentParam;
    private static final Pattern BASE64_PATTERN = Pattern.compile("^[a-zA-Z0-9/+]+={0,2}$");
    private static final String SHORT_NAME = "script";

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    public VariantCustom(ScriptWrapper wrapper, ExtensionScript extension) {
        this.wrapper = wrapper;
        this.extension = extension;
        if (wrapper != null && extension != null && wrapper.isEnabled()) {
            try {
                this.script = extension.getInterface(wrapper, VariantScript.class);
                if (this.script == null) {
                    extension.handleFailedScriptInterface(wrapper, Constant.messages.getString("variant.scripts.interface.variant.error", wrapper.getName()));
                } else {
                    this.syncAccess = VariantCustom.isSyncAccess(wrapper);
                }
            }
            catch (Exception ex) {
                this.extension.handleScriptException(wrapper, ex);
            }
        }
    }

    private static boolean isSyncAccess(ScriptWrapper wrapper) {
        ScriptEngineWrapper engine = wrapper.getEngine();
        return engine != null && engine.isSingleThreaded();
    }

    public VariantCustom(ScriptWrapper wrapper, VariantScript script, ExtensionScript extension) {
        this.wrapper = wrapper;
        this.script = script;
        this.extension = extension;
        this.syncAccess = VariantCustom.isSyncAccess(wrapper);
    }

    @Override
    public void setMessage(HttpMessage msg) {
        this.execute(() -> {
            this.script.parseParameters(this, msg);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R execute(Callable<R> action) {
        if (this.script == null) {
            return null;
        }
        try {
            if (this.syncAccess) {
                VariantScript variantScript = this.script;
                synchronized (variantScript) {
                    return action.call();
                }
            }
            return action.call();
        }
        catch (Exception e) {
            this.extension.handleScriptException(this.wrapper, e);
            return null;
        }
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.params;
    }

    public String getParamName(int index) {
        return index < this.params.size() ? this.params.get(index).getName() : null;
    }

    public String getParamValue(int index) {
        return index < this.params.size() ? this.params.get(index).getValue() : null;
    }

    public int getParamNumber() {
        return this.params.size();
    }

    public NameValuePair getCurrentParam() {
        return this.currentParam;
    }

    public void addParam(String name, String value, int type) {
        this.params.add(new NameValuePair(type, name, value, this.params.size()));
    }

    public void addParamQuery(String name, String value) {
        this.addParam(name, value, 1);
    }

    public void addParamPost(String name, String value) {
        this.addParam(name, value, 2);
    }

    public void addParamHeader(String name, String value) {
        this.addParam(name, value, 8);
    }

    public String encodeBase64(String value) {
        return Base64.encodeBase64String((byte[])value.getBytes());
    }

    public String decodeBase64(String value) {
        return new String(Base64.decodeBase64((String)value));
    }

    public boolean isBase64(String value) {
        return BASE64_PATTERN.matcher(value).matches() && value.length() % 4 == 0;
    }

    @Override
    public String setParameter(HttpMessage msg, NameValuePair originalPair, String param, String value) {
        return this.setParameter(msg, originalPair, param, value, false);
    }

    @Override
    public String setEscapedParameter(HttpMessage msg, NameValuePair originalPair, String param, String value) {
        return this.setParameter(msg, originalPair, param, value, true);
    }

    public String getStandardLeafName(String nodeName, HttpMessage msg, List<NameValuePair> params) {
        return SessionStructure.getLeafName(nodeName, msg, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String setParameter(HttpMessage msg, NameValuePair originalPair, String paramName, String value, boolean escaped) {
        try {
            this.currentParam = originalPair;
            this.execute(() -> {
                this.script.setParameter(this, msg, paramName, value, escaped);
                return null;
            });
        }
        finally {
            this.currentParam = null;
        }
        return value;
    }

    @Override
    public String getLeafName(String nodeName, HttpMessage msg) {
        return this.execute(() -> this.script.getLeafName(this, nodeName, msg));
    }

    @Override
    public List<String> getTreePath(HttpMessage msg) {
        return this.execute(() -> this.script.getTreePath(this, msg));
    }
}

