/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.utils;

public class JavaSrcTextBuffer {
    private final StringBuilder buffer;
    private int tabCounter = 0;

    public JavaSrcTextBuffer() {
        this.buffer = new StringBuilder();
    }

    public JavaSrcTextBuffer(int capacity) {
        this.buffer = new StringBuilder(capacity);
    }

    public JavaSrcTextBuffer incIndent() {
        ++this.tabCounter;
        return this;
    }

    public JavaSrcTextBuffer decIndent() {
        if (this.tabCounter > 0) {
            --this.tabCounter;
        }
        return this;
    }

    public JavaSrcTextBuffer print(int value) {
        this.buffer.append(value);
        return this;
    }

    public JavaSrcTextBuffer print(boolean value) {
        this.buffer.append(value ? "true" : "false");
        return this;
    }

    public JavaSrcTextBuffer printf(String text, Object ... args) {
        this.buffer.append(String.format(text, args));
        return this;
    }

    public JavaSrcTextBuffer print(String text) {
        this.buffer.append(text);
        return this;
    }

    public JavaSrcTextBuffer clean() {
        this.buffer.setLength(0);
        this.buffer.trimToSize();
        return this;
    }

    public JavaSrcTextBuffer tab() {
        this.buffer.append('\t');
        return this;
    }

    public JavaSrcTextBuffer indent() {
        for (int i = 0; i < this.tabCounter; ++i) {
            this.tab();
        }
        return this;
    }

    public JavaSrcTextBuffer println() {
        this.buffer.append(String.format("%n", new Object[0]));
        return this;
    }

    public boolean isEmpty() {
        return this.buffer.length() == 0;
    }

    public JavaSrcTextBuffer println(String text) {
        return this.print(text).println();
    }

    public JavaSrcTextBuffer printLinesWithIndent(String text) {
        String[] splitted;
        for (String aSplitted : splitted = text.split("\n")) {
            this.indent().println(aSplitted);
        }
        return this;
    }

    public JavaSrcTextBuffer printCommentLinesWithIndent(String text) {
        String[] splitted;
        for (String aSplitted : splitted = text.split("\n")) {
            this.indent().print("// ").println(aSplitted);
        }
        return this;
    }

    public JavaSrcTextBuffer printCommentMultiLinesWithIndent(String text) {
        String[] splitted = text.split("\n");
        this.indent().println("/*");
        for (String aSplitted : splitted) {
            this.indent().print(" * ").println(aSplitted);
        }
        this.indent().println(" */");
        return this;
    }

    public JavaSrcTextBuffer printJavaDocLinesWithIndent(String text) {
        String[] splitted = text.split("\n");
        this.indent().println("/**");
        for (String aSplitted : splitted) {
            this.indent().print(" * ").println(aSplitted);
        }
        this.indent().println(" */");
        return this;
    }

    public String toString() {
        return this.buffer.toString();
    }
}

