/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public abstract class WeakReferenceList
implements Serializable,
Cloneable {
    private Object master;
    private Reference[] childs;
    private int size;
    private final int maxChilds;

    protected WeakReferenceList(int n) {
        this.maxChilds = n;
        this.childs = new Reference[n - 1];
    }

    protected final int getMaxChildCount() {
        return this.maxChilds;
    }

    protected Object getMaster() {
        return this.master;
    }

    protected abstract Object restoreChild(int var1);

    public Object get(int n) {
        if (this.isMaster(n)) {
            return this.master;
        }
        Reference reference = this.childs[this.getChildPos(n)];
        if (reference == null) {
            throw new IllegalStateException("State: " + n);
        }
        Object object = reference.get();
        if (object == null) {
            object = this.restoreChild(n);
            this.childs[this.getChildPos((int)n)] = this.createReference(object);
        }
        return object;
    }

    public void set(Object object, int n) {
        if (this.isMaster(n)) {
            this.master = object;
        } else {
            this.childs[this.getChildPos((int)n)] = this.createReference(object);
        }
    }

    private Reference createReference(Object object) {
        return new WeakReference<Object>(object);
    }

    public boolean add(Object object) {
        if (this.size == 0) {
            this.master = object;
            this.size = 1;
            return true;
        }
        if (this.size < this.getMaxChildCount()) {
            this.childs[this.size - 1] = this.createReference(object);
            ++this.size;
            return true;
        }
        return false;
    }

    protected boolean isMaster(int n) {
        return n % this.getMaxChildCount() == 0;
    }

    protected int getChildPos(int n) {
        return n % this.getMaxChildCount() - 1;
    }

    public int getSize() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Reference[] referenceArray = this.childs;
        try {
            this.childs = null;
            objectOutputStream.defaultWriteObject();
        }
        finally {
            this.childs = referenceArray;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.childs = new Reference[this.getMaxChildCount() - 1];
        for (int i = 0; i < this.childs.length; ++i) {
            this.childs[i] = this.createReference(null);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        WeakReferenceList weakReferenceList = (WeakReferenceList)super.clone();
        weakReferenceList.childs = (Reference[])this.childs.clone();
        return weakReferenceList;
    }
}

