untrusted comment: verify with openbsd-70-base.pub
RWR3KL+gSr4QZ0wJlGfioDa5+kXzR7+Z72daK221ugS5CPdw5ikHTeVp5I6r9IIYvlhq8FJzfFLsTJ4QHxpVsiRi8DNPY2tZLwI=

OpenBSD 7.0 errata 026, September 26, 2022:

In smtpd(8), possible use-after-free if TLS handshake fails for
outbound connections.

Apply by doing:
    signify -Vep /etc/signify/openbsd-70-base.pub -x 026_smtpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install smtpd:
    cd /usr/src/usr.sbin/smtpd
    make obj
    make
    make install

Index: usr.sbin/smtpd/mta_session.c
===================================================================
RCS file: /cvs/src/usr.sbin/smtpd/mta_session.c,v
retrieving revision 1.144
diff -u -p -r1.144 mta_session.c
--- usr.sbin/smtpd/mta_session.c	28 Jul 2021 19:39:50 -0000	1.144
+++ usr.sbin/smtpd/mta_session.c	22 Sep 2022 20:44:59 -0000
@@ -1212,6 +1212,8 @@ mta_io(struct io *io, int evt, void *arg
 		if (s->use_smtps) {
 			io_set_write(io);
 			mta_tls_init(s);
+			if (s->flags & MTA_FREE)
+				mta_free(s);
 		}
 		else {
 			mta_enter_state(s, MTA_BANNER);
@@ -1568,7 +1570,7 @@ mta_tls_init(struct mta_session *s)
 
 	if ((tls = tls_client()) == NULL) {
 		log_info("%016"PRIx64" mta closing reason=tls-failure", s->id);
-		mta_free(s);
+		s->flags |= MTA_FREE;
 		return;
 	}
 
@@ -1576,14 +1578,14 @@ mta_tls_init(struct mta_session *s)
 	if (tls_configure(tls, tls_config) == -1) {
 		log_info("%016"PRIx64" mta closing reason=tls-failure", s->id);
 		tls_free(tls);
-		mta_free(s);
+		s->flags |= MTA_FREE;
 		return;
 	}
 
 	if (io_connect_tls(s->io, tls, s->mxname) == -1) {
 		log_info("%016"PRIx64" mta closing reason=tls-connect-failed", s->id);
 		tls_free(tls);
-		mta_free(s);
+		s->flags |= MTA_FREE;
 	}
 }
 
