untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEqmELsQAW37LKKEGBYi2/72Uk63wmxios0nAyDTjKsTyR9iJUaJzgg7R7PjlmbseaxzYgApjpdx4wbFiODVdYgc=

OpenBSD 6.1 errata 020, August 3, 2017:

Missing socket address validation from userland may result in an info leak.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 020_sockaddr.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/uipc_syscalls.c
===================================================================
RCS file: /cvs/src/sys/kern/uipc_syscalls.c,v
diff -u -p -u -r1.151 -r1.151.4.2
--- sys/kern/uipc_syscalls.c	27 Mar 2017 11:45:49 -0000	1.151
+++ sys/kern/uipc_syscalls.c	1 Aug 2017 22:21:24 -0000	1.151.4.2
@@ -1110,8 +1110,10 @@ sockargs(struct mbuf **mp, const void *b
 	 * We can't allow socket names > UCHAR_MAX in length, since that
 	 * will overflow sa_len. Also, control data more than MCLBYTES in
 	 * length is just too much.
+	 * Memory for sa_len and sa_family must exist.
 	 */
-	if (buflen > (type == MT_SONAME ? UCHAR_MAX : MCLBYTES))
+	if ((buflen > (type == MT_SONAME ? UCHAR_MAX : MCLBYTES)) ||
+	    (type == MT_SONAME && buflen < offsetof(struct sockaddr, sa_data)))
 		return (EINVAL);
 
 	/* Allocate an mbuf to hold the arguments. */
