untrusted comment: signature from openbsd 5.8 base secret key
RWQNNZXtC/MqP2nmFOJoJEBUMmj/EfID/wuSET1aOvaazk0I11wt0dIOUp6FcwtC3e0ryPujBpAf1dOpXFLXReisdFTd9dVr/Qs=

OpenBSD 5.8 errata 27, Aug 06, 2016:

Don't look in the current working directory for perl modules to load.
Running perl in a directory writable by an attacker would allow them
to provide code that could be executed.

This is version 2 of the patchfile.

Apply by doing:
    signify -Vep /etc/signify/openbsd-58-base.pub -x 027_perl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install perl:
    cd /usr/src/gnu/usr.bin/perl/
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper depend
    make -f Makefile.bsd-wrapper
    make -f Makefile.bsd-wrapper install


Index: gnu/usr.bin/perl/patchlevel.h
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/patchlevel.h,v
retrieving revision 1.38
diff -u -p -r1.38 patchlevel.h
--- gnu/usr.bin/perl/patchlevel.h	25 Apr 2015 19:14:37 -0000	1.38
+++ gnu/usr.bin/perl/patchlevel.h	5 Aug 2016 16:34:21 -0000
@@ -135,6 +135,7 @@ static const char * const local_patches[
 	NULL
 #ifdef PERL_GIT_UNCOMMITTED_CHANGES
 	,"uncommitted-changes"
+	,"CVE-2016-1238"
 #endif
 	PERL_GIT_UNPUSHED_COMMITS    	/* do not remove this line */
 	,NULL
Index: gnu/usr.bin/perl/cpan/Archive-Tar/bin/ptar
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Archive-Tar/bin/ptar,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 ptar
--- gnu/usr.bin/perl/cpan/Archive-Tar/bin/ptar	24 Mar 2014 14:58:49 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Archive-Tar/bin/ptar	5 Aug 2016 16:34:22 -0000
@@ -1,6 +1,7 @@
 #!/usr/bin/perl
 use strict;
 
+BEGIN { pop @INC if $INC[-1] eq '.' }
 use File::Find;
 use Getopt::Std;
 use Archive::Tar;
Index: gnu/usr.bin/perl/cpan/Archive-Tar/bin/ptardiff
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Archive-Tar/bin/ptardiff,v
retrieving revision 1.1.1.2
diff -u -p -r1.1.1.2 ptardiff
--- gnu/usr.bin/perl/cpan/Archive-Tar/bin/ptardiff	25 Mar 2013 20:06:43 -0000	1.1.1.2
+++ gnu/usr.bin/perl/cpan/Archive-Tar/bin/ptardiff	5 Aug 2016 16:34:22 -0000
@@ -1,5 +1,6 @@
 #!/usr/bin/perl
 
+BEGIN { pop @INC if $INC[-1] eq '.' }
 use strict;
 use Archive::Tar;
 use Getopt::Std;
Index: gnu/usr.bin/perl/cpan/Archive-Tar/bin/ptargrep
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Archive-Tar/bin/ptargrep,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 ptargrep
--- gnu/usr.bin/perl/cpan/Archive-Tar/bin/ptargrep	25 Mar 2013 20:06:43 -0000	1.1.1.1
+++ gnu/usr.bin/perl/cpan/Archive-Tar/bin/ptargrep	5 Aug 2016 16:34:22 -0000
@@ -4,6 +4,7 @@
 # archive.  See 'ptargrep --help' for more documentation.
 #
 
+BEGIN { pop @INC if $INC[-1] eq '.' }
 use strict;
 use warnings;
 
Index: gnu/usr.bin/perl/cpan/Archive-Tar/lib/Archive/Tar.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Archive-Tar/lib/Archive/Tar.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Tar.pm
--- gnu/usr.bin/perl/cpan/Archive-Tar/lib/Archive/Tar.pm	17 Nov 2014 20:52:41 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Archive-Tar/lib/Archive/Tar.pm	5 Aug 2016 16:34:22 -0000
@@ -31,7 +31,7 @@ use vars qw[$DEBUG $error $VERSION $WARN
 $DEBUG                  = 0;
 $WARN                   = 1;
 $FOLLOW_SYMLINK         = 0;
-$VERSION                = "1.96";
+$VERSION                = "1.96_01";
 $CHOWN                  = 1;
 $CHMOD                  = 1;
 $SAME_PERMISSIONS       = $> == 0 ? 1 : 0;
Index: gnu/usr.bin/perl/cpan/Archive-Tar/lib/Archive/Tar/Constant.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Archive-Tar/lib/Archive/Tar/Constant.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Constant.pm
--- gnu/usr.bin/perl/cpan/Archive-Tar/lib/Archive/Tar/Constant.pm	17 Nov 2014 20:52:41 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Archive-Tar/lib/Archive/Tar/Constant.pm	5 Aug 2016 16:34:22 -0000
@@ -3,7 +3,7 @@ package Archive::Tar::Constant;
 BEGIN {
     require Exporter;
 
-    $VERSION    = '1.96';
+    $VERSION    = '1.96_01';
     @ISA        = qw[Exporter];
 
     require Time::Local if $^O eq "MacOS";
Index: gnu/usr.bin/perl/cpan/Archive-Tar/lib/Archive/Tar/File.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Archive-Tar/lib/Archive/Tar/File.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 File.pm
--- gnu/usr.bin/perl/cpan/Archive-Tar/lib/Archive/Tar/File.pm	17 Nov 2014 20:52:41 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Archive-Tar/lib/Archive/Tar/File.pm	5 Aug 2016 16:34:22 -0000
@@ -13,7 +13,7 @@ use Archive::Tar::Constant;
 
 use vars qw[@ISA $VERSION];
 #@ISA        = qw[Archive::Tar];
-$VERSION    = '1.96';
+$VERSION    = '1.96_01';
 
 ### set value to 1 to oct() it during the unpack ###
 
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 CPAN.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN.pm	17 Nov 2014 20:52:42 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN.pm	5 Aug 2016 16:34:22 -0000
@@ -2,7 +2,7 @@
 # vim: ts=4 sts=4 sw=4:
 use strict;
 package CPAN;
-$CPAN::VERSION = '2.05';
+$CPAN::VERSION = '2.05_01';
 $CPAN::VERSION =~ s/_//;
 
 # we need to run chdir all over and we would get at wrong libraries
@@ -1090,6 +1090,8 @@ sub has_usable {
                                ]
               };
     if ($usable->{$mod}) {
+        local @INC = @INC;
+        pop @INC if $INC[-1] eq '.';
         for my $c (0..$#{$usable->{$mod}}) {
             my $code = $usable->{$mod}[$c];
             my $ret = eval { &$code() };
@@ -1118,6 +1120,8 @@ sub has_inst {
       $CPAN::META->{dontload_hash}{$mod}||=1; # unsafe meta access, ok
       return 0;
     }
+    local @INC = @INC;
+    pop @INC if $INC[-1] eq '.';
     my $file = $mod;
     my $obj;
     $file =~ s|::|/|g;
Index: gnu/usr.bin/perl/cpan/CPAN/lib/App/Cpan.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/App/Cpan.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Cpan.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/App/Cpan.pm	17 Nov 2014 20:52:42 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/CPAN/lib/App/Cpan.pm	5 Aug 2016 16:34:22 -0000
@@ -6,7 +6,7 @@ use vars qw($VERSION);
 
 use if $] < 5.008 => "IO::Scalar";
 
-$VERSION = '1.62';
+$VERSION = '1.62_01';
 
 =head1 NAME
 
@@ -458,9 +458,20 @@ sub AUTOLOAD { 1 }
 sub DESTROY { 1 }
 }
 
+# load a module without searching the default entry for the current
+# directory
+sub _safe_load_module {
+  my $name = shift;
+
+  local @INC = @INC;
+  pop @INC if $INC[-1] eq '.';
+
+  eval "require $name; 1";
+}
+
 sub _init_logger
 	{
-	my $log4perl_loaded = eval "require Log::Log4perl; 1";
+	my $log4perl_loaded = _safe_load_module("Log::Log4perl");
 
     unless( $log4perl_loaded )
         {
@@ -898,7 +909,7 @@ sub _load_local_lib # -I
 	{
 	$logger->debug( "Loading local::lib" );
 
-	my $rc = eval { require local::lib; 1; };
+	my $rc = _safe_load_module("local::lib");
 	unless( $rc ) {
 		$logger->die( "Could not load local::lib" );
 		}
@@ -1013,7 +1024,7 @@ sub _get_file
 	{
 	my $path = shift;
 
-	my $loaded = eval "require LWP::Simple; 1;";
+	my $loaded = _safe_load_module("LWP::Simple");
 	croak "You need LWP::Simple to use features that fetch files from CPAN\n"
 		unless $loaded;
 
@@ -1035,7 +1046,7 @@ sub _gitify
 	{
 	my $args = shift;
 
-	my $loaded = eval "require Archive::Extract; 1;";
+	my $loaded = _safe_load_module("Archive::Extract");
 	croak "You need Archive::Extract to use features that gitify distributions\n"
 		unless $loaded;
 
@@ -1099,7 +1110,7 @@ sub _show_Changes
 sub _get_changes_file
 	{
 	croak "Reading Changes files requires LWP::Simple and URI\n"
-		unless eval "require LWP::Simple; require URI; 1";
+		unless _safe_load_module("LWP::Simple") && _safe_load_module("URI");
 
     my $url = shift;
 
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Author.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Author.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Author.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Author.pm	25 Apr 2015 19:10:15 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Author.pm	5 Aug 2016 16:34:22 -0000
@@ -8,7 +8,7 @@ use CPAN::InfoObj;
 use vars qw(
             $VERSION
 );
-$VERSION = "5.5002";
+$VERSION = "5.5002_01";
 
 package CPAN::Author;
 use strict;
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Bundle.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Bundle.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 Bundle.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Bundle.pm	17 Nov 2014 20:52:42 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Bundle.pm	5 Aug 2016 16:34:23 -0000
@@ -8,7 +8,7 @@ use CPAN::Module;
 use vars qw(
             $VERSION
 );
-$VERSION = "5.5001";
+$VERSION = "5.5001_01";
 
 sub look {
     my $self = shift;
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/CacheMgr.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/CacheMgr.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 CacheMgr.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/CacheMgr.pm	25 Apr 2015 19:10:15 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/CacheMgr.pm	5 Aug 2016 16:34:23 -0000
@@ -10,7 +10,7 @@ use File::Find;
 use vars qw(
             $VERSION
 );
-$VERSION = "5.5002";
+$VERSION = "5.5002_01";
 
 package CPAN::CacheMgr;
 use strict;
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Complete.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Complete.pm,v
retrieving revision 1.1.1.2
diff -u -p -r1.1.1.2 Complete.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Complete.pm	17 Nov 2014 20:52:42 -0000	1.1.1.2
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Complete.pm	5 Aug 2016 16:34:23 -0000
@@ -42,7 +42,7 @@ use strict;
 use vars qw(
             $VERSION
 );
-$VERSION = "5.5001";
+$VERSION = "5.5001_01";
 
 package CPAN::Complete;
 use strict;
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Debug.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Debug.pm,v
retrieving revision 1.1.1.2
diff -u -p -r1.1.1.2 Debug.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Debug.pm	24 Mar 2014 14:58:49 -0000	1.1.1.2
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Debug.pm	5 Aug 2016 16:34:23 -0000
@@ -3,7 +3,7 @@ package CPAN::Debug;
 use strict;
 use vars qw($VERSION);
 
-$VERSION = "5.5001";
+$VERSION = "5.5001_01";
 # module is internal to CPAN.pm
 
 %CPAN::DEBUG = qw[
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/DeferredCode.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/DeferredCode.pm,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 DeferredCode.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/DeferredCode.pm	24 Sep 2010 14:49:06 -0000	1.1.1.1
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/DeferredCode.pm	5 Aug 2016 16:34:23 -0000
@@ -7,7 +7,7 @@ use overload fallback => 1, map { ($_ =>
     bool "" 0+
 /;
 
-$VERSION = "5.50";
+$VERSION = "5.50_01";
 
 sub run {
     $_[0]->();
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Distribution.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Distribution.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Distribution.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Distribution.pm	17 Nov 2014 20:52:42 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Distribution.pm	5 Aug 2016 16:34:23 -0000
@@ -9,7 +9,7 @@ use CPAN::InfoObj;
 use File::Path ();
 @CPAN::Distribution::ISA = qw(CPAN::InfoObj);
 use vars qw($VERSION);
-$VERSION = "2.02";
+$VERSION = "2.02_01";
 
 # Accessors
 sub cpan_comment {
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Distroprefs.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Distroprefs.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 Distroprefs.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Distroprefs.pm	17 Nov 2014 20:52:42 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Distroprefs.pm	5 Aug 2016 16:34:23 -0000
@@ -6,7 +6,7 @@ use strict;
 package CPAN::Distroprefs;
 
 use vars qw($VERSION);
-$VERSION = '6.0001';
+$VERSION = '6.0001_01';
 
 package CPAN::Distroprefs::Result;
 
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Distrostatus.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Distrostatus.pm,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 Distrostatus.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Distrostatus.pm	24 Sep 2010 14:49:06 -0000	1.1.1.1
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Distrostatus.pm	5 Aug 2016 16:34:23 -0000
@@ -7,7 +7,7 @@ use vars qw($something_has_failed_at);
 use vars qw(
             $VERSION
 );
-$VERSION = "5.5";
+$VERSION = "5.5_01";
 
 
 sub new {
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/FTP.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/FTP.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 FTP.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/FTP.pm	25 Apr 2015 19:10:15 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/FTP.pm	5 Aug 2016 16:34:23 -0000
@@ -14,7 +14,7 @@ use vars qw($connect_to_internet_ok $Ua 
 use vars qw(
             $VERSION
 );
-$VERSION = "5.5006";
+$VERSION = "5.5006_01";
 
 #-> sub CPAN::FTP::ftp_statistics
 # if they want to rewrite, they need to pass in a filehandle
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/FirstTime.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/FirstTime.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 FirstTime.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/FirstTime.pm	17 Nov 2014 20:52:42 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/FirstTime.pm	5 Aug 2016 16:34:23 -0000
@@ -10,7 +10,7 @@ use File::Path ();
 use File::Spec ();
 use CPAN::Mirrors ();
 use vars qw($VERSION $auto_config);
-$VERSION = "5.5306";
+$VERSION = "5.5306_01";
 
 =head1 NAME
 
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/HandleConfig.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/HandleConfig.pm,v
retrieving revision 1.1.1.5
diff -u -p -r1.1.1.5 HandleConfig.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/HandleConfig.pm	25 Apr 2015 19:10:15 -0000	1.1.1.5
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/HandleConfig.pm	5 Aug 2016 16:34:23 -0000
@@ -12,7 +12,7 @@ CPAN::HandleConfig - internal configurat
 
 =cut 
 
-$VERSION = "5.5005"; # see also CPAN::Config::VERSION at end of file
+$VERSION = "5.5005_01"; # see also CPAN::Config::VERSION at end of file
 
 %can = (
         commit   => "Commit changes to disk",
@@ -768,7 +768,7 @@ sub prefs_lookup {
 
     use strict;
     use vars qw($AUTOLOAD $VERSION);
-    $VERSION = "5.5005";
+    $VERSION = "5.5005_01";
 
     # formerly CPAN::HandleConfig was known as CPAN::Config
     sub AUTOLOAD { ## no critic
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Index.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Index.pm,v
retrieving revision 1.1.1.5
diff -u -p -r1.1.1.5 Index.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Index.pm	25 Apr 2015 19:10:15 -0000	1.1.1.5
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Index.pm	5 Aug 2016 16:34:23 -0000
@@ -1,7 +1,7 @@
 package CPAN::Index;
 use strict;
 use vars qw($LAST_TIME $DATE_OF_02 $DATE_OF_03 $HAVE_REANIMATED $VERSION);
-$VERSION = "1.9601";
+$VERSION = "1.9601_01";
 @CPAN::Index::ISA = qw(CPAN::Debug);
 $LAST_TIME ||= 0;
 $DATE_OF_03 ||= 0;
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/InfoObj.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/InfoObj.pm,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 InfoObj.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/InfoObj.pm	24 Sep 2010 14:49:06 -0000	1.1.1.1
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/InfoObj.pm	5 Aug 2016 16:34:23 -0000
@@ -11,7 +11,7 @@ use Cwd qw(chdir);
 use vars qw(
             $VERSION
 );
-$VERSION = "5.5";
+$VERSION = "5.5_01";
 
 sub ro {
     my $self = shift;
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Kwalify.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Kwalify.pm,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 Kwalify.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Kwalify.pm	24 Sep 2010 14:49:06 -0000	1.1.1.1
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Kwalify.pm	5 Aug 2016 16:34:23 -0000
@@ -49,7 +49,7 @@ use strict;
 
 package CPAN::Kwalify;
 use vars qw($VERSION $VAR1);
-$VERSION = "5.50";
+$VERSION = "5.50_01";
 
 use File::Spec ();
 
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Mirrors.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Mirrors.pm,v
retrieving revision 1.1.1.5
diff -u -p -r1.1.1.5 Mirrors.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Mirrors.pm	25 Apr 2015 19:10:15 -0000	1.1.1.5
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Mirrors.pm	5 Aug 2016 16:34:23 -0000
@@ -34,7 +34,7 @@ CPAN::Mirrors - Get CPAN mirror informat
 package CPAN::Mirrors;
 use strict;
 use vars qw($VERSION $urllist $silent);
-$VERSION = "1.9601";
+$VERSION = "1.9601_01";
 
 use Carp;
 use FileHandle;
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Module.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Module.pm,v
retrieving revision 1.1.1.2
diff -u -p -r1.1.1.2 Module.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Module.pm	25 Mar 2013 20:06:54 -0000	1.1.1.2
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Module.pm	5 Aug 2016 16:34:23 -0000
@@ -7,7 +7,7 @@ use strict;
 use vars qw(
             $VERSION
 );
-$VERSION = "5.5001";
+$VERSION = "5.5001_01";
 
 BEGIN {
     # alarm() is not implemented in perl 5.6.x and earlier under Windows
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Nox.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Nox.pm,v
retrieving revision 1.1.1.2
diff -u -p -r1.1.1.2 Nox.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Nox.pm	24 Mar 2014 14:58:49 -0000	1.1.1.2
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Nox.pm	5 Aug 2016 16:34:23 -0000
@@ -10,7 +10,7 @@ use Exporter ();
 @CPAN::ISA = ('Exporter');
 use CPAN;
 
-$VERSION = "5.5001";
+$VERSION = "5.5001_01";
 $CPAN::META->has_inst('Digest::MD5','no');
 $CPAN::META->has_inst('LWP','no');
 $CPAN::META->has_inst('Compress::Zlib','no');
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Prompt.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Prompt.pm,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 Prompt.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Prompt.pm	24 Sep 2010 14:49:06 -0000	1.1.1.1
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Prompt.pm	5 Aug 2016 16:34:23 -0000
@@ -6,7 +6,7 @@ use vars qw($prompt);
 use vars qw(
             $VERSION
 );
-$VERSION = "5.5";
+$VERSION = "5.5_01";
 
 
 $prompt = "cpan> ";
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Queue.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Queue.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Queue.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Queue.pm	17 Nov 2014 20:52:42 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Queue.pm	5 Aug 2016 16:34:23 -0000
@@ -72,7 +72,7 @@ package CPAN::Queue;
 # in CPAN::Distribution::rematein.
 
 use vars qw{ @All $VERSION };
-$VERSION = "5.5002";
+$VERSION = "5.5002_01";
 
 # CPAN::Queue::queue_item ;
 sub queue_item {
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Shell.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Shell.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 Shell.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Shell.pm	17 Nov 2014 20:52:43 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Shell.pm	5 Aug 2016 16:34:23 -0000
@@ -47,7 +47,7 @@ use vars qw(
              "CPAN/Tarzip.pm",
              "CPAN/Version.pm",
             );
-$VERSION = "5.5004";
+$VERSION = "5.5004_01";
 # record the initial timestamp for reload.
 $reload = { map {$INC{$_} ? ($_,(stat $INC{$_})[9]) : ()} @relo };
 @CPAN::Shell::ISA = qw(CPAN::Debug);
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Tarzip.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Tarzip.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Tarzip.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Tarzip.pm	17 Nov 2014 20:52:43 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Tarzip.pm	5 Aug 2016 16:34:23 -0000
@@ -4,7 +4,7 @@ use strict;
 use vars qw($VERSION @ISA $BUGHUNTING);
 use CPAN::Debug;
 use File::Basename qw(basename);
-$VERSION = "5.5012";
+$VERSION = "5.5012_01";
 # module is internal to CPAN.pm
 
 @ISA = qw(CPAN::Debug); ## no critic
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/URL.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/URL.pm,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 URL.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/URL.pm	24 Sep 2010 14:49:06 -0000	1.1.1.1
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/URL.pm	5 Aug 2016 16:34:23 -0000
@@ -8,7 +8,7 @@ use overload '""' => "as_string", fallba
 use vars qw(
             $VERSION
 );
-$VERSION = "5.5";
+$VERSION = "5.5_01";
 
 sub new {
     my($class,%args) = @_;
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Version.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Version.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 Version.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Version.pm	17 Nov 2014 20:52:43 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Version.pm	5 Aug 2016 16:34:23 -0000
@@ -2,7 +2,7 @@ package CPAN::Version;
 
 use strict;
 use vars qw($VERSION);
-$VERSION = "5.5003";
+$VERSION = "5.5003_01";
 
 # CPAN::Version::vcmp courtesy Jost Krieger
 sub vcmp {
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Exception/RecursiveDependency.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Exception/RecursiveDependency.pm,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 RecursiveDependency.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Exception/RecursiveDependency.pm	24 Sep 2010 14:49:06 -0000	1.1.1.1
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Exception/RecursiveDependency.pm	5 Aug 2016 16:34:23 -0000
@@ -7,7 +7,7 @@ use overload '""' => "as_string";
 use vars qw(
             $VERSION
 );
-$VERSION = "5.5";
+$VERSION = "5.5_01";
 
 # a module sees its distribution (no version)
 # a distribution sees its prereqs (which are module names) (usually with versions)
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Exception/blocked_urllist.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Exception/blocked_urllist.pm,v
retrieving revision 1.1.1.2
diff -u -p -r1.1.1.2 blocked_urllist.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Exception/blocked_urllist.pm	25 Mar 2013 20:06:54 -0000	1.1.1.2
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Exception/blocked_urllist.pm	5 Aug 2016 16:34:23 -0000
@@ -7,7 +7,7 @@ use overload '""' => "as_string";
 use vars qw(
             $VERSION
 );
-$VERSION = "1.001";
+$VERSION = "1.001_01";
 
 
 sub new {
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Exception/yaml_not_installed.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Exception/yaml_not_installed.pm,v
retrieving revision 1.1.1.2
diff -u -p -r1.1.1.2 yaml_not_installed.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Exception/yaml_not_installed.pm	25 Mar 2013 20:06:54 -0000	1.1.1.2
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Exception/yaml_not_installed.pm	5 Aug 2016 16:34:23 -0000
@@ -7,7 +7,7 @@ use overload '""' => "as_string";
 use vars qw(
             $VERSION
 );
-$VERSION = "5.5";
+$VERSION = "5.5_01";
 
 
 sub new {
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Exception/yaml_process_error.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Exception/yaml_process_error.pm,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 yaml_process_error.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Exception/yaml_process_error.pm	25 Mar 2013 20:06:54 -0000	1.1.1.1
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/Exception/yaml_process_error.pm	5 Aug 2016 16:34:23 -0000
@@ -7,7 +7,7 @@ use overload '""' => "as_string";
 use vars qw(
             $VERSION
 );
-$VERSION = "5.5";
+$VERSION = "5.5_01";
 
 
 sub new {
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/FTP/netrc.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/FTP/netrc.pm,v
retrieving revision 1.1.1.2
diff -u -p -r1.1.1.2 netrc.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/FTP/netrc.pm	25 Mar 2013 20:06:54 -0000	1.1.1.2
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/FTP/netrc.pm	5 Aug 2016 16:34:23 -0000
@@ -1,7 +1,7 @@
 package CPAN::FTP::netrc;
 use strict;
 
-$CPAN::FTP::netrc::VERSION = $CPAN::FTP::netrc::VERSION = "1.01";
+$CPAN::FTP::netrc::VERSION = $CPAN::FTP::netrc::VERSION = "1.01_01";
 
 # package CPAN::FTP::netrc;
 sub new {
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/HTTP/Client.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/HTTP/Client.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 Client.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/HTTP/Client.pm	25 Apr 2015 19:10:15 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/HTTP/Client.pm	5 Aug 2016 16:34:23 -0000
@@ -6,7 +6,7 @@ use vars qw(@ISA);
 use CPAN::HTTP::Credentials;
 use HTTP::Tiny 0.005;
 
-$CPAN::HTTP::Client::VERSION = $CPAN::HTTP::Client::VERSION = "1.9601";
+$CPAN::HTTP::Client::VERSION = $CPAN::HTTP::Client::VERSION = "1.9601_01";
 
 # CPAN::HTTP::Client is adapted from parts of cpanm by Tatsuhiko Miyagawa
 # and parts of LWP by Gisle Aas
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/HTTP/Credentials.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/HTTP/Credentials.pm,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 Credentials.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/HTTP/Credentials.pm	25 Mar 2013 20:06:54 -0000	1.1.1.1
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/HTTP/Credentials.pm	5 Aug 2016 16:34:23 -0000
@@ -4,7 +4,7 @@ package CPAN::HTTP::Credentials;
 use strict;
 use vars qw($USER $PASSWORD $PROXY_USER $PROXY_PASSWORD);
 
-$CPAN::HTTP::Credentials::VERSION = $CPAN::HTTP::Credentials::VERSION = "1.9600";
+$CPAN::HTTP::Credentials::VERSION = $CPAN::HTTP::Credentials::VERSION = "1.9600_01";
 
 sub clear_credentials {
    _clear_non_proxy_credentials();
Index: gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/LWP/UserAgent.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/LWP/UserAgent.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 UserAgent.pm
--- gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/LWP/UserAgent.pm	25 Apr 2015 19:10:15 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/CPAN/lib/CPAN/LWP/UserAgent.pm	5 Aug 2016 16:34:23 -0000
@@ -6,7 +6,7 @@ use vars qw(@ISA $USER $PASSWD $SETUPDON
 use CPAN::HTTP::Credentials;
 # we delay requiring LWP::UserAgent and setting up inheritance until we need it
 
-$CPAN::LWP::UserAgent::VERSION = $CPAN::LWP::UserAgent::VERSION = "1.9601";
+$CPAN::LWP::UserAgent::VERSION = $CPAN::LWP::UserAgent::VERSION = "1.9601_01";
 
 
 sub config {
Index: gnu/usr.bin/perl/cpan/CPAN/scripts/cpan
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/CPAN/scripts/cpan,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 cpan
--- gnu/usr.bin/perl/cpan/CPAN/scripts/cpan	17 Nov 2014 20:52:43 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/CPAN/scripts/cpan	5 Aug 2016 16:34:23 -0000
@@ -1,10 +1,11 @@
 #!/usr/local/bin/perl
 
+BEGIN { pop @INC if $INC[-1] eq '.' }
 use strict;
 use vars qw($VERSION);
 
 use App::Cpan '1.60_02';
-$VERSION = '1.61';
+$VERSION = '1.61_01';
 
 my $rc = App::Cpan->run( @ARGV );
 
Index: gnu/usr.bin/perl/cpan/Digest/Digest.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Digest/Digest.pm,v
retrieving revision 1.2
diff -u -p -r1.2 Digest.pm
--- gnu/usr.bin/perl/cpan/Digest/Digest.pm	11 Oct 2011 18:13:35 -0000	1.2
+++ gnu/usr.bin/perl/cpan/Digest/Digest.pm	5 Aug 2016 16:34:24 -0000
@@ -3,7 +3,7 @@ package Digest;
 use strict;
 use vars qw($VERSION %MMAP $AUTOLOAD);
 
-$VERSION = "1.17";
+$VERSION = "1.17_01";
 
 %MMAP = (
   "SHA-1"      => [["Digest::SHA", 1], "Digest::SHA1", ["Digest::SHA2", 1]],
@@ -38,7 +38,11 @@ sub new
         unless (exists ${"$class\::"}{"VERSION"}) {
             my $pm_file = $class . ".pm";
             $pm_file =~ s{::}{/}g;
-            eval { require $pm_file };
+            eval {
+                local @INC = @INC;
+                pop @INC if $INC[-1] eq '.';
+                require $pm_file
+	    };
             if ($@) {
                 $err ||= $@;
                 next;
Index: gnu/usr.bin/perl/cpan/Digest/Digest/base.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Digest/Digest/base.pm,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 base.pm
--- gnu/usr.bin/perl/cpan/Digest/Digest/base.pm	24 Sep 2010 14:49:03 -0000	1.1.1.1
+++ gnu/usr.bin/perl/cpan/Digest/Digest/base.pm	5 Aug 2016 16:34:24 -0000
@@ -2,7 +2,7 @@ package Digest::base;
 
 use strict;
 use vars qw($VERSION);
-$VERSION = "1.16";
+$VERSION = "1.16_01";
 
 # subclass is supposed to implement at least these
 sub new;
Index: gnu/usr.bin/perl/cpan/Digest/Digest/file.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Digest/Digest/file.pm,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 file.pm
--- gnu/usr.bin/perl/cpan/Digest/Digest/file.pm	24 Sep 2010 14:49:03 -0000	1.1.1.1
+++ gnu/usr.bin/perl/cpan/Digest/Digest/file.pm	5 Aug 2016 16:34:24 -0000
@@ -8,7 +8,7 @@ use Digest ();
 
 use vars qw($VERSION @ISA @EXPORT_OK);
 
-$VERSION = "1.16";
+$VERSION = "1.16_01";
 @ISA = qw(Exporter);
 @EXPORT_OK = qw(digest_file_ctx digest_file digest_file_hex digest_file_base64);
 
Index: gnu/usr.bin/perl/cpan/Digest-SHA/shasum
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Digest-SHA/shasum,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 shasum
--- gnu/usr.bin/perl/cpan/Digest-SHA/shasum	17 Nov 2014 20:52:44 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Digest-SHA/shasum	5 Aug 2016 16:34:24 -0000
@@ -94,11 +94,12 @@ L<Digest::SHA::PurePerl>.
 
 END_OF_POD
 
+BEGIN { pop @INC if $INC[-1] eq '.' }
 use strict;
 use Fcntl;
 use Getopt::Long;
 
-my $VERSION = "5.88";
+my $VERSION = "5.88_01";
 
 sub usage {
 	my($err, $msg) = @_;
Index: gnu/usr.bin/perl/cpan/Digest-SHA/lib/Digest/SHA.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Digest-SHA/lib/Digest/SHA.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 SHA.pm
--- gnu/usr.bin/perl/cpan/Digest-SHA/lib/Digest/SHA.pm	17 Nov 2014 20:52:44 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Digest-SHA/lib/Digest/SHA.pm	5 Aug 2016 16:34:24 -0000
@@ -7,7 +7,7 @@ use vars qw($VERSION @ISA @EXPORT @EXPOR
 use Fcntl;
 use integer;
 
-$VERSION = '5.88';
+$VERSION = '5.88_01';
 
 require Exporter;
 require DynaLoader;
Index: gnu/usr.bin/perl/cpan/Encode/Encode.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Encode/Encode.pm,v
retrieving revision 1.5
diff -u -p -r1.5 Encode.pm
--- gnu/usr.bin/perl/cpan/Encode/Encode.pm	17 Nov 2014 20:56:59 -0000	1.5
+++ gnu/usr.bin/perl/cpan/Encode/Encode.pm	5 Aug 2016 16:34:24 -0000
@@ -56,6 +56,8 @@ require Encode::Config;
 eval {
     local $SIG{__DIE__};
     local $SIG{__WARN__};
+    local @INC = @INC;
+    pop @INC if $INC[-1] eq '.';
     require Encode::ConfigLocal;
 };
 
Index: gnu/usr.bin/perl/cpan/Encode/Encode/_PM.e2x
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Encode/Encode/_PM.e2x,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 _PM.e2x
--- gnu/usr.bin/perl/cpan/Encode/Encode/_PM.e2x	24 Sep 2010 14:48:59 -0000	1.1.1.1
+++ gnu/usr.bin/perl/cpan/Encode/Encode/_PM.e2x	5 Aug 2016 16:34:24 -0000
@@ -1,5 +1,5 @@
 package Encode::$_Name_;
-our $VERSION = "0.01";
+our $VERSION = "0.01_01";
  
 use Encode;
 use XSLoader;
Index: gnu/usr.bin/perl/cpan/Encode/bin/enc2xs
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Encode/bin/enc2xs,v
retrieving revision 1.3
diff -u -p -r1.3 enc2xs
--- gnu/usr.bin/perl/cpan/Encode/bin/enc2xs	17 Nov 2014 20:56:59 -0000	1.3
+++ gnu/usr.bin/perl/cpan/Encode/bin/enc2xs	5 Aug 2016 16:34:24 -0000
@@ -4,6 +4,7 @@ BEGIN {
     # with $ENV{PERL_CORE} set
     # In case we need it in future...
     require Config; import Config;
+    pop @INC if $INC[-1] eq '.';
 }
 use strict;
 use warnings;
Index: gnu/usr.bin/perl/cpan/Encode/bin/piconv
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Encode/bin/piconv,v
retrieving revision 1.3
diff -u -p -r1.3 piconv
--- gnu/usr.bin/perl/cpan/Encode/bin/piconv	17 Nov 2014 20:56:59 -0000	1.3
+++ gnu/usr.bin/perl/cpan/Encode/bin/piconv	5 Aug 2016 16:34:24 -0000
@@ -1,6 +1,7 @@
 #!./perl
 # $Id: piconv,v 2.6 2014/03/28 02:37:42 dankogai Exp $
 #
+BEGIN { pop @INC if $INC[-1] eq '.' }
 use 5.8.0;
 use strict;
 use Encode ;
Index: gnu/usr.bin/perl/cpan/Encode/bin/ucmlint
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Encode/bin/ucmlint,v
retrieving revision 1.2
diff -u -p -r1.2 ucmlint
--- gnu/usr.bin/perl/cpan/Encode/bin/ucmlint	24 Sep 2010 15:06:47 -0000	1.2
+++ gnu/usr.bin/perl/cpan/Encode/bin/ucmlint	5 Aug 2016 16:34:24 -0000
@@ -3,6 +3,7 @@
 # $Id: ucmlint,v 2.2 2008/03/12 09:51:11 dankogai Exp $
 #
 
+BEGIN { pop @INC if $INC[-1] eq '.' }
 use strict;
 our  $VERSION = do { my @r = (q$Revision: 2.2 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r };
 
Index: gnu/usr.bin/perl/cpan/Encode/bin/unidump
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Encode/bin/unidump,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 unidump
--- gnu/usr.bin/perl/cpan/Encode/bin/unidump	24 Sep 2010 14:48:59 -0000	1.1.1.1
+++ gnu/usr.bin/perl/cpan/Encode/bin/unidump	5 Aug 2016 16:34:24 -0000
@@ -1,5 +1,6 @@
 #!./perl
 
+BEGIN { pop @INC if $INC[-1] eq '.' }
 use strict;
 use Encode;
 use Getopt::Std;
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/bin/instmodsh
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/bin/instmodsh,v
retrieving revision 1.1.1.2
diff -u -p -r1.1.1.2 instmodsh
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/bin/instmodsh	17 Nov 2014 20:52:46 -0000	1.1.1.2
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/bin/instmodsh	5 Aug 2016 16:34:24 -0000
@@ -1,5 +1,6 @@
 #!/usr/bin/perl -w
 
+BEGIN { pop @INC if $INC[-1] eq '.' }
 use strict;
 use IO::File;
 use ExtUtils::Packlist;
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/Liblist.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/Liblist.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Liblist.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/Liblist.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/Liblist.pm	5 Aug 2016 16:34:24 -0000
@@ -2,7 +2,7 @@ package ExtUtils::Liblist;
 
 use strict;
 
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 use File::Spec;
 require ExtUtils::Liblist::Kid;
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 MM.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM.pm	5 Aug 2016 16:34:24 -0000
@@ -3,7 +3,7 @@ package ExtUtils::MM;
 use strict;
 use ExtUtils::MakeMaker::Config;
 
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 require ExtUtils::Liblist;
 require ExtUtils::MakeMaker;
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_AIX.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_AIX.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 MM_AIX.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_AIX.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_AIX.pm	5 Aug 2016 16:34:24 -0000
@@ -1,7 +1,7 @@
 package ExtUtils::MM_AIX;
 
 use strict;
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 require ExtUtils::MM_Unix;
 our @ISA = qw(ExtUtils::MM_Unix);
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Any.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Any.pm,v
retrieving revision 1.5
diff -u -p -r1.5 MM_Any.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Any.pm	17 Nov 2014 20:56:59 -0000	1.5
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Any.pm	5 Aug 2016 16:34:24 -0000
@@ -1,7 +1,7 @@
 package ExtUtils::MM_Any;
 
 use strict;
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 use Carp;
 use File::Spec;
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_BeOS.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_BeOS.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 MM_BeOS.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_BeOS.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_BeOS.pm	5 Aug 2016 16:34:24 -0000
@@ -26,7 +26,7 @@ require ExtUtils::MM_Any;
 require ExtUtils::MM_Unix;
 
 our @ISA = qw( ExtUtils::MM_Any ExtUtils::MM_Unix );
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 
 =item os_flavor
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Cygwin.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Cygwin.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 MM_Cygwin.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Cygwin.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Cygwin.pm	5 Aug 2016 16:34:24 -0000
@@ -9,7 +9,7 @@ require ExtUtils::MM_Unix;
 require ExtUtils::MM_Win32;
 our @ISA = qw( ExtUtils::MM_Unix );
 
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 
 =head1 NAME
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_DOS.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_DOS.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 MM_DOS.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_DOS.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_DOS.pm	5 Aug 2016 16:34:24 -0000
@@ -2,7 +2,7 @@ package ExtUtils::MM_DOS;
 
 use strict;
 
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 require ExtUtils::MM_Any;
 require ExtUtils::MM_Unix;
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Darwin.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Darwin.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 MM_Darwin.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Darwin.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Darwin.pm	5 Aug 2016 16:34:24 -0000
@@ -7,7 +7,7 @@ BEGIN {
     our @ISA = qw( ExtUtils::MM_Unix );
 }
 
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 
 =head1 NAME
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_MacOS.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_MacOS.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 MM_MacOS.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_MacOS.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_MacOS.pm	5 Aug 2016 16:34:24 -0000
@@ -2,7 +2,7 @@ package ExtUtils::MM_MacOS;
 
 use strict;
 
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 sub new {
     die <<'UNSUPPORTED';
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_NW5.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_NW5.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 MM_NW5.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_NW5.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_NW5.pm	5 Aug 2016 16:34:24 -0000
@@ -22,7 +22,7 @@ use strict;
 use ExtUtils::MakeMaker::Config;
 use File::Basename;
 
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 require ExtUtils::MM_Win32;
 our @ISA = qw(ExtUtils::MM_Win32);
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_OS2.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_OS2.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 MM_OS2.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_OS2.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_OS2.pm	5 Aug 2016 16:34:24 -0000
@@ -5,7 +5,7 @@ use strict;
 use ExtUtils::MakeMaker qw(neatvalue);
 use File::Spec;
 
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 require ExtUtils::MM_Any;
 require ExtUtils::MM_Unix;
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_QNX.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_QNX.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 MM_QNX.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_QNX.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_QNX.pm	5 Aug 2016 16:34:24 -0000
@@ -1,7 +1,7 @@
 package ExtUtils::MM_QNX;
 
 use strict;
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 require ExtUtils::MM_Unix;
 our @ISA = qw(ExtUtils::MM_Unix);
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_UWIN.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_UWIN.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 MM_UWIN.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_UWIN.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_UWIN.pm	5 Aug 2016 16:34:24 -0000
@@ -1,7 +1,7 @@
 package ExtUtils::MM_UWIN;
 
 use strict;
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 require ExtUtils::MM_Unix;
 our @ISA = qw(ExtUtils::MM_Unix);
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Unix.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Unix.pm,v
retrieving revision 1.8
diff -u -p -r1.8 MM_Unix.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Unix.pm	25 Apr 2015 19:26:21 -0000	1.8
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Unix.pm	5 Aug 2016 16:34:24 -0000
@@ -15,7 +15,7 @@ use ExtUtils::MakeMaker qw($Verbose neat
 
 # If we make $VERSION an our variable parse_version() breaks
 use vars qw($VERSION);
-$VERSION = '6.98';
+$VERSION = '6.98_01';
 $VERSION = eval $VERSION;  ## no critic [BuiltinFunctions::ProhibitStringyEval]
 
 require ExtUtils::MM_Any;
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_VMS.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_VMS.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 MM_VMS.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_VMS.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_VMS.pm	5 Aug 2016 16:34:24 -0000
@@ -15,7 +15,7 @@ BEGIN {
 
 use File::Basename;
 
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 require ExtUtils::MM_Any;
 require ExtUtils::MM_Unix;
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_VOS.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_VOS.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 MM_VOS.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_VOS.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_VOS.pm	5 Aug 2016 16:34:24 -0000
@@ -1,7 +1,7 @@
 package ExtUtils::MM_VOS;
 
 use strict;
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 require ExtUtils::MM_Unix;
 our @ISA = qw(ExtUtils::MM_Unix);
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Win32.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Win32.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 MM_Win32.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Win32.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Win32.pm	5 Aug 2016 16:34:24 -0000
@@ -27,7 +27,7 @@ use ExtUtils::MakeMaker qw( neatvalue );
 require ExtUtils::MM_Any;
 require ExtUtils::MM_Unix;
 our @ISA = qw( ExtUtils::MM_Any ExtUtils::MM_Unix );
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 $ENV{EMXSHELL} = 'sh'; # to run `commands`
 
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Win95.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Win95.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 MM_Win95.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Win95.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MM_Win95.pm	5 Aug 2016 16:34:24 -0000
@@ -2,7 +2,7 @@ package ExtUtils::MM_Win95;
 
 use strict;
 
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 require ExtUtils::MM_Win32;
 our @ISA = qw(ExtUtils::MM_Win32);
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MY.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MY.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 MY.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MY.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MY.pm	5 Aug 2016 16:34:24 -0000
@@ -3,7 +3,7 @@ package ExtUtils::MY;
 use strict;
 require ExtUtils::MM;
 
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 our @ISA = qw(ExtUtils::MM);
 
 {
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MakeMaker.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MakeMaker.pm,v
retrieving revision 1.5
diff -u -p -r1.5 MakeMaker.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MakeMaker.pm	17 Nov 2014 20:57:00 -0000	1.5
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MakeMaker.pm	5 Aug 2016 16:34:24 -0000
@@ -18,7 +18,7 @@ our @Overridable;
 my @Prepend_parent;
 my %Recognized_Att_Keys;
 
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 $VERSION = eval $VERSION;  ## no critic [BuiltinFunctions::ProhibitStringyEval]
 
 # Emulate something resembling CVS $Revision$
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/Mkbootstrap.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/Mkbootstrap.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Mkbootstrap.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/Mkbootstrap.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/Mkbootstrap.pm	5 Aug 2016 16:34:24 -0000
@@ -3,7 +3,7 @@ package ExtUtils::Mkbootstrap;
 # There's just too much Dynaloader incest here to turn on strict vars.
 use strict 'refs';
 
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 require Exporter;
 our @ISA = ('Exporter');
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/Mksymlists.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/Mksymlists.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Mksymlists.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/Mksymlists.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/Mksymlists.pm	5 Aug 2016 16:34:24 -0000
@@ -10,7 +10,7 @@ use Config;
 
 our @ISA = qw(Exporter);
 our @EXPORT = qw(&Mksymlists);
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 sub Mksymlists {
     my(%spec) = @_;
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/testlib.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/testlib.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 testlib.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/testlib.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/testlib.pm	5 Aug 2016 16:34:24 -0000
@@ -3,7 +3,7 @@ package ExtUtils::testlib;
 use strict;
 use warnings;
 
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 use Cwd;
 use File::Spec;
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/Command/MM.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/Command/MM.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 MM.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/Command/MM.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/Command/MM.pm	5 Aug 2016 16:34:24 -0000
@@ -10,7 +10,7 @@ our @ISA = qw(Exporter);
 
 our @EXPORT  = qw(test_harness pod2man perllocal_install uninstall
                   warn_if_old_packlist test_s cp_nonempty);
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 my $Is_VMS = $^O eq 'VMS';
 
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/Liblist/Kid.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/Liblist/Kid.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Kid.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/Liblist/Kid.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/Liblist/Kid.pm	5 Aug 2016 16:34:24 -0000
@@ -11,7 +11,7 @@ use 5.006;
 
 use strict;
 use warnings;
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 use ExtUtils::MakeMaker::Config;
 use Cwd 'cwd';
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MakeMaker/Config.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MakeMaker/Config.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Config.pm
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MakeMaker/Config.pm	17 Nov 2014 20:52:46 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MakeMaker/Config.pm	5 Aug 2016 16:34:24 -0000
@@ -2,7 +2,7 @@ package ExtUtils::MakeMaker::Config;
 
 use strict;
 
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 use Config ();
 
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MakeMaker/FAQ.pod
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MakeMaker/FAQ.pod,v
retrieving revision 1.5
diff -u -p -r1.5 FAQ.pod
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MakeMaker/FAQ.pod	17 Nov 2014 20:57:00 -0000	1.5
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MakeMaker/FAQ.pod	5 Aug 2016 16:34:24 -0000
@@ -1,6 +1,6 @@
 package ExtUtils::MakeMaker::FAQ;
 
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 1;
 __END__
Index: gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MakeMaker/Tutorial.pod
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MakeMaker/Tutorial.pod,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Tutorial.pod
--- gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MakeMaker/Tutorial.pod	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/ExtUtils-MakeMaker/lib/ExtUtils/MakeMaker/Tutorial.pod	5 Aug 2016 16:34:24 -0000
@@ -1,6 +1,6 @@
 package ExtUtils::MakeMaker::Tutorial;
 
-our $VERSION = '6.98';
+our $VERSION = '6.98_01';
 
 
 =head1 NAME
Index: gnu/usr.bin/perl/cpan/File-Fetch/lib/File/Fetch.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/File-Fetch/lib/File/Fetch.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Fetch.pm
--- gnu/usr.bin/perl/cpan/File-Fetch/lib/File/Fetch.pm	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/File-Fetch/lib/File/Fetch.pm	5 Aug 2016 16:34:24 -0000
@@ -22,7 +22,7 @@ use vars    qw[ $VERBOSE $PREFER_BIN $FR
                 $FTP_PASSIVE $TIMEOUT $DEBUG $WARN $FORCEIPV4
             ];
 
-$VERSION        = '0.48';
+$VERSION        = '0.48_01';
 $VERSION        = eval $VERSION;    # avoid warnings with development releases
 $PREFER_BIN     = 0;                # XXX TODO implement
 $FROM_EMAIL     = 'File-Fetch@example.com';
@@ -567,6 +567,8 @@ sub _lwp_fetch {
 
     };
 
+    local @INC = @INC;
+    pop @INC if $INC[-1] eq '.';
     unless( can_load( modules => $use_list ) ) {
         $METHOD_FAIL->{'lwp'} = 1;
         return;
@@ -619,6 +621,8 @@ sub _httptiny_fetch {
 
     };
 
+    local @INC = @INC;
+    pop @INC if $INC[-1] eq '.';
     unless( can_load(modules => $use_list) ) {
         $METHOD_FAIL->{'httptiny'} = 1;
         return;
@@ -658,6 +662,8 @@ sub _httplite_fetch {
 
     };
 
+    local @INC = @INC;
+    pop @INC if $INC[-1] eq '.';
     unless( can_load(modules => $use_list) ) {
         $METHOD_FAIL->{'httplite'} = 1;
         return;
@@ -733,6 +739,8 @@ sub _iosock_fetch {
         'IO::Select'       => '0.0',
     };
 
+    local @INC = @INC;
+    pop @INC if $INC[-1] eq '.';
     unless( can_load(modules => $use_list) ) {
         $METHOD_FAIL->{'iosock'} = 1;
         return;
@@ -814,6 +822,8 @@ sub _netftp_fetch {
     check( $tmpl, \%hash ) or return;
 
     ### required modules ###
+    local @INC = @INC;
+    pop @INC if $INC[-1] eq '.';
     my $use_list = { 'Net::FTP' => 0 };
 
     unless( can_load( modules => $use_list ) ) {
Index: gnu/usr.bin/perl/cpan/HTTP-Tiny/lib/HTTP/Tiny.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/HTTP-Tiny/lib/HTTP/Tiny.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 Tiny.pm
--- gnu/usr.bin/perl/cpan/HTTP-Tiny/lib/HTTP/Tiny.pm	17 Nov 2014 20:52:47 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/HTTP-Tiny/lib/HTTP/Tiny.pm	5 Aug 2016 16:34:24 -0000
@@ -3,7 +3,7 @@ package HTTP::Tiny;
 use strict;
 use warnings;
 # ABSTRACT: A small, simple, correct HTTP/1.1 client
-our $VERSION = '0.043'; # VERSION
+our $VERSION = '0.043_01'; # VERSION
 
 use Carp ();
 
@@ -1368,6 +1368,8 @@ sub _find_CA_file {
     return $self->{SSL_options}->{SSL_ca_file}
         if $self->{SSL_options}->{SSL_ca_file} and -e $self->{SSL_options}->{SSL_ca_file};
 
+    local @INC = @INC;
+    pop @INC if $INC[-1] eq '.';
     return Mozilla::CA::SSL_ca_file()
         if eval { require Mozilla::CA };
 
Index: gnu/usr.bin/perl/cpan/IO-Compress/bin/zipdetails
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/bin/zipdetails,v
retrieving revision 1.1.1.2
diff -u -p -r1.1.1.2 zipdetails
--- gnu/usr.bin/perl/cpan/IO-Compress/bin/zipdetails	17 Nov 2014 20:52:47 -0000	1.1.1.2
+++ gnu/usr.bin/perl/cpan/IO-Compress/bin/zipdetails	5 Aug 2016 16:34:24 -0000
@@ -5,6 +5,7 @@
 # Display info on the contents of a Zip file
 #
 
+BEGIN { pop @INC if $INC[-1] eq '.' }
 use strict;
 use warnings ;
 
@@ -177,7 +178,7 @@ my %Extras = (
 
        );
 
-my $VERSION = "1.06" ;
+my $VERSION = "1.06_01" ;
 
 my $FH;
 
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/Compress/Zlib.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/Compress/Zlib.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Zlib.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/Compress/Zlib.pm	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/Compress/Zlib.pm	5 Aug 2016 16:34:24 -0000
@@ -17,7 +17,7 @@ use warnings ;
 use bytes ;
 our ($VERSION, $XS_VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 $XS_VERSION = $VERSION; 
 $VERSION = eval $VERSION;
 
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/File/GlobMapper.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/File/GlobMapper.pm,v
retrieving revision 1.1.1.2
diff -u -p -r1.1.1.2 GlobMapper.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/File/GlobMapper.pm	25 Mar 2013 20:07:44 -0000	1.1.1.2
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/File/GlobMapper.pm	5 Aug 2016 16:34:24 -0000
@@ -26,7 +26,7 @@ BEGIN
 our ($Error);
 
 our ($VERSION, @EXPORT_OK);
-$VERSION = '1.000';
+$VERSION = '1.000_01';
 @EXPORT_OK = qw( globmap );
 
 
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Base.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Base.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Base.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Base.pm	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Base.pm	5 Aug 2016 16:34:24 -0000
@@ -20,7 +20,7 @@ use Symbol();
 our (@ISA, $VERSION);
 @ISA    = qw(Exporter IO::File);
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 
 #Can't locate object method "SWASHNEW" via package "utf8" (perhaps you forgot to load "utf8"?) at .../ext/Compress-Zlib/Gzip/blib/lib/Compress/Zlib/Common.pm line 16.
 
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Bzip2.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Bzip2.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Bzip2.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Bzip2.pm	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Bzip2.pm	5 Aug 2016 16:34:24 -0000
@@ -14,7 +14,7 @@ use IO::Compress::Adapter::Bzip2 2.064 ;
 
 our ($VERSION, @ISA, @EXPORT_OK, %EXPORT_TAGS, $Bzip2Error);
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 $Bzip2Error = '';
 
 @ISA    = qw(Exporter IO::Compress::Base);
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Deflate.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Deflate.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Deflate.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Deflate.pm	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Deflate.pm	5 Aug 2016 16:34:24 -0000
@@ -17,7 +17,7 @@ use IO::Compress::Base::Common  2.064 qw
 
 our ($VERSION, @ISA, @EXPORT_OK, %EXPORT_TAGS, %DEFLATE_CONSTANTS, $DeflateError);
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 $DeflateError = '';
 
 @ISA    = qw(Exporter IO::Compress::RawDeflate);
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Gzip.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Gzip.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Gzip.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Gzip.pm	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Gzip.pm	5 Aug 2016 16:34:25 -0000
@@ -25,7 +25,7 @@ BEGIN
 
 our ($VERSION, @ISA, @EXPORT_OK, %EXPORT_TAGS, %DEFLATE_CONSTANTS, $GzipError);
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 $GzipError = '' ;
 
 @ISA    = qw(Exporter IO::Compress::RawDeflate);
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/RawDeflate.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/RawDeflate.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 RawDeflate.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/RawDeflate.pm	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/RawDeflate.pm	5 Aug 2016 16:34:25 -0000
@@ -14,7 +14,7 @@ require Exporter ;
 
 our ($VERSION, @ISA, @EXPORT_OK, %DEFLATE_CONSTANTS, %EXPORT_TAGS, $RawDeflateError);
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 $RawDeflateError = '';
 
 @ISA = qw(Exporter IO::Compress::Base);
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Zip.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Zip.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Zip.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Zip.pm	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Zip.pm	5 Aug 2016 16:34:25 -0000
@@ -36,7 +36,7 @@ require Exporter ;
 
 our ($VERSION, @ISA, @EXPORT_OK, %EXPORT_TAGS, %DEFLATE_CONSTANTS, $ZipError);
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 $ZipError = '';
 
 @ISA = qw(Exporter IO::Compress::RawDeflate);
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Adapter/Bzip2.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Adapter/Bzip2.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Bzip2.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Adapter/Bzip2.pm	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Adapter/Bzip2.pm	5 Aug 2016 16:34:25 -0000
@@ -9,7 +9,7 @@ use IO::Compress::Base::Common  2.064 qw
 use Compress::Raw::Bzip2  2.064 ;
 
 our ($VERSION);
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 
 sub mkCompObject
 {
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Adapter/Deflate.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Adapter/Deflate.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Deflate.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Adapter/Deflate.pm	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Adapter/Deflate.pm	5 Aug 2016 16:34:25 -0000
@@ -10,7 +10,7 @@ use Compress::Raw::Zlib  2.064 qw( !crc3
 require Exporter;                                     
 our ($VERSION, @ISA, @EXPORT_OK, %EXPORT_TAGS, @EXPORT, %DEFLATE_CONSTANTS);
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 @ISA = qw(Exporter);
 @EXPORT_OK = @Compress::Raw::Zlib::DEFLATE_CONSTANTS;
 %EXPORT_TAGS = %Compress::Raw::Zlib::DEFLATE_CONSTANTS;
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Adapter/Identity.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Adapter/Identity.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Identity.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Adapter/Identity.pm	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Adapter/Identity.pm	5 Aug 2016 16:34:25 -0000
@@ -7,7 +7,7 @@ use bytes;
 use IO::Compress::Base::Common  2.064 qw(:Status);
 our ($VERSION);
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 
 sub mkCompObject
 {
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Base/Common.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Base/Common.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Common.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Base/Common.pm	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Base/Common.pm	5 Aug 2016 16:34:25 -0000
@@ -11,7 +11,7 @@ use File::GlobMapper;
 require Exporter;
 our ($VERSION, @ISA, @EXPORT, %EXPORT_TAGS, $HAS_ENCODE);
 @ISA = qw(Exporter);
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 
 @EXPORT = qw( isaFilehandle isaFilename isaScalar
               whatIsInput whatIsOutput 
@@ -464,7 +464,7 @@ sub createSelfTiedObject
 #
 #require Exporter;
 #our ($VERSION, @ISA, @EXPORT);
-#$VERSION = '2.000_08';
+#$VERSION = '2.000_09';
 #@ISA = qw(Exporter);
 
 $EXPORT_TAGS{Parse} = [qw( ParseParameters 
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Gzip/Constants.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Gzip/Constants.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Constants.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Gzip/Constants.pm	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Gzip/Constants.pm	5 Aug 2016 16:34:25 -0000
@@ -9,7 +9,7 @@ require Exporter;
 our ($VERSION, @ISA, @EXPORT, %GZIP_OS_Names);
 our ($GZIP_FNAME_INVALID_CHAR_RE, $GZIP_FCOMMENT_INVALID_CHAR_RE);
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 
 @ISA = qw(Exporter);
 
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Zip/Constants.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Zip/Constants.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Constants.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Zip/Constants.pm	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Zip/Constants.pm	5 Aug 2016 16:34:25 -0000
@@ -7,7 +7,7 @@ require Exporter;
 
 our ($VERSION, @ISA, @EXPORT, %ZIP_CM_MIN_VERSIONS);
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 
 @ISA = qw(Exporter);
 
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Zlib/Constants.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Zlib/Constants.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Constants.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Zlib/Constants.pm	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Zlib/Constants.pm	5 Aug 2016 16:34:25 -0000
@@ -9,7 +9,7 @@ require Exporter;
 
 our ($VERSION, @ISA, @EXPORT);
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 
 @ISA = qw(Exporter);
 
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Zlib/Extra.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Zlib/Extra.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Extra.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Zlib/Extra.pm	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Compress/Zlib/Extra.pm	5 Aug 2016 16:34:25 -0000
@@ -8,7 +8,7 @@ use bytes;
 
 our ($VERSION, @ISA, @EXPORT_OK, %EXPORT_TAGS);
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 
 use IO::Compress::Gzip::Constants 2.064 ;
 
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/AnyInflate.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/AnyInflate.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 AnyInflate.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/AnyInflate.pm	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/AnyInflate.pm	5 Aug 2016 16:34:25 -0000
@@ -21,7 +21,7 @@ require Exporter ;
 
 our ($VERSION, @ISA, @EXPORT_OK, %EXPORT_TAGS, $AnyInflateError);
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 $AnyInflateError = '';
 
 @ISA = qw( Exporter IO::Uncompress::Base );
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/AnyUncompress.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/AnyUncompress.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 AnyUncompress.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/AnyUncompress.pm	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/AnyUncompress.pm	5 Aug 2016 16:34:25 -0000
@@ -13,7 +13,7 @@ require Exporter ;
 
 our ($VERSION, @ISA, @EXPORT_OK, %EXPORT_TAGS, $AnyUncompressError);
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 $AnyUncompressError = '';
 
 @ISA = qw( Exporter IO::Uncompress::Base );
@@ -27,6 +27,8 @@ Exporter::export_ok_tags('all');
 
 BEGIN
 {
+   local @INC = @INC;
+   pop @INC if $INC[-1] eq '.';
    eval ' use IO::Uncompress::Adapter::Inflate 2.064 ;';
    eval ' use IO::Uncompress::Adapter::Bunzip2 2.064 ;';
    eval ' use IO::Uncompress::Adapter::LZO 2.064 ;';
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Base.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Base.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Base.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Base.pm	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Base.pm	5 Aug 2016 16:34:25 -0000
@@ -9,7 +9,7 @@ our (@ISA, $VERSION, @EXPORT_OK, %EXPORT
 @ISA    = qw(Exporter IO::File);
 
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 
 use constant G_EOF => 0 ;
 use constant G_ERR => -1 ;
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Bunzip2.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Bunzip2.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Bunzip2.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Bunzip2.pm	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Bunzip2.pm	5 Aug 2016 16:34:25 -0000
@@ -12,7 +12,7 @@ use IO::Uncompress::Adapter::Bunzip2 2.0
 require Exporter ;
 our ($VERSION, @ISA, @EXPORT_OK, %EXPORT_TAGS, $Bunzip2Error);
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 $Bunzip2Error = '';
 
 @ISA    = qw( Exporter IO::Uncompress::Base );
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Gunzip.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Gunzip.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Gunzip.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Gunzip.pm	17 Nov 2014 20:52:47 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Gunzip.pm	5 Aug 2016 16:34:25 -0000
@@ -28,7 +28,7 @@ Exporter::export_ok_tags('all');
 
 $GunzipError = '';
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 
 sub new
 {
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Inflate.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Inflate.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Inflate.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Inflate.pm	17 Nov 2014 20:52:48 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Inflate.pm	5 Aug 2016 16:34:25 -0000
@@ -13,7 +13,7 @@ use IO::Uncompress::RawInflate  2.064 ;
 require Exporter ;
 our ($VERSION, @ISA, @EXPORT_OK, %EXPORT_TAGS, $InflateError);
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 $InflateError = '';
 
 @ISA    = qw( Exporter IO::Uncompress::RawInflate );
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/RawInflate.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/RawInflate.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 RawInflate.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/RawInflate.pm	17 Nov 2014 20:52:48 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/RawInflate.pm	5 Aug 2016 16:34:25 -0000
@@ -14,7 +14,7 @@ use IO::Uncompress::Adapter::Inflate  2.
 require Exporter ;
 our ($VERSION, @ISA, @EXPORT_OK, %EXPORT_TAGS, %DEFLATE_CONSTANTS, $RawInflateError);
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 $RawInflateError = '';
 
 @ISA    = qw( Exporter IO::Uncompress::Base );
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Unzip.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Unzip.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Unzip.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Unzip.pm	17 Nov 2014 20:52:48 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Unzip.pm	5 Aug 2016 16:34:25 -0000
@@ -31,7 +31,7 @@ require Exporter ;
 
 our ($VERSION, @ISA, @EXPORT_OK, %EXPORT_TAGS, $UnzipError, %headerLookup);
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 $UnzipError = '';
 
 @ISA    = qw(Exporter IO::Uncompress::RawInflate);
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Adapter/Bunzip2.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Adapter/Bunzip2.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Bunzip2.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Adapter/Bunzip2.pm	17 Nov 2014 20:52:48 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Adapter/Bunzip2.pm	5 Aug 2016 16:34:25 -0000
@@ -9,7 +9,7 @@ use IO::Compress::Base::Common 2.064 qw(
 use Compress::Raw::Bzip2 2.064 ;
 
 our ($VERSION, @ISA);
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 
 sub mkUncompObject
 {
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Adapter/Identity.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Adapter/Identity.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Identity.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Adapter/Identity.pm	17 Nov 2014 20:52:48 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Adapter/Identity.pm	5 Aug 2016 16:34:25 -0000
@@ -9,7 +9,7 @@ use IO::Compress::Zip::Constants ;
 
 our ($VERSION);
 
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 
 use Compress::Raw::Zlib  2.064 ();
 
Index: gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Adapter/Inflate.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Adapter/Inflate.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Inflate.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Adapter/Inflate.pm	17 Nov 2014 20:52:48 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IO-Compress/lib/IO/Uncompress/Adapter/Inflate.pm	5 Aug 2016 16:34:25 -0000
@@ -8,7 +8,7 @@ use IO::Compress::Base::Common  2.064 qw
 use Compress::Raw::Zlib  2.064 qw(Z_OK Z_BUF_ERROR Z_STREAM_END Z_FINISH MAX_WBITS);
 
 our ($VERSION);
-$VERSION = '2.064';
+$VERSION = '2.064_01';
 
 
 
Index: gnu/usr.bin/perl/cpan/IO-Compress/private/MakeUtil.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IO-Compress/private/MakeUtil.pm,v
retrieving revision 1.6
diff -u -p -r1.6 MakeUtil.pm
--- gnu/usr.bin/perl/cpan/IO-Compress/private/MakeUtil.pm	25 Apr 2015 19:26:21 -0000	1.6
+++ gnu/usr.bin/perl/cpan/IO-Compress/private/MakeUtil.pm	5 Aug 2016 16:34:25 -0000
@@ -6,7 +6,7 @@ use strict ;
 use Config qw(%Config);
 use File::Copy;
 
-my $VERSION = '1.0';
+my $VERSION = '1.0_01';
 
 
 BEGIN
Index: gnu/usr.bin/perl/cpan/IPC-Cmd/lib/IPC/Cmd.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/IPC-Cmd/lib/IPC/Cmd.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Cmd.pm
--- gnu/usr.bin/perl/cpan/IPC-Cmd/lib/IPC/Cmd.pm	17 Nov 2014 20:52:48 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/IPC-Cmd/lib/IPC/Cmd.pm	5 Aug 2016 16:34:25 -0000
@@ -18,7 +18,7 @@ BEGIN {
                         $HAVE_MONOTONIC
                     ];
 
-    $VERSION        = '0.92';
+    $VERSION        = '0.92_01';
     $VERBOSE        = 0;
     $DEBUG          = 0;
     $WARN           = 1;
@@ -142,6 +142,8 @@ sub can_use_ipc_run     {
     return if IS_WIN98;
 
     ### if we don't have ipc::run, we obviously can't use it.
+    local @INC = @INC;
+    pop @INC if $INC[-1] eq '.';
     return unless can_load(
                         modules => { 'IPC::Run' => '0.55' },
                         verbose => ($WARN && $verbose),
@@ -169,6 +171,8 @@ sub can_use_ipc_open3   {
 
     ### IPC::Open3 works on every non-VMS platform, but it can't
     ### capture buffers on win32 :(
+    local @INC = @INC;
+    pop @INC if $INC[-1] eq '.';
     return unless can_load(
         modules => { map {$_ => '0.0'} qw|IPC::Open3 IO::Select Symbol| },
         verbose => ($WARN && $verbose),
Index: gnu/usr.bin/perl/cpan/JSON-PP/bin/json_pp
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/JSON-PP/bin/json_pp,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 json_pp
--- gnu/usr.bin/perl/cpan/JSON-PP/bin/json_pp	25 Mar 2013 20:07:46 -0000	1.1.1.1
+++ gnu/usr.bin/perl/cpan/JSON-PP/bin/json_pp	5 Aug 2016 16:34:25 -0000
@@ -1,11 +1,12 @@
 #!/usr/bin/perl
 
+BEGIN { pop @INC if $INC[-1] eq '.' }
 use strict;
 use Getopt::Long;
 
 use JSON::PP ();
 
-my $VERSION = '1.00';
+my $VERSION = '1.00_01';
 
 # imported from JSON-XS/bin/json_xs
 
Index: gnu/usr.bin/perl/cpan/JSON-PP/lib/JSON/PP.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/JSON-PP/lib/JSON/PP.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 PP.pm
--- gnu/usr.bin/perl/cpan/JSON-PP/lib/JSON/PP.pm	17 Nov 2014 20:52:48 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/JSON-PP/lib/JSON/PP.pm	5 Aug 2016 16:34:25 -0000
@@ -11,7 +11,7 @@ use Carp ();
 use B ();
 #use Devel::Peek;
 
-$JSON::PP::VERSION = '2.27203';
+$JSON::PP::VERSION = '2.27203_01';
 
 @JSON::PP::EXPORT = qw(encode_json decode_json from_json to_json);
 
@@ -1425,7 +1425,7 @@ use constant INCR_M_JSON => 3; # outside
 use constant INCR_M_C0   => 4;
 use constant INCR_M_C1   => 5;
 
-$JSON::PP::IncrParser::VERSION = '1.01';
+$JSON::PP::IncrParser::VERSION = '1.01_01';
 
 my $unpack_format = $] < 5.006 ? 'C*' : 'U*';
 
Index: gnu/usr.bin/perl/cpan/Locale-Maketext-Simple/lib/Locale/Maketext/Simple.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Locale-Maketext-Simple/lib/Locale/Maketext/Simple.pm,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 Simple.pm
--- gnu/usr.bin/perl/cpan/Locale-Maketext-Simple/lib/Locale/Maketext/Simple.pm	24 Sep 2010 14:49:01 -0000	1.1.1.1
+++ gnu/usr.bin/perl/cpan/Locale-Maketext-Simple/lib/Locale/Maketext/Simple.pm	5 Aug 2016 16:34:25 -0000
@@ -1,5 +1,5 @@
 package Locale::Maketext::Simple;
-$Locale::Maketext::Simple::VERSION = '0.21';
+$Locale::Maketext::Simple::VERSION = '0.21_01';
 
 use strict;
 use 5.005;
@@ -134,7 +134,12 @@ sub load_loc {
     my $pkg = join('::', grep { defined and length } $args{Class}, $args{Subclass});
     return $Loc{$pkg} if exists $Loc{$pkg};
 
-    eval { require Locale::Maketext::Lexicon; 1 }   or return;
+    eval {
+        local @INC = @INC;
+        pop @INC if $INC[-1] eq '.';
+        require Locale::Maketext::Lexicon;
+        1
+    } or return;
     $Locale::Maketext::Lexicon::VERSION > 0.20	    or return;
     eval { require File::Spec; 1 }		    or return;
 
Index: gnu/usr.bin/perl/cpan/Memoize/Memoize.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Memoize/Memoize.pm,v
retrieving revision 1.4
diff -u -p -r1.4 Memoize.pm
--- gnu/usr.bin/perl/cpan/Memoize/Memoize.pm	24 Mar 2014 15:05:25 -0000	1.4
+++ gnu/usr.bin/perl/cpan/Memoize/Memoize.pm	5 Aug 2016 16:34:26 -0000
@@ -9,7 +9,7 @@
 # write to mjd-perl-memoize+@plover.com for a license.
 
 package Memoize;
-$VERSION = '1.03';
+$VERSION = '1.03_01';
 
 # Compile-time constants
 sub SCALAR () { 0 } 
@@ -184,7 +184,11 @@ sub _my_tie {
   }
   my $modulefile = $module . '.pm';
   $modulefile =~ s{::}{/}g;
-  eval { require $modulefile };
+  eval {
+    local @INC = @INC;
+    pop @INC if $INC[-1] eq '.';
+    require $modulefile
+  };
   if ($@) {
     croak "Memoize: Couldn't load hash tie module `$module': $@; aborting";
   }
Index: gnu/usr.bin/perl/cpan/Memoize/Memoize/AnyDBM_File.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Memoize/Memoize/AnyDBM_File.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 AnyDBM_File.pm
--- gnu/usr.bin/perl/cpan/Memoize/Memoize/AnyDBM_File.pm	24 Mar 2014 14:58:55 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Memoize/Memoize/AnyDBM_File.pm	5 Aug 2016 16:34:26 -0000
@@ -11,7 +11,7 @@ See L<Memoize>.
 =cut
 
 use vars qw(@ISA $VERSION);
-$VERSION = '1.03';
+$VERSION = '1.03_01';
 @ISA = qw(DB_File GDBM_File Memoize::NDBM_File Memoize::SDBM_File ODBM_File) unless @ISA;
 
 my $verbose = 1;
Index: gnu/usr.bin/perl/cpan/Memoize/Memoize/Expire.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Memoize/Memoize/Expire.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 Expire.pm
--- gnu/usr.bin/perl/cpan/Memoize/Memoize/Expire.pm	24 Mar 2014 14:58:55 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Memoize/Memoize/Expire.pm	5 Aug 2016 16:34:26 -0000
@@ -3,7 +3,7 @@ package Memoize::Expire;
 # require 5.00556;
 use Carp;
 $DEBUG = 0;
-$VERSION = '1.03';
+$VERSION = '1.03_01';
 
 # This package will implement expiration by prepending a fixed-length header
 # to the font of the cached data.  The format of the header will be:
Index: gnu/usr.bin/perl/cpan/Memoize/Memoize/ExpireFile.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Memoize/Memoize/ExpireFile.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 ExpireFile.pm
--- gnu/usr.bin/perl/cpan/Memoize/Memoize/ExpireFile.pm	24 Mar 2014 14:58:55 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Memoize/Memoize/ExpireFile.pm	5 Aug 2016 16:34:26 -0000
@@ -10,7 +10,7 @@ See L<Memoize::Expire>.
 
 =cut
 
-$VERSION = '1.03';
+$VERSION = '1.03_01';
 use Carp;
 
 my $Zero = pack("N", 0);
Index: gnu/usr.bin/perl/cpan/Memoize/Memoize/ExpireTest.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Memoize/Memoize/ExpireTest.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 ExpireTest.pm
--- gnu/usr.bin/perl/cpan/Memoize/Memoize/ExpireTest.pm	24 Mar 2014 14:58:55 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Memoize/Memoize/ExpireTest.pm	5 Aug 2016 16:34:26 -0000
@@ -18,7 +18,7 @@ to mjd-perl-memoize+@plover.com.
 
 =cut
 
-$VERSION = '1.03';
+$VERSION = '1.03_01';
 my %cache;
 
 sub TIEHASH {	
Index: gnu/usr.bin/perl/cpan/Memoize/Memoize/NDBM_File.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Memoize/Memoize/NDBM_File.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 NDBM_File.pm
--- gnu/usr.bin/perl/cpan/Memoize/Memoize/NDBM_File.pm	24 Mar 2014 14:58:55 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Memoize/Memoize/NDBM_File.pm	5 Aug 2016 16:34:26 -0000
@@ -12,7 +12,7 @@ See L<Memoize>.
 
 use NDBM_File;
 @ISA = qw(NDBM_File);
-$VERSION = '1.03';
+$VERSION = '1.03_01';
 
 $Verbose = 0;
 
Index: gnu/usr.bin/perl/cpan/Memoize/Memoize/SDBM_File.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Memoize/Memoize/SDBM_File.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 SDBM_File.pm
--- gnu/usr.bin/perl/cpan/Memoize/Memoize/SDBM_File.pm	24 Mar 2014 14:58:55 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Memoize/Memoize/SDBM_File.pm	5 Aug 2016 16:34:26 -0000
@@ -12,7 +12,7 @@ See L<Memoize>.
 
 use SDBM_File;
 @ISA = qw(SDBM_File);
-$VERSION = '1.03';
+$VERSION = '1.03_01';
 
 $Verbose = 0;
 
Index: gnu/usr.bin/perl/cpan/Memoize/Memoize/Storable.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Memoize/Memoize/Storable.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 Storable.pm
--- gnu/usr.bin/perl/cpan/Memoize/Memoize/Storable.pm	24 Mar 2014 14:58:55 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Memoize/Memoize/Storable.pm	5 Aug 2016 16:34:26 -0000
@@ -11,7 +11,7 @@ See L<Memoize>.
 =cut
 
 use Storable ();
-$VERSION = '1.03';
+$VERSION = '1.03_01';
 $Verbose = 0;
 
 sub TIEHASH {
Index: gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 Perldoc.pm
--- gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc.pm	17 Nov 2014 20:52:58 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc.pm	5 Aug 2016 16:34:26 -0000
@@ -12,7 +12,7 @@ use File::Spec::Functions qw(catfile cat
 use vars qw($VERSION @Pagers $Bindir $Pod2man
   $Temp_Files_Created $Temp_File_Lifetime
 );
-$VERSION = '3.23';
+$VERSION = '3.23_01';
 
 #..........................................................................
 
@@ -563,6 +563,9 @@ sub find_good_formatter_class {
   my @class_list = @{ $self->{'formatter_classes'} || [] };
   $self->die( "WHAT?  Nothing in the formatter class list!?" ) unless @class_list;
 
+  local @INC = @INC;
+  pop @INC if $INC[-1] eq '.';
+
   my $good_class_found;
   foreach my $c (@class_list) {
     DEBUG > 4 and print "Trying to load $c...\n";
@@ -994,6 +997,8 @@ sub new_translator { # $tr = $self->new_
     my $self = shift;
     my $lang = shift;
 
+    local @INC = @INC;
+    pop @INC if $INC[-1] eq '.';
     my $pack = 'POD2::' . uc($lang);
     eval "require $pack";
     if ( !$@ && $pack->can('new') ) {
Index: gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/BaseTo.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/BaseTo.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 BaseTo.pm
--- gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/BaseTo.pm	17 Nov 2014 20:52:58 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/BaseTo.pm	5 Aug 2016 16:34:26 -0000
@@ -3,7 +3,7 @@ use strict;
 use warnings;
 
 use vars qw($VERSION);
-$VERSION = '3.23';
+$VERSION = '3.23_01';
 
 use Carp                  qw(croak carp);
 use Config                qw(%Config);
Index: gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/GetOptsOO.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/GetOptsOO.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 GetOptsOO.pm
--- gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/GetOptsOO.pm	17 Nov 2014 20:52:58 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/GetOptsOO.pm	5 Aug 2016 16:34:26 -0000
@@ -2,7 +2,7 @@ package Pod::Perldoc::GetOptsOO;
 use strict;
 
 use vars qw($VERSION);
-$VERSION = '3.23';
+$VERSION = '3.23_01';
 
 BEGIN { # Make a DEBUG constant ASAP
   *DEBUG = defined( &Pod::Perldoc::DEBUG )
Index: gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToANSI.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToANSI.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 ToANSI.pm
--- gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToANSI.pm	17 Nov 2014 20:52:58 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToANSI.pm	5 Aug 2016 16:34:26 -0000
@@ -4,7 +4,7 @@ use warnings;
 use parent qw(Pod::Perldoc::BaseTo);
 
 use vars qw($VERSION);
-$VERSION = '3.23';
+$VERSION = '3.23_01';
 
 sub is_pageable        { 1 }
 sub write_with_binmode { 0 }
Index: gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToChecker.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToChecker.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 ToChecker.pm
--- gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToChecker.pm	17 Nov 2014 20:52:58 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToChecker.pm	5 Aug 2016 16:34:26 -0000
@@ -4,7 +4,7 @@ use warnings;
 use vars qw(@ISA);
 
 use vars qw($VERSION);
-$VERSION = '3.23';
+$VERSION = '3.23_01';
 
 # Pick our superclass...
 #
Index: gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToMan.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToMan.pm,v
retrieving revision 1.5
diff -u -p -r1.5 ToMan.pm
--- gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToMan.pm	17 Nov 2014 20:57:03 -0000	1.5
+++ gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToMan.pm	5 Aug 2016 16:34:26 -0000
@@ -5,7 +5,7 @@ use warnings;
 use parent qw(Pod::Perldoc::BaseTo);
 
 use vars qw($VERSION);
-$VERSION = '3.23';
+$VERSION = '3.23_01';
 
 use File::Spec::Functions qw(catfile);
 use Pod::Man 2.18;
Index: gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToNroff.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToNroff.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 ToNroff.pm
--- gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToNroff.pm	17 Nov 2014 20:52:58 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToNroff.pm	5 Aug 2016 16:34:26 -0000
@@ -4,7 +4,7 @@ use warnings;
 use parent qw(Pod::Perldoc::BaseTo);
 
 use vars qw($VERSION);
-$VERSION = '3.23';
+$VERSION = '3.23_01';
 
 # This is unlike ToMan.pm in that it emits the raw nroff source!
 
Index: gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToPod.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToPod.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 ToPod.pm
--- gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToPod.pm	17 Nov 2014 20:52:58 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToPod.pm	5 Aug 2016 16:34:26 -0000
@@ -4,7 +4,7 @@ use warnings;
 use parent qw(Pod::Perldoc::BaseTo);
 
 use vars qw($VERSION);
-$VERSION = '3.23';
+$VERSION = '3.23_01';
 
 sub is_pageable        { 1 }
 sub write_with_binmode { 0 }
Index: gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToRtf.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToRtf.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 ToRtf.pm
--- gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToRtf.pm	17 Nov 2014 20:52:58 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToRtf.pm	5 Aug 2016 16:34:26 -0000
@@ -4,7 +4,7 @@ use warnings;
 use parent qw( Pod::Simple::RTF );
 
 use vars qw($VERSION);
-$VERSION = '3.23';
+$VERSION = '3.23_01';
 
 sub is_pageable        { 0 }
 sub write_with_binmode { 0 }
Index: gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToTerm.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToTerm.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 ToTerm.pm
--- gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToTerm.pm	17 Nov 2014 20:52:58 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToTerm.pm	5 Aug 2016 16:34:26 -0000
@@ -3,7 +3,7 @@ use strict;
 use warnings;
 
 use vars qw($VERSION);
-$VERSION = '3.23';
+$VERSION = '3.23_01';
 
 use parent qw(Pod::Perldoc::BaseTo);
 
Index: gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToText.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToText.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 ToText.pm
--- gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToText.pm	17 Nov 2014 20:52:58 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToText.pm	5 Aug 2016 16:34:26 -0000
@@ -3,7 +3,7 @@ use strict;
 use warnings;
 
 use vars qw($VERSION);
-$VERSION = '3.23';
+$VERSION = '3.23_01';
 
 use parent qw(Pod::Perldoc::BaseTo);
 
Index: gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToTk.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToTk.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 ToTk.pm
--- gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToTk.pm	17 Nov 2014 20:52:58 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToTk.pm	5 Aug 2016 16:34:26 -0000
@@ -3,7 +3,7 @@ use strict;
 use warnings;
 
 use vars qw($VERSION);
-$VERSION = '3.23';
+$VERSION = '3.23_01';
 
 use parent qw(Pod::Perldoc::BaseTo);
 
Index: gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToXml.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToXml.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 ToXml.pm
--- gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToXml.pm	17 Nov 2014 20:52:58 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Pod-Perldoc/lib/Pod/Perldoc/ToXml.pm	5 Aug 2016 16:34:26 -0000
@@ -6,7 +6,7 @@ use vars qw($VERSION);
 use parent qw( Pod::Simple::XMLOutStream );
 
 use vars qw($VERSION);
-$VERSION = '3.23';
+$VERSION = '3.23_01';
 
 sub is_pageable        { 0 }
 sub write_with_binmode { 0 }
Index: gnu/usr.bin/perl/cpan/Sys-Syslog/Syslog.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Sys-Syslog/Syslog.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Syslog.pm
--- gnu/usr.bin/perl/cpan/Sys-Syslog/Syslog.pm	17 Nov 2014 20:52:58 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Sys-Syslog/Syslog.pm	5 Aug 2016 16:34:26 -0000
@@ -11,7 +11,7 @@ require 5.005;
 
 
 {   no strict 'vars';
-    $VERSION = '0.33';
+    $VERSION = '0.33_01';
 
     %EXPORT_TAGS = (
         standard => [qw(openlog syslog closelog setlogmask)],
@@ -888,6 +888,8 @@ sub silent_eval (&) {
 sub can_load {
     my ($module, $verbose) = @_;
     local($SIG{__DIE__}, $SIG{__WARN__}, $@);
+    local @INC = @INC;
+    pop @INC if $INC[-1] eq '.';
     my $loaded = eval "use $module; 1";
     warn $@ if not $loaded and $verbose;
     return $loaded
Index: gnu/usr.bin/perl/cpan/Test/lib/Test.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test/lib/Test.pm,v
retrieving revision 1.1.1.2
diff -u -p -r1.1.1.2 Test.pm
--- gnu/usr.bin/perl/cpan/Test/lib/Test.pm	24 Mar 2014 14:58:57 -0000	1.1.1.2
+++ gnu/usr.bin/perl/cpan/Test/lib/Test.pm	5 Aug 2016 16:34:26 -0000
@@ -20,7 +20,7 @@ sub _reset_globals {
     $planned    = 0;
 }
 
-$VERSION = '1.26';
+$VERSION = '1.26_01';
 require Exporter;
 @ISA=('Exporter');
 
@@ -480,7 +480,12 @@ sub _diff_complain {
     my($result, $expected, $detail, $prefix) = @_;
     return _diff_complain_external(@_) if $ENV{PERL_TEST_DIFF};
     return _diff_complain_algdiff(@_)
-     if eval { require Algorithm::Diff; Algorithm::Diff->VERSION(1.15); 1; };
+      if eval {
+          local @INC = @INC;
+          pop @INC if $INC[-1] eq '.';
+          require Algorithm::Diff; Algorithm::Diff->VERSION(1.15);
+          1;
+      };
 
     $told_about_diff++ or print $TESTERR <<"EOT";
 # $prefix   (Install the Algorithm::Diff module to have differences in multiline
Index: gnu/usr.bin/perl/cpan/Test-Harness/bin/prove
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/bin/prove,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 prove
--- gnu/usr.bin/perl/cpan/Test-Harness/bin/prove	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/bin/prove	5 Aug 2016 16:34:26 -0000
@@ -1,5 +1,6 @@
 #!/usr/bin/perl -w
 
+BEGIN { pop @INC if $INC[-1] eq '.' }
 use strict;
 use warnings;
 use App::Prove;
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/App/Prove.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/App/Prove.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Prove.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/App/Prove.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/App/Prove.pm	5 Aug 2016 16:34:26 -0000
@@ -22,7 +22,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 DESCRIPTION
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/App/Prove/State.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/App/Prove/State.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 State.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/App/Prove/State.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/App/Prove/State.pm	5 Aug 2016 16:34:26 -0000
@@ -29,7 +29,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 DESCRIPTION
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/App/Prove/State/Result.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/App/Prove/State/Result.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Result.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/App/Prove/State/Result.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/App/Prove/State/Result.pm	5 Aug 2016 16:34:26 -0000
@@ -18,7 +18,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 DESCRIPTION
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/App/Prove/State/Result/Test.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/App/Prove/State/Result/Test.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Test.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/App/Prove/State/Result/Test.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/App/Prove/State/Result/Test.pm	5 Aug 2016 16:34:26 -0000
@@ -13,7 +13,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 DESCRIPTION
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Base.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Base.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Base.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Base.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Base.pm	5 Aug 2016 16:34:26 -0000
@@ -16,7 +16,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 use constant GOT_TIME_HIRES => do {
     eval 'use Time::HiRes qw(time);';
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Harness.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Harness.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Harness.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Harness.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Harness.pm	5 Aug 2016 16:34:26 -0000
@@ -20,7 +20,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 $ENV{HARNESS_ACTIVE}  = 1;
 $ENV{HARNESS_VERSION} = $VERSION;
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Object.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Object.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Object.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Object.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Object.pm	5 Aug 2016 16:34:26 -0000
@@ -13,7 +13,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 SYNOPSIS
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Parser.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser.pm	5 Aug 2016 16:34:26 -0000
@@ -31,7 +31,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 my $DEFAULT_TAP_VERSION = 12;
 my $MAX_TAP_VERSION     = 13;
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Base.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Base.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Base.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Base.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Base.pm	5 Aug 2016 16:34:26 -0000
@@ -62,7 +62,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 DESCRIPTION
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Color.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Color.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Color.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Color.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Color.pm	5 Aug 2016 16:34:26 -0000
@@ -75,7 +75,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 DESCRIPTION
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Console.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Console.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Console.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Console.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Console.pm	5 Aug 2016 16:34:26 -0000
@@ -15,7 +15,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 DESCRIPTION
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/File.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/File.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 File.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/File.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/File.pm	5 Aug 2016 16:34:26 -0000
@@ -17,7 +17,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 DESCRIPTION
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Session.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Session.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Session.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Session.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Session.pm	5 Aug 2016 16:34:26 -0000
@@ -27,7 +27,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 METHODS
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Console/ParallelSession.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Console/ParallelSession.pm,v
retrieving revision 1.5
diff -u -p -r1.5 ParallelSession.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Console/ParallelSession.pm	17 Nov 2014 20:57:03 -0000	1.5
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Console/ParallelSession.pm	5 Aug 2016 16:34:26 -0000
@@ -45,7 +45,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 DESCRIPTION
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Console/Session.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Console/Session.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Session.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Console/Session.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/Console/Session.pm	5 Aug 2016 16:34:26 -0000
@@ -30,7 +30,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 DESCRIPTION
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/File/Session.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/File/Session.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Session.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/File/Session.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Formatter/File/Session.pm	5 Aug 2016 16:34:26 -0000
@@ -14,7 +14,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 DESCRIPTION
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Harness/Env.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Harness/Env.pm,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 Env.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Harness/Env.pm	17 Nov 2014 20:52:59 -0000	1.1.1.1
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Harness/Env.pm	5 Aug 2016 16:34:26 -0000
@@ -7,7 +7,7 @@ use constant IS_VMS => ( $^O eq 'VMS' );
 use TAP::Object;
 use Text::ParseWords qw/shellwords/;
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 # Get the parts of @INC which are changed from the stock list AND
 # preserve reordering of stock directories.
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Aggregator.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Aggregator.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Aggregator.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Aggregator.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Aggregator.pm	5 Aug 2016 16:34:26 -0000
@@ -16,7 +16,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 SYNOPSIS
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Grammar.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Grammar.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Grammar.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Grammar.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Grammar.pm	5 Aug 2016 16:34:26 -0000
@@ -18,7 +18,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 SYNOPSIS
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Iterator.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Iterator.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Iterator.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Iterator.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Iterator.pm	5 Aug 2016 16:34:26 -0000
@@ -15,7 +15,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 SYNOPSIS
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/IteratorFactory.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/IteratorFactory.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 IteratorFactory.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/IteratorFactory.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/IteratorFactory.pm	5 Aug 2016 16:34:26 -0000
@@ -20,7 +20,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 SYNOPSIS
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Multiplexer.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Multiplexer.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Multiplexer.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Multiplexer.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Multiplexer.pm	5 Aug 2016 16:34:26 -0000
@@ -21,7 +21,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 SYNOPSIS
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Result.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result.pm	5 Aug 2016 16:34:26 -0000
@@ -28,7 +28,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 SYNOPSIS
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/ResultFactory.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/ResultFactory.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 ResultFactory.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/ResultFactory.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/ResultFactory.pm	5 Aug 2016 16:34:26 -0000
@@ -33,7 +33,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head2 DESCRIPTION
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Scheduler.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Scheduler.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Scheduler.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Scheduler.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Scheduler.pm	5 Aug 2016 16:34:26 -0000
@@ -17,7 +17,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 SYNOPSIS
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Source.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Source.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Source.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Source.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Source.pm	5 Aug 2016 16:34:26 -0000
@@ -18,7 +18,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 SYNOPSIS
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 SourceHandler.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler.pm	17 Nov 2014 20:52:59 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler.pm	5 Aug 2016 16:34:26 -0000
@@ -16,7 +16,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 SYNOPSIS
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Iterator/Array.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Iterator/Array.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Array.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Iterator/Array.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Iterator/Array.pm	5 Aug 2016 16:34:26 -0000
@@ -15,7 +15,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 SYNOPSIS
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Iterator/Process.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Iterator/Process.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Process.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Iterator/Process.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Iterator/Process.pm	5 Aug 2016 16:34:26 -0000
@@ -20,7 +20,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 SYNOPSIS
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Iterator/Stream.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Iterator/Stream.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Stream.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Iterator/Stream.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Iterator/Stream.pm	5 Aug 2016 16:34:26 -0000
@@ -15,7 +15,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 SYNOPSIS
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Bailout.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Bailout.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Bailout.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Bailout.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Bailout.pm	5 Aug 2016 16:34:26 -0000
@@ -15,7 +15,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 DESCRIPTION
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Comment.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Comment.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Comment.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Comment.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Comment.pm	5 Aug 2016 16:34:26 -0000
@@ -15,7 +15,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 DESCRIPTION
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Plan.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Plan.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Plan.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Plan.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Plan.pm	5 Aug 2016 16:34:26 -0000
@@ -15,7 +15,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 DESCRIPTION
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Pragma.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Pragma.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Pragma.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Pragma.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Pragma.pm	5 Aug 2016 16:34:26 -0000
@@ -15,7 +15,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 DESCRIPTION
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Test.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Test.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Test.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Test.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Test.pm	5 Aug 2016 16:34:26 -0000
@@ -15,7 +15,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 DESCRIPTION
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Unknown.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Unknown.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Unknown.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Unknown.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Unknown.pm	5 Aug 2016 16:34:26 -0000
@@ -15,7 +15,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 DESCRIPTION
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Version.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Version.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Version.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Version.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/Version.pm	5 Aug 2016 16:34:26 -0000
@@ -15,7 +15,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 DESCRIPTION
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/YAML.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/YAML.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 YAML.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/YAML.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Result/YAML.pm	5 Aug 2016 16:34:26 -0000
@@ -15,7 +15,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 DESCRIPTION
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Scheduler/Job.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Scheduler/Job.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Job.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Scheduler/Job.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Scheduler/Job.pm	5 Aug 2016 16:34:26 -0000
@@ -14,7 +14,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 SYNOPSIS
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Scheduler/Spinner.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Scheduler/Spinner.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Spinner.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Scheduler/Spinner.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/Scheduler/Spinner.pm	5 Aug 2016 16:34:26 -0000
@@ -14,7 +14,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 SYNOPSIS
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler/Executable.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler/Executable.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 Executable.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler/Executable.pm	17 Nov 2014 20:52:59 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler/Executable.pm	5 Aug 2016 16:34:26 -0000
@@ -20,7 +20,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 SYNOPSIS
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler/File.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler/File.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 File.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler/File.pm	17 Nov 2014 20:52:59 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler/File.pm	5 Aug 2016 16:34:26 -0000
@@ -20,7 +20,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 SYNOPSIS
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler/Handle.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler/Handle.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 Handle.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler/Handle.pm	17 Nov 2014 20:52:59 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler/Handle.pm	5 Aug 2016 16:34:26 -0000
@@ -20,7 +20,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 SYNOPSIS
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler/Perl.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler/Perl.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 Perl.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler/Perl.pm	17 Nov 2014 20:52:59 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler/Perl.pm	5 Aug 2016 16:34:26 -0000
@@ -25,7 +25,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 SYNOPSIS
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler/RawTAP.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler/RawTAP.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 RawTAP.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler/RawTAP.pm	17 Nov 2014 20:52:59 -0000	1.1.1.3
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/SourceHandler/RawTAP.pm	5 Aug 2016 16:34:26 -0000
@@ -20,7 +20,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 =head1 SYNOPSIS
 
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/YAMLish/Reader.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/YAMLish/Reader.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Reader.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/YAMLish/Reader.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/YAMLish/Reader.pm	5 Aug 2016 16:34:26 -0000
@@ -5,7 +5,7 @@ use warnings;
 
 use base 'TAP::Object';
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 # TODO:
 #   Handle blessed object syntax
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/YAMLish/Writer.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/YAMLish/Writer.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Writer.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/YAMLish/Writer.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/TAP/Parser/YAMLish/Writer.pm	5 Aug 2016 16:34:26 -0000
@@ -5,7 +5,7 @@ use warnings;
 
 use base 'TAP::Object';
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 my $ESCAPE_CHAR = qr{ [ \x00-\x1f \" ] }x;
 my $ESCAPE_KEY  = qr{ (?: ^\W ) | $ESCAPE_CHAR }x;
Index: gnu/usr.bin/perl/cpan/Test-Harness/lib/Test/Harness.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/Test-Harness/lib/Test/Harness.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Harness.pm
--- gnu/usr.bin/perl/cpan/Test-Harness/lib/Test/Harness.pm	17 Nov 2014 20:52:59 -0000	1.1.1.4
+++ gnu/usr.bin/perl/cpan/Test-Harness/lib/Test/Harness.pm	5 Aug 2016 16:34:26 -0000
@@ -35,7 +35,7 @@ Version 3.30
 
 =cut
 
-our $VERSION = '3.30';
+our $VERSION = '3.30_01';
 
 # Backwards compatibility for exportable variable names.
 *verbose  = *Verbose;
Index: gnu/usr.bin/perl/cpan/libnet/Net/Cmd.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/libnet/Net/Cmd.pm,v
retrieving revision 1.2
diff -u -p -r1.2 Cmd.pm
--- gnu/usr.bin/perl/cpan/libnet/Net/Cmd.pm	5 Sep 2014 06:53:07 -0000	1.2
+++ gnu/usr.bin/perl/cpan/libnet/Net/Cmd.pm	5 Aug 2016 16:34:26 -0000
@@ -37,7 +37,7 @@ BEGIN {
   }
 }
 
-$VERSION = "2.30";
+$VERSION = "2.30_01";
 @ISA     = qw(Exporter);
 @EXPORT  = qw(CMD_INFO CMD_OK CMD_MORE CMD_REJECT CMD_ERROR CMD_PENDING);
 
Index: gnu/usr.bin/perl/cpan/libnet/Net/Config.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/libnet/Net/Config.pm,v
retrieving revision 1.3
diff -u -p -r1.3 Config.pm
--- gnu/usr.bin/perl/cpan/libnet/Net/Config.pm	17 Nov 2014 20:57:04 -0000	1.3
+++ gnu/usr.bin/perl/cpan/libnet/Net/Config.pm	5 Aug 2016 16:34:26 -0000
@@ -13,9 +13,14 @@ use strict;
 
 @EXPORT  = qw(%NetConfig);
 @ISA     = qw(Net::LocalCfg Exporter);
-$VERSION = "1.13";
+$VERSION = "1.13_01";
 
-eval { local $SIG{__DIE__}; require Net::LocalCfg };
+eval {
+  local @INC = @INC;
+  pop @INC if $INC[-1] eq '.';
+  local $SIG{__DIE__};
+  require Net::LocalCfg;
+};
 
 %NetConfig = (
   nntp_hosts      => [],
Index: gnu/usr.bin/perl/cpan/libnet/Net/Domain.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/libnet/Net/Domain.pm,v
retrieving revision 1.2
diff -u -p -r1.2 Domain.pm
--- gnu/usr.bin/perl/cpan/libnet/Net/Domain.pm	5 Sep 2014 06:53:07 -0000	1.2
+++ gnu/usr.bin/perl/cpan/libnet/Net/Domain.pm	5 Aug 2016 16:34:27 -0000
@@ -16,7 +16,7 @@ use Net::Config;
 @ISA       = qw(Exporter);
 @EXPORT_OK = qw(hostname hostdomain hostfqdn domainname);
 
-$VERSION = "2.23";
+$VERSION = "2.23_01";
 
 my ($host, $domain, $fqdn) = (undef, undef, undef);
 
Index: gnu/usr.bin/perl/cpan/libnet/Net/FTP.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/libnet/Net/FTP.pm,v
retrieving revision 1.2
diff -u -p -r1.2 FTP.pm
--- gnu/usr.bin/perl/cpan/libnet/Net/FTP.pm	5 Sep 2014 06:53:07 -0000	1.2
+++ gnu/usr.bin/perl/cpan/libnet/Net/FTP.pm	5 Aug 2016 16:34:27 -0000
@@ -21,7 +21,7 @@ use Net::Cmd;
 use Net::Config;
 use Fcntl qw(O_WRONLY O_RDONLY O_APPEND O_CREAT O_TRUNC);
 
-$VERSION = '2.79';
+$VERSION = '2.79_01';
 @ISA     = qw(Exporter Net::Cmd IO::Socket::INET);
 
 # Someday I will "use constant", when I am not bothered to much about
Index: gnu/usr.bin/perl/cpan/libnet/Net/NNTP.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/libnet/Net/NNTP.pm,v
retrieving revision 1.2
diff -u -p -r1.2 NNTP.pm
--- gnu/usr.bin/perl/cpan/libnet/Net/NNTP.pm	5 Sep 2014 06:53:07 -0000	1.2
+++ gnu/usr.bin/perl/cpan/libnet/Net/NNTP.pm	5 Aug 2016 16:34:27 -0000
@@ -14,7 +14,7 @@ use Carp;
 use Time::Local;
 use Net::Config;
 
-$VERSION = "2.26";
+$VERSION = "2.26_01";
 @ISA     = qw(Net::Cmd IO::Socket::INET);
 
 
Index: gnu/usr.bin/perl/cpan/libnet/Net/Netrc.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/libnet/Net/Netrc.pm,v
retrieving revision 1.2
diff -u -p -r1.2 Netrc.pm
--- gnu/usr.bin/perl/cpan/libnet/Net/Netrc.pm	5 Sep 2014 06:53:07 -0000	1.2
+++ gnu/usr.bin/perl/cpan/libnet/Net/Netrc.pm	5 Aug 2016 16:34:27 -0000
@@ -11,7 +11,7 @@ use strict;
 use FileHandle;
 use vars qw($VERSION $TESTING);
 
-$VERSION = "2.14";
+$VERSION = "2.14_01";
 
 my %netrc = ();
 
Index: gnu/usr.bin/perl/cpan/libnet/Net/POP3.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/libnet/Net/POP3.pm,v
retrieving revision 1.2
diff -u -p -r1.2 POP3.pm
--- gnu/usr.bin/perl/cpan/libnet/Net/POP3.pm	5 Sep 2014 06:53:07 -0000	1.2
+++ gnu/usr.bin/perl/cpan/libnet/Net/POP3.pm	5 Aug 2016 16:34:27 -0000
@@ -13,7 +13,7 @@ use Net::Cmd;
 use Carp;
 use Net::Config;
 
-$VERSION = "2.31";
+$VERSION = "2.31_01";
 
 @ISA = qw(Net::Cmd IO::Socket::INET);
 
Index: gnu/usr.bin/perl/cpan/libnet/Net/SMTP.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/libnet/Net/SMTP.pm,v
retrieving revision 1.3
diff -u -p -r1.3 SMTP.pm
--- gnu/usr.bin/perl/cpan/libnet/Net/SMTP.pm	17 Nov 2014 20:57:04 -0000	1.3
+++ gnu/usr.bin/perl/cpan/libnet/Net/SMTP.pm	5 Aug 2016 16:34:27 -0000
@@ -16,7 +16,7 @@ use IO::Socket;
 use Net::Cmd;
 use Net::Config;
 
-$VERSION = "2.33";
+$VERSION = "2.33_01";
 
 @ISA = qw(Net::Cmd IO::Socket::INET);
 
Index: gnu/usr.bin/perl/cpan/libnet/Net/Time.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/libnet/Net/Time.pm,v
retrieving revision 1.3
diff -u -p -r1.3 Time.pm
--- gnu/usr.bin/perl/cpan/libnet/Net/Time.pm	17 Nov 2014 20:57:04 -0000	1.3
+++ gnu/usr.bin/perl/cpan/libnet/Net/Time.pm	5 Aug 2016 16:34:27 -0000
@@ -17,7 +17,7 @@ use IO::Select;
 @ISA       = qw(Exporter);
 @EXPORT_OK = qw(inet_time inet_daytime);
 
-$VERSION = "2.10";
+$VERSION = "2.10_01";
 
 $TIMEOUT = 120;
 
Index: gnu/usr.bin/perl/cpan/libnet/Net/FTP/A.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/libnet/Net/FTP/A.pm,v
retrieving revision 1.2
diff -u -p -r1.2 A.pm
--- gnu/usr.bin/perl/cpan/libnet/Net/FTP/A.pm	5 Sep 2014 06:53:07 -0000	1.2
+++ gnu/usr.bin/perl/cpan/libnet/Net/FTP/A.pm	5 Aug 2016 16:34:27 -0000
@@ -10,7 +10,7 @@ use Carp;
 require Net::FTP::dataconn;
 
 @ISA     = qw(Net::FTP::dataconn);
-$VERSION = "1.19";
+$VERSION = "1.19_01";
 
 
 sub read {
Index: gnu/usr.bin/perl/cpan/libnet/Net/FTP/E.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/libnet/Net/FTP/E.pm,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 E.pm
--- gnu/usr.bin/perl/cpan/libnet/Net/FTP/E.pm	24 Sep 2010 14:49:06 -0000	1.1.1.1
+++ gnu/usr.bin/perl/cpan/libnet/Net/FTP/E.pm	5 Aug 2016 16:34:27 -0000
@@ -3,6 +3,6 @@ package Net::FTP::E;
 require Net::FTP::I;
 
 @ISA = qw(Net::FTP::I);
-$VERSION = "0.01";
+$VERSION = "0.01_01";
 
 1;
Index: gnu/usr.bin/perl/cpan/libnet/Net/FTP/I.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/libnet/Net/FTP/I.pm,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 I.pm
--- gnu/usr.bin/perl/cpan/libnet/Net/FTP/I.pm	24 Sep 2010 14:49:06 -0000	1.1.1.1
+++ gnu/usr.bin/perl/cpan/libnet/Net/FTP/I.pm	5 Aug 2016 16:34:27 -0000
@@ -10,7 +10,7 @@ use Carp;
 require Net::FTP::dataconn;
 
 @ISA     = qw(Net::FTP::dataconn);
-$VERSION = "1.12";
+$VERSION = "1.12_01";
 
 
 sub read {
Index: gnu/usr.bin/perl/cpan/libnet/Net/FTP/L.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/libnet/Net/FTP/L.pm,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 L.pm
--- gnu/usr.bin/perl/cpan/libnet/Net/FTP/L.pm	24 Sep 2010 14:49:06 -0000	1.1.1.1
+++ gnu/usr.bin/perl/cpan/libnet/Net/FTP/L.pm	5 Aug 2016 16:34:27 -0000
@@ -3,6 +3,6 @@ package Net::FTP::L;
 require Net::FTP::I;
 
 @ISA = qw(Net::FTP::I);
-$VERSION = "0.01";
+$VERSION = "0.01_01";
 
 1;
Index: gnu/usr.bin/perl/cpan/libnet/Net/FTP/dataconn.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/cpan/libnet/Net/FTP/dataconn.pm,v
retrieving revision 1.3
diff -u -p -r1.3 dataconn.pm
--- gnu/usr.bin/perl/cpan/libnet/Net/FTP/dataconn.pm	5 Sep 2014 06:53:07 -0000	1.3
+++ gnu/usr.bin/perl/cpan/libnet/Net/FTP/dataconn.pm	5 Aug 2016 16:34:27 -0000
@@ -9,7 +9,7 @@ use vars qw(@ISA $timeout $VERSION);
 use Net::Cmd;
 use Errno;
 
-$VERSION = '0.12';
+$VERSION = '0.12_01';
 @ISA     = qw(IO::Socket::INET);
 
 
Index: gnu/usr.bin/perl/dist/ExtUtils-Command/lib/ExtUtils/Command.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/ExtUtils-Command/lib/ExtUtils/Command.pm,v
retrieving revision 1.1.1.2
diff -u -p -r1.1.1.2 Command.pm
--- gnu/usr.bin/perl/dist/ExtUtils-Command/lib/ExtUtils/Command.pm	17 Nov 2014 20:53:03 -0000	1.1.1.2
+++ gnu/usr.bin/perl/dist/ExtUtils-Command/lib/ExtUtils/Command.pm	5 Aug 2016 16:34:27 -0000
@@ -12,7 +12,7 @@ use vars qw(@ISA @EXPORT @EXPORT_OK $VER
 @ISA       = qw(Exporter);
 @EXPORT    = qw(cp rm_f rm_rf mv cat eqtime mkpath touch test_f test_d chmod
                 dos2unix);
-$VERSION = '1.18';
+$VERSION = '1.18_01';
 
 my $Is_VMS   = $^O eq 'VMS';
 my $Is_VMS_mode = $Is_VMS;
@@ -24,7 +24,10 @@ if( $Is_VMS ) {
     my $vms_efs;
     my $vms_case;
 
-    if (eval { local $SIG{__DIE__}; require VMS::Feature; }) {
+    if (eval { local $SIG{__DIE__};
+               local @INC = @INC;
+               pop @INC if $INC[-1] eq '.';
+               require VMS::Feature; }) {
         $vms_unix_rpt = VMS::Feature::current("filename_unix_report");
         $vms_efs = VMS::Feature::current("efs_charset");
         $vms_case = VMS::Feature::current("efs_case_preserve");
Index: gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/ParseXS.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/ParseXS.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 ParseXS.pm
--- gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/ParseXS.pm	17 Nov 2014 20:53:03 -0000	1.1.1.3
+++ gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/ParseXS.pm	5 Aug 2016 16:34:27 -0000
@@ -11,7 +11,7 @@ use Symbol;
 
 our $VERSION;
 BEGIN {
-  $VERSION = '3.24';
+  $VERSION = '3.24_01';
 }
 use ExtUtils::ParseXS::Constants $VERSION;
 use ExtUtils::ParseXS::CountLines $VERSION;
Index: gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/Typemaps.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/Typemaps.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 Typemaps.pm
--- gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/Typemaps.pm	17 Nov 2014 20:53:03 -0000	1.1.1.3
+++ gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/Typemaps.pm	5 Aug 2016 16:34:27 -0000
@@ -2,7 +2,7 @@ package ExtUtils::Typemaps;
 use 5.006001;
 use strict;
 use warnings;
-our $VERSION = '3.24';
+our $VERSION = '3.24_01';
 #use Carp qw(croak);
 
 require ExtUtils::ParseXS;
Index: gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/xsubpp
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/xsubpp,v
retrieving revision 1.1.1.2
diff -u -p -r1.1.1.2 xsubpp
--- gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/xsubpp	17 Nov 2014 20:53:03 -0000	1.1.1.2
+++ gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/xsubpp	5 Aug 2016 16:34:27 -0000
@@ -1,5 +1,6 @@
 #!perl
 use 5.006;
+BEGIN { pop @INC if $INC[-1] eq '.' }
 use strict;
 eval {
   require ExtUtils::ParseXS;
Index: gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/ParseXS/Constants.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/ParseXS/Constants.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 Constants.pm
--- gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/ParseXS/Constants.pm	17 Nov 2014 20:53:03 -0000	1.1.1.3
+++ gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/ParseXS/Constants.pm	5 Aug 2016 16:34:27 -0000
@@ -3,7 +3,7 @@ use strict;
 use warnings;
 use Symbol;
 
-our $VERSION = '3.24';
+our $VERSION = '3.24_01';
 
 =head1 NAME
 
Index: gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/ParseXS/CountLines.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/ParseXS/CountLines.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 CountLines.pm
--- gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/ParseXS/CountLines.pm	17 Nov 2014 20:53:03 -0000	1.1.1.3
+++ gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/ParseXS/CountLines.pm	5 Aug 2016 16:34:27 -0000
@@ -1,7 +1,7 @@
 package ExtUtils::ParseXS::CountLines;
 use strict;
 
-our $VERSION = '3.24';
+our $VERSION = '3.24_01';
 
 our $SECTION_END_MARKER;
 
Index: gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/ParseXS/Eval.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/ParseXS/Eval.pm,v
retrieving revision 1.1.1.1
diff -u -p -r1.1.1.1 Eval.pm
--- gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/ParseXS/Eval.pm	17 Nov 2014 20:53:03 -0000	1.1.1.1
+++ gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/ParseXS/Eval.pm	5 Aug 2016 16:34:27 -0000
@@ -2,7 +2,7 @@ package ExtUtils::ParseXS::Eval;
 use strict;
 use warnings;
 
-our $VERSION = '3.24';
+our $VERSION = '3.24_01';
 
 =head1 NAME
 
Index: gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/ParseXS/Utilities.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/ParseXS/Utilities.pm,v
retrieving revision 1.7
diff -u -p -r1.7 Utilities.pm
--- gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/ParseXS/Utilities.pm	25 Apr 2015 19:26:21 -0000	1.7
+++ gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/ParseXS/Utilities.pm	5 Aug 2016 16:34:27 -0000
@@ -5,7 +5,7 @@ use Exporter;
 use File::Spec;
 use ExtUtils::ParseXS::Constants ();
 
-our $VERSION = '3.24';
+our $VERSION = '3.24_01';
 
 our (@ISA, @EXPORT_OK);
 @ISA = qw(Exporter);
Index: gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/Typemaps/Cmd.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/Typemaps/Cmd.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 Cmd.pm
--- gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/Typemaps/Cmd.pm	17 Nov 2014 20:53:03 -0000	1.1.1.3
+++ gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/Typemaps/Cmd.pm	5 Aug 2016 16:34:27 -0000
@@ -2,7 +2,7 @@ package ExtUtils::Typemaps::Cmd;
 use 5.006001;
 use strict;
 use warnings;
-our $VERSION = '3.24';
+our $VERSION = '3.24_01';
 
 use ExtUtils::Typemaps;
 
Index: gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/Typemaps/InputMap.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/Typemaps/InputMap.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 InputMap.pm
--- gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/Typemaps/InputMap.pm	17 Nov 2014 20:53:03 -0000	1.1.1.3
+++ gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/Typemaps/InputMap.pm	5 Aug 2016 16:34:27 -0000
@@ -2,7 +2,7 @@ package ExtUtils::Typemaps::InputMap;
 use 5.006001;
 use strict;
 use warnings;
-our $VERSION = '3.24';
+our $VERSION = '3.24_01';
 
 =head1 NAME
 
Index: gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/Typemaps/OutputMap.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/Typemaps/OutputMap.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 OutputMap.pm
--- gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/Typemaps/OutputMap.pm	17 Nov 2014 20:53:03 -0000	1.1.1.3
+++ gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/Typemaps/OutputMap.pm	5 Aug 2016 16:34:27 -0000
@@ -2,7 +2,7 @@ package ExtUtils::Typemaps::OutputMap;
 use 5.006001;
 use strict;
 use warnings;
-our $VERSION = '3.24';
+our $VERSION = '3.24_01';
 
 =head1 NAME
 
Index: gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/Typemaps/Type.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/Typemaps/Type.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 Type.pm
--- gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/Typemaps/Type.pm	17 Nov 2014 20:53:03 -0000	1.1.1.3
+++ gnu/usr.bin/perl/dist/ExtUtils-ParseXS/lib/ExtUtils/Typemaps/Type.pm	5 Aug 2016 16:34:27 -0000
@@ -4,7 +4,7 @@ use strict;
 use warnings;
 require ExtUtils::Typemaps;
 
-our $VERSION = '3.24';
+our $VERSION = '3.24_01';
 
 =head1 NAME
 
Index: gnu/usr.bin/perl/dist/I18N-LangTags/lib/I18N/LangTags.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/I18N-LangTags/lib/I18N/LangTags.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 LangTags.pm
--- gnu/usr.bin/perl/dist/I18N-LangTags/lib/I18N/LangTags.pm	17 Nov 2014 20:53:03 -0000	1.1.1.4
+++ gnu/usr.bin/perl/dist/I18N-LangTags/lib/I18N/LangTags.pm	5 Aug 2016 16:34:27 -0000
@@ -19,7 +19,7 @@ require Exporter;
                );
 %EXPORT_TAGS = ('ALL' => \@EXPORT_OK);
 
-$VERSION = "0.40";
+$VERSION = "0.40_01";
 
 sub uniq { my %seen; return grep(!($seen{$_}++), @_); } # a util function
 
Index: gnu/usr.bin/perl/dist/I18N-LangTags/lib/I18N/LangTags/Detect.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/I18N-LangTags/lib/I18N/LangTags/Detect.pm,v
retrieving revision 1.1.1.2
diff -u -p -r1.1.1.2 Detect.pm
--- gnu/usr.bin/perl/dist/I18N-LangTags/lib/I18N/LangTags/Detect.pm	25 Mar 2013 20:08:36 -0000	1.1.1.2
+++ gnu/usr.bin/perl/dist/I18N-LangTags/lib/I18N/LangTags/Detect.pm	5 Aug 2016 16:34:27 -0000
@@ -11,7 +11,7 @@ use vars qw( @ISA $VERSION $MATCH_SUPERS
 BEGIN { unless(defined &DEBUG) { *DEBUG = sub () {0} } }
  # define the constant 'DEBUG' at compile-time
 
-$VERSION = "1.05";
+$VERSION = "1.05_01";
 @ISA = ();
 use I18N::LangTags qw(alternate_language_tags locale2language_tag);
 
@@ -145,6 +145,8 @@ sub _try_use {   # Basically a wrapper a
   print " About to use $module ...\n" if DEBUG;
   {
     local $SIG{'__DIE__'};
+    local @INC = @INC;
+    pop @INC if $INC[-1] eq '.';
     eval "require $module"; # used to be "use $module", but no point in that.
   }
   if($@) {
Index: gnu/usr.bin/perl/dist/I18N-LangTags/lib/I18N/LangTags/List.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/I18N-LangTags/lib/I18N/LangTags/List.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 List.pm
--- gnu/usr.bin/perl/dist/I18N-LangTags/lib/I18N/LangTags/List.pm	24 Mar 2014 14:59:00 -0000	1.1.1.3
+++ gnu/usr.bin/perl/dist/I18N-LangTags/lib/I18N/LangTags/List.pm	5 Aug 2016 16:34:27 -0000
@@ -4,7 +4,7 @@ package I18N::LangTags::List;
 #  Time-stamp: "2004-10-06 23:26:21 ADT"
 use strict;
 use vars qw(%Name %Is_Disrec $Debug $VERSION);
-$VERSION = '0.39';
+$VERSION = '0.39_01';
 # POD at the end.
 
 #----------------------------------------------------------------------
Index: gnu/usr.bin/perl/dist/IO/IO.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/IO/IO.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 IO.pm
--- gnu/usr.bin/perl/dist/IO/IO.pm	17 Nov 2014 20:53:03 -0000	1.1.1.4
+++ gnu/usr.bin/perl/dist/IO/IO.pm	5 Aug 2016 16:34:27 -0000
@@ -7,7 +7,7 @@ use Carp;
 use strict;
 use warnings;
 
-our $VERSION = "1.31";
+our $VERSION = "1.31_01";
 XSLoader::load 'IO', $VERSION;
 
 sub import {
@@ -18,6 +18,8 @@ sub import {
     
     my @l = @_ ? @_ : qw(Handle Seekable File Pipe Socket Dir);
 
+    local @INC = @INC;
+    pop @INC if $INC[-1] eq '.';
     eval join("", map { "require IO::" . (/(\w+)/)[0] . ";\n" } @l)
 	or croak $@;
 }
Index: gnu/usr.bin/perl/dist/Locale-Maketext/lib/Locale/Maketext.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/Locale-Maketext/lib/Locale/Maketext.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 Maketext.pm
--- gnu/usr.bin/perl/dist/Locale-Maketext/lib/Locale/Maketext.pm	17 Nov 2014 20:53:03 -0000	1.1.1.4
+++ gnu/usr.bin/perl/dist/Locale-Maketext/lib/Locale/Maketext.pm	5 Aug 2016 16:34:27 -0000
@@ -27,7 +27,7 @@ BEGIN {
 }
 
 
-$VERSION = '1.25';
+$VERSION = '1.25_01';
 @ISA = ();
 
 $MATCH_SUPERS = 1;
@@ -449,6 +449,8 @@ sub _try_use {   # Basically a wrapper a
 
     local $SIG{'__DIE__'};
     local $@;
+    local @INC = @INC;
+    pop @INC if $INC[-1] eq '.';
     eval "require $module"; # used to be "use $module", but no point in that.
 
     if($@) {
Index: gnu/usr.bin/perl/dist/Locale-Maketext/lib/Locale/Maketext/Guts.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/Locale-Maketext/lib/Locale/Maketext/Guts.pm,v
retrieving revision 1.3
diff -u -p -r1.3 Guts.pm
--- gnu/usr.bin/perl/dist/Locale-Maketext/lib/Locale/Maketext/Guts.pm	25 Mar 2013 20:40:53 -0000	1.3
+++ gnu/usr.bin/perl/dist/Locale-Maketext/lib/Locale/Maketext/Guts.pm	5 Aug 2016 16:34:27 -0000
@@ -2,7 +2,7 @@ package Locale::Maketext::Guts;
 
 use Locale::Maketext;
 
-our $VERSION = '1.20';
+our $VERSION = '1.20_01';
 
 =head1 NAME
 
Index: gnu/usr.bin/perl/dist/Locale-Maketext/lib/Locale/Maketext/GutsLoader.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/Locale-Maketext/lib/Locale/Maketext/GutsLoader.pm,v
retrieving revision 1.1.1.2
diff -u -p -r1.1.1.2 GutsLoader.pm
--- gnu/usr.bin/perl/dist/Locale-Maketext/lib/Locale/Maketext/GutsLoader.pm	25 Mar 2013 20:08:36 -0000	1.1.1.2
+++ gnu/usr.bin/perl/dist/Locale-Maketext/lib/Locale/Maketext/GutsLoader.pm	5 Aug 2016 16:34:27 -0000
@@ -2,7 +2,7 @@ package Locale::Maketext::GutsLoader;
 
 use Locale::Maketext;
 
-our $VERSION = '1.20';
+our $VERSION = '1.20_01';
 
 sub zorp { return scalar @_ }
 
Index: gnu/usr.bin/perl/dist/Module-CoreList/corelist
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/Module-CoreList/corelist,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 corelist
--- gnu/usr.bin/perl/dist/Module-CoreList/corelist	17 Nov 2014 20:53:04 -0000	1.1.1.4
+++ gnu/usr.bin/perl/dist/Module-CoreList/corelist	5 Aug 2016 16:34:27 -0000
@@ -130,6 +130,7 @@ requested perl versions.
 
 =cut
 
+BEGIN { pop @INC if $INC[-1] eq '.' }
 use Module::CoreList;
 use Getopt::Long qw(:config no_ignore_case);
 use Pod::Usage;
Index: gnu/usr.bin/perl/dist/Module-CoreList/lib/Module/CoreList.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/Module-CoreList/lib/Module/CoreList.pm,v
retrieving revision 1.1.1.5
diff -u -p -r1.1.1.5 CoreList.pm
--- gnu/usr.bin/perl/dist/Module-CoreList/lib/Module/CoreList.pm	25 Apr 2015 19:10:34 -0000	1.1.1.5
+++ gnu/usr.bin/perl/dist/Module-CoreList/lib/Module/CoreList.pm	5 Aug 2016 16:34:28 -0000
@@ -4,7 +4,7 @@ use vars qw/$VERSION %released %version 
 	    %bug_tracker %deprecated %delta/;
 use Module::CoreList::TieHashDelta;
 use version;
-$VERSION = '5.20150214';
+$VERSION = '5.20150214_01';
 
 my $dumpinc = 0;
 sub import {
Index: gnu/usr.bin/perl/dist/Module-CoreList/lib/Module/CoreList/TieHashDelta.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/Module-CoreList/lib/Module/CoreList/TieHashDelta.pm,v
retrieving revision 1.1.1.4
diff -u -p -r1.1.1.4 TieHashDelta.pm
--- gnu/usr.bin/perl/dist/Module-CoreList/lib/Module/CoreList/TieHashDelta.pm	25 Apr 2015 19:10:34 -0000	1.1.1.4
+++ gnu/usr.bin/perl/dist/Module-CoreList/lib/Module/CoreList/TieHashDelta.pm	5 Aug 2016 16:34:28 -0000
@@ -3,7 +3,7 @@ package Module::CoreList::TieHashDelta;
 use strict;
 use vars qw($VERSION);
 
-$VERSION = '5.20150214';
+$VERSION = '5.20150214_01';
 
 sub TIEHASH {
     my ($class, $changed, $removed, $parent) = @_;
Index: gnu/usr.bin/perl/dist/Module-CoreList/lib/Module/CoreList/Utils.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/Module-CoreList/lib/Module/CoreList/Utils.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 Utils.pm
--- gnu/usr.bin/perl/dist/Module-CoreList/lib/Module/CoreList/Utils.pm	25 Apr 2015 19:10:34 -0000	1.1.1.3
+++ gnu/usr.bin/perl/dist/Module-CoreList/lib/Module/CoreList/Utils.pm	5 Aug 2016 16:34:28 -0000
@@ -6,7 +6,7 @@ use vars qw[$VERSION %utilities];
 use Module::CoreList;
 use Module::CoreList::TieHashDelta;
 
-$VERSION = '5.20150214';
+$VERSION = '5.20150214_01';
 
 sub utilities {
     my $perl = shift;
Index: gnu/usr.bin/perl/dist/Net-Ping/lib/Net/Ping.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/Net-Ping/lib/Net/Ping.pm,v
retrieving revision 1.5
diff -u -p -r1.5 Ping.pm
--- gnu/usr.bin/perl/dist/Net-Ping/lib/Net/Ping.pm	17 Nov 2014 20:57:05 -0000	1.5
+++ gnu/usr.bin/perl/dist/Net-Ping/lib/Net/Ping.pm	5 Aug 2016 16:34:28 -0000
@@ -17,7 +17,7 @@ use Time::HiRes;
 
 @ISA = qw(Exporter);
 @EXPORT = qw(pingecho);
-$VERSION = "2.43";
+$VERSION = "2.43_01";
 
 # Constants
 
@@ -410,7 +410,11 @@ sub ping_external {
       $timeout            # Seconds after which ping times out
      ) = @_;
 
-  eval { require Net::Ping::External; }
+  eval {
+    local @INC = @INC;
+    pop @INC if $INC[-1] eq '.';
+    require Net::Ping::External;
+  }
     or croak('Protocol "external" not supported on your system: Net::Ping::External not found');
   return Net::Ping::External::ping(ip => $ip, timeout => $timeout);
 }
Index: gnu/usr.bin/perl/dist/PathTools/Cwd.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/PathTools/Cwd.pm,v
retrieving revision 1.2
diff -u -p -r1.2 Cwd.pm
--- gnu/usr.bin/perl/dist/PathTools/Cwd.pm	11 Jan 2016 17:43:30 -0000	1.2
+++ gnu/usr.bin/perl/dist/PathTools/Cwd.pm	5 Aug 2016 16:35:00 -0000
@@ -171,7 +171,7 @@ use strict;
 use Exporter;
 use vars qw(@ISA @EXPORT @EXPORT_OK $VERSION);
 
-$VERSION = '3.48_01';
+$VERSION = '3.48_02';
 my $xs_version = $VERSION;
 $VERSION =~ tr/_//;
 
@@ -208,7 +208,10 @@ if ($^O eq 'os2') {
 my $use_vms_feature;
 BEGIN {
     if ($^O eq 'VMS') {
-        if (eval { local $SIG{__DIE__}; require VMS::Feature; }) {
+        if (eval { local $SIG{__DIE__};
+                   local @INC = @INC;
+                   pop @INC if $INC[-1] eq '.';
+                   require VMS::Feature; }) {
             $use_vms_feature = 1;
         }
     }
Index: gnu/usr.bin/perl/dist/PathTools/lib/File/Spec.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/PathTools/lib/File/Spec.pm,v
retrieving revision 1.2
diff -u -p -r1.2 Spec.pm
--- gnu/usr.bin/perl/dist/PathTools/lib/File/Spec.pm	11 Jan 2016 17:43:30 -0000	1.2
+++ gnu/usr.bin/perl/dist/PathTools/lib/File/Spec.pm	5 Aug 2016 16:35:00 -0000
@@ -3,7 +3,7 @@ package File::Spec;
 use strict;
 use vars qw(@ISA $VERSION);
 
-$VERSION = '3.48_01';
+$VERSION = '3.48_02';
 $VERSION =~ tr/_//;
 
 my %module = (MacOS   => 'Mac',
Index: gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Cygwin.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Cygwin.pm,v
retrieving revision 1.2
diff -u -p -r1.2 Cygwin.pm
--- gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Cygwin.pm	11 Jan 2016 17:43:30 -0000	1.2
+++ gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Cygwin.pm	5 Aug 2016 16:35:00 -0000
@@ -4,7 +4,7 @@ use strict;
 use vars qw(@ISA $VERSION);
 require File::Spec::Unix;
 
-$VERSION = '3.48_01';
+$VERSION = '3.48_02';
 $VERSION =~ tr/_//;
 
 @ISA = qw(File::Spec::Unix);
@@ -137,7 +137,11 @@ sub case_tolerant {
   if ($mntopts and ($mntopts =~ /,managed/)) {
     return 0;
   }
-  eval { require Win32API::File; } or return 1;
+  eval {
+      local @INC = @INC;
+      pop @INC if $INC[-1] eq '.';
+      require Win32API::File;
+  } or return 1;
   my $osFsType = "\0"x256;
   my $osVolName = "\0"x256;
   my $ouFsFlags = 0;
Index: gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Epoc.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Epoc.pm,v
retrieving revision 1.2
diff -u -p -r1.2 Epoc.pm
--- gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Epoc.pm	11 Jan 2016 17:43:30 -0000	1.2
+++ gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Epoc.pm	5 Aug 2016 16:35:00 -0000
@@ -3,7 +3,7 @@ package File::Spec::Epoc;
 use strict;
 use vars qw($VERSION @ISA);
 
-$VERSION = '3.48_01';
+$VERSION = '3.48_02';
 $VERSION =~ tr/_//;
 
 require File::Spec::Unix;
Index: gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Functions.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Functions.pm,v
retrieving revision 1.2
diff -u -p -r1.2 Functions.pm
--- gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Functions.pm	11 Jan 2016 17:43:30 -0000	1.2
+++ gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Functions.pm	5 Aug 2016 16:35:00 -0000
@@ -5,7 +5,7 @@ use strict;
 
 use vars qw(@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS $VERSION);
 
-$VERSION = '3.48_01';
+$VERSION = '3.48_02';
 $VERSION =~ tr/_//;
 
 require Exporter;
Index: gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Mac.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Mac.pm,v
retrieving revision 1.2
diff -u -p -r1.2 Mac.pm
--- gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Mac.pm	11 Jan 2016 17:43:30 -0000	1.2
+++ gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Mac.pm	5 Aug 2016 16:35:00 -0000
@@ -4,7 +4,7 @@ use strict;
 use vars qw(@ISA $VERSION);
 require File::Spec::Unix;
 
-$VERSION = '3.48_01';
+$VERSION = '3.48_02';
 $VERSION =~ tr/_//;
 
 @ISA = qw(File::Spec::Unix);
Index: gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/OS2.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/OS2.pm,v
retrieving revision 1.2
diff -u -p -r1.2 OS2.pm
--- gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/OS2.pm	11 Jan 2016 17:43:30 -0000	1.2
+++ gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/OS2.pm	5 Aug 2016 16:35:00 -0000
@@ -4,7 +4,7 @@ use strict;
 use vars qw(@ISA $VERSION);
 require File::Spec::Unix;
 
-$VERSION = '3.48_01';
+$VERSION = '3.48_02';
 $VERSION =~ tr/_//;
 
 @ISA = qw(File::Spec::Unix);
Index: gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Unix.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Unix.pm,v
retrieving revision 1.2
diff -u -p -r1.2 Unix.pm
--- gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Unix.pm	11 Jan 2016 17:43:30 -0000	1.2
+++ gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Unix.pm	5 Aug 2016 16:35:00 -0000
@@ -3,7 +3,7 @@ package File::Spec::Unix;
 use strict;
 use vars qw($VERSION);
 
-$VERSION = '3.48_01';
+$VERSION = '3.48_02';
 my $xs_version = $VERSION;
 $VERSION =~ tr/_//;
 
Index: gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/VMS.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/VMS.pm,v
retrieving revision 1.2
diff -u -p -r1.2 VMS.pm
--- gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/VMS.pm	11 Jan 2016 17:43:30 -0000	1.2
+++ gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/VMS.pm	5 Aug 2016 16:35:00 -0000
@@ -4,7 +4,7 @@ use strict;
 use vars qw(@ISA $VERSION);
 require File::Spec::Unix;
 
-$VERSION = '3.48_01';
+$VERSION = '3.48_02';
 $VERSION =~ tr/_//;
 
 @ISA = qw(File::Spec::Unix);
@@ -39,7 +39,10 @@ via the C<DECC$FILENAME_UNIX_REPORT> CRT
 
 my $use_feature;
 BEGIN {
-    if (eval { local $SIG{__DIE__}; require VMS::Feature; }) {
+    if (eval { local $SIG{__DIE__};
+               local @INC = @INC;
+               pop @INC if $INC[-1] eq '.';
+               require VMS::Feature; }) {
         $use_feature = 1;
     }
 }
Index: gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Win32.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Win32.pm,v
retrieving revision 1.2
diff -u -p -r1.2 Win32.pm
--- gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Win32.pm	11 Jan 2016 17:43:30 -0000	1.2
+++ gnu/usr.bin/perl/dist/PathTools/lib/File/Spec/Win32.pm	5 Aug 2016 16:35:00 -0000
@@ -5,7 +5,7 @@ use strict;
 use vars qw(@ISA $VERSION);
 require File::Spec::Unix;
 
-$VERSION = '3.48_01';
+$VERSION = '3.48_02';
 $VERSION =~ tr/_//;
 
 @ISA = qw(File::Spec::Unix);
@@ -90,7 +90,11 @@ Default: 1
 =cut
 
 sub case_tolerant {
-  eval { require Win32API::File; } or return 1;
+  eval {
+    local @INC = @INC;
+    pop @INC if $INC[-1] eq '.';
+    require Win32API::File;
+  } or return 1;
   my $drive = shift || "C:";
   my $osFsType = "\0"x256;
   my $osVolName = "\0"x256;
Index: gnu/usr.bin/perl/dist/Storable/Storable.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/Storable/Storable.pm,v
retrieving revision 1.1.1.5
diff -u -p -r1.1.1.5 Storable.pm
--- gnu/usr.bin/perl/dist/Storable/Storable.pm	25 Apr 2015 19:10:35 -0000	1.1.1.5
+++ gnu/usr.bin/perl/dist/Storable/Storable.pm	5 Aug 2016 16:34:28 -0000
@@ -22,10 +22,16 @@ package Storable; @ISA = qw(Exporter);
 
 use vars qw($canonical $forgive_me $VERSION);
 
-$VERSION = '2.49_01';
+$VERSION = '2.49_02';
 
 BEGIN {
-    if (eval { local $SIG{__DIE__}; require Log::Agent; 1 }) {
+    if (eval {
+        local $SIG{__DIE__};
+        local @INC = @INC;
+        pop @INC if $INC[-1] eq '.';
+        require Log::Agent;
+        1;
+    }) {
         Log::Agent->import;
     }
     #
Index: gnu/usr.bin/perl/dist/base/lib/base.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/base/lib/base.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 base.pm
--- gnu/usr.bin/perl/dist/base/lib/base.pm	17 Nov 2014 20:53:02 -0000	1.1.1.3
+++ gnu/usr.bin/perl/dist/base/lib/base.pm	5 Aug 2016 16:34:28 -0000
@@ -2,7 +2,7 @@ package base;
 
 use strict 'vars';
 use vars qw($VERSION);
-$VERSION = '2.22';
+$VERSION = '2.22_01';
 $VERSION = eval $VERSION;
 
 # constant.pm is slow
@@ -96,7 +96,11 @@ sub import {
             {
                 local $SIG{__DIE__};
                 my $fn = _module_to_filename($base);
-                eval { require $fn };
+                eval {
+                    local @INC = @INC;
+                    pop @INC if $INC[-1] eq '.';
+                    require $fn
+                };
                 # Only ignore "Can't locate" errors from our eval require.
                 # Other fatal errors (syntax etc) must be reported.
                 #
Index: gnu/usr.bin/perl/dist/base/lib/fields.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/base/lib/fields.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 fields.pm
--- gnu/usr.bin/perl/dist/base/lib/fields.pm	17 Nov 2014 20:53:02 -0000	1.1.1.3
+++ gnu/usr.bin/perl/dist/base/lib/fields.pm	5 Aug 2016 16:34:28 -0000
@@ -11,7 +11,7 @@ unless( eval q{require warnings::registe
 }
 use vars qw(%attr $VERSION);
 
-$VERSION = '2.17';
+$VERSION = '2.17_01';
 
 # constant.pm is slow
 sub PUBLIC     () { 2**0  }
Index: gnu/usr.bin/perl/dist/bignum/lib/bigint.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/bignum/lib/bigint.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 bigint.pm
--- gnu/usr.bin/perl/dist/bignum/lib/bigint.pm	17 Nov 2014 20:53:02 -0000	1.1.1.3
+++ gnu/usr.bin/perl/dist/bignum/lib/bigint.pm	5 Aug 2016 16:34:28 -0000
@@ -1,7 +1,7 @@
 package bigint;
 use 5.006;
 
-$VERSION = '0.36';
+$VERSION = '0.36_01';
 use Exporter;
 @ISA		= qw( Exporter );
 @EXPORT_OK	= qw( PI e bpi bexp hex oct );
@@ -248,6 +248,8 @@ sub import 
     # see if we can find Math::BigInt::Lite
     if (!defined $a && !defined $p)		# rounding won't work to well
       {
+      local @INC = @INC;
+      pop @INC if $INC[-1] eq '.';
       eval 'require Math::BigInt::Lite;';
       if ($@ eq '')
         {
Index: gnu/usr.bin/perl/dist/bignum/lib/bignum.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/bignum/lib/bignum.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 bignum.pm
--- gnu/usr.bin/perl/dist/bignum/lib/bignum.pm	17 Nov 2014 20:53:02 -0000	1.1.1.3
+++ gnu/usr.bin/perl/dist/bignum/lib/bignum.pm	5 Aug 2016 16:34:28 -0000
@@ -1,7 +1,7 @@
 package bignum;
 use 5.006;
 
-$VERSION = '0.37';
+$VERSION = '0.37_01';
 use Exporter;
 @ISA 		= qw( bigint );
 @EXPORT_OK	= qw( PI e bexp bpi hex oct ); 
@@ -155,6 +155,8 @@ sub import 
     # see if we can find Math::BigInt::Lite
     if (!defined $a && !defined $p)		# rounding won't work to well
       {
+      local @INC = @INC;
+      pop @INC if $INC[-1] eq '.';
       eval 'require Math::BigInt::Lite;';
       if ($@ eq '')
         {
Index: gnu/usr.bin/perl/dist/bignum/lib/bigrat.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/bignum/lib/bigrat.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 bigrat.pm
--- gnu/usr.bin/perl/dist/bignum/lib/bigrat.pm	17 Nov 2014 20:53:02 -0000	1.1.1.3
+++ gnu/usr.bin/perl/dist/bignum/lib/bigrat.pm	5 Aug 2016 16:34:28 -0000
@@ -1,7 +1,7 @@
 package bigrat;
 use 5.006;
 
-$VERSION = '0.36';
+$VERSION = '0.36_01';
 require Exporter;
 @ISA		= qw( bigint );
 @EXPORT_OK 	= qw( PI e bpi bexp hex oct );
@@ -148,6 +148,8 @@ sub import 
     # see if we can find Math::BigInt::Lite
     if (!defined $a && !defined $p)             # rounding won't work to well
       {
+      local @INC = @INC;
+      pop @INC if $INC[-1] eq '.';
       eval 'require Math::BigInt::Lite;';
       if ($@ eq '')
         {
Index: gnu/usr.bin/perl/dist/bignum/lib/Math/BigFloat/Trace.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/bignum/lib/Math/BigFloat/Trace.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 Trace.pm
--- gnu/usr.bin/perl/dist/bignum/lib/Math/BigFloat/Trace.pm	17 Nov 2014 20:53:02 -0000	1.1.1.3
+++ gnu/usr.bin/perl/dist/bignum/lib/Math/BigFloat/Trace.pm	5 Aug 2016 16:34:28 -0000
@@ -12,7 +12,7 @@ use vars qw($VERSION @ISA $PACKAGE @EXPO
 
 @ISA = qw(Exporter Math::BigFloat);
 
-$VERSION = '0.36';
+$VERSION = '0.36_01';
 
 use overload;	# inherit overload from BigFloat
 
Index: gnu/usr.bin/perl/dist/bignum/lib/Math/BigInt/Trace.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/dist/bignum/lib/Math/BigInt/Trace.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 Trace.pm
--- gnu/usr.bin/perl/dist/bignum/lib/Math/BigInt/Trace.pm	17 Nov 2014 20:53:02 -0000	1.1.1.3
+++ gnu/usr.bin/perl/dist/bignum/lib/Math/BigInt/Trace.pm	5 Aug 2016 16:34:28 -0000
@@ -12,7 +12,7 @@ use vars qw($VERSION @ISA $PACKAGE @EXPO
 
 @ISA = qw(Exporter Math::BigInt);
 
-$VERSION = '0.36';
+$VERSION = '0.36_01';
 
 use overload;	# inherit overload from BigInt
 
Index: gnu/usr.bin/perl/ext/Pod-Html/bin/pod2html
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/ext/Pod-Html/bin/pod2html,v
retrieving revision 1.1.1.2
diff -u -p -r1.1.1.2 pod2html
--- gnu/usr.bin/perl/ext/Pod-Html/bin/pod2html	17 Nov 2014 20:53:06 -0000	1.1.1.2
+++ gnu/usr.bin/perl/ext/Pod-Html/bin/pod2html	5 Aug 2016 16:34:28 -0000
@@ -216,6 +216,7 @@ This program is distributed under the Ar
 
 =cut
 
+BEGIN { pop @INC if $INC[-1] eq '.' }
 use Pod::Html;
 
 pod2html @ARGV;
Index: gnu/usr.bin/perl/ext/Pod-Html/lib/Pod/Html.pm
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/ext/Pod-Html/lib/Pod/Html.pm,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 Html.pm
--- gnu/usr.bin/perl/ext/Pod-Html/lib/Pod/Html.pm	17 Nov 2014 20:53:06 -0000	1.1.1.3
+++ gnu/usr.bin/perl/ext/Pod-Html/lib/Pod/Html.pm	5 Aug 2016 16:34:28 -0000
@@ -3,7 +3,7 @@ use strict;
 require Exporter;
 
 use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);
-$VERSION = 1.21;
+$VERSION = 1.21_01;
 @ISA = qw(Exporter);
 @EXPORT = qw(pod2html htmlify);
 @EXPORT_OK = qw(anchorify);
Index: gnu/usr.bin/perl/lib/perl5db.pl
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/lib/perl5db.pl,v
retrieving revision 1.18
diff -u -p -r1.18 perl5db.pl
--- gnu/usr.bin/perl/lib/perl5db.pl	17 Nov 2014 20:57:06 -0000	1.18
+++ gnu/usr.bin/perl/lib/perl5db.pl	5 Aug 2016 16:34:28 -0000
@@ -523,7 +523,7 @@ BEGIN {
 # Debugger for Perl 5.00x; perl5db.pl patch level:
 use vars qw($VERSION $header);
 
-$VERSION = '1.44';
+$VERSION = '1.44_01';
 
 $header = "perl5db.pl version $VERSION";
 
@@ -1929,7 +1929,10 @@ sub _DB__handle_y_command {
         = $obj->cmd_args =~ /\A(?:(\d*)\s*(.*))?\z/) {
 
         # See if we've got the necessary support.
-        if (!eval { require PadWalker; PadWalker->VERSION(0.08) }) {
+        if (!eval {
+            local @INC = @INC;
+            pop @INC if $INC[-1] eq '.';
+            require PadWalker; PadWalker->VERSION(0.08) }) {
             my $Err = $@;
             _db_warn(
                 $Err =~ /locate/
@@ -9364,7 +9367,10 @@ if PadWalker could be loaded.
 
 =cut
 
-        if (not $text =~ /::/ and eval { require PadWalker } ) {
+        if (not $text =~ /::/ and eval {
+            local @INC = @INC;
+            pop @INC if $INC[-1] eq '.';
+            require PadWalker } ) {
             my $level = 1;
             while (1) {
                 my @info = caller($level);
Index: gnu/usr.bin/perl/t/porting/customized.dat
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/t/porting/customized.dat,v
retrieving revision 1.4
diff -u -p -r1.4 customized.dat
--- gnu/usr.bin/perl/t/porting/customized.dat	25 Apr 2015 19:26:22 -0000	1.4
+++ gnu/usr.bin/perl/t/porting/customized.dat	5 Aug 2016 16:34:29 -0000
@@ -1,17 +1,17 @@
-CPAN cpan/CPAN/lib/CPAN/Author.pm 792d7c8fbe6ed45e1244e589a8b712878c5dd2a5
-CPAN cpan/CPAN/lib/CPAN/CacheMgr.pm 132adb7f96014ec7ded45457044ed925d3181475
-CPAN cpan/CPAN/lib/CPAN/FTP.pm 3f0d5fc572c8749a566d73ca892c6c89ce3fb676
-CPAN cpan/CPAN/lib/CPAN/HandleConfig.pm e52052b6ef6d1d664f0ffa6cf01d48a8d1321520
-CPAN cpan/CPAN/lib/CPAN/HTTP/Client.pm 242842ca566fd8e3d776deb549ff758a571ca2e3
-CPAN cpan/CPAN/lib/CPAN/Index.pm 73aee30450127c5ac4dc05abc2c10a8accd4b198
-CPAN cpan/CPAN/lib/CPAN/LWP/UserAgent.pm e09525b0c2377c5ac28b7fad1b6d70c57e343913
-CPAN cpan/CPAN/lib/CPAN/Mirrors.pm 580e74746abaf1628d533015d5b529d82a470af4
+CPAN cpan/CPAN/lib/CPAN/Author.pm 31efd07ada1df7bcc6519cad79d3c7c9e60bd67b
+CPAN cpan/CPAN/lib/CPAN/CacheMgr.pm e2815c9aa177d4d502ce792f3a528a7dd310d98e
+CPAN cpan/CPAN/lib/CPAN/FTP.pm 900d2531161ffbadce1ea1b4c66b40fbc01fa281
+CPAN cpan/CPAN/lib/CPAN/HandleConfig.pm fff963a15a4d570297c29a1d129d644746bf3c7f
+CPAN cpan/CPAN/lib/CPAN/HTTP/Client.pm dfb05ba98a9ccbbd082bf2255ed3bbd6249e4f53
+CPAN cpan/CPAN/lib/CPAN/Index.pm e16aaca226d692a886fc289b4daef8885caa9d20
+CPAN cpan/CPAN/lib/CPAN/LWP/UserAgent.pm c9a184eeefe4388ef2c85ae04496d06219d7cab0
+CPAN cpan/CPAN/lib/CPAN/Mirrors.pm b68181e1e27a88247b5ce5f2a41d999fbeaf9ad0
 Digest::MD5 cpan/Digest-MD5/t/files.t c1417867017210ce3d199eb9d55d8ef61fdf1a83
-Encode cpan/Encode/bin/enc2xs f60036fd3574ec05c9aab7f4db00a828d5dea92d
+Encode cpan/Encode/bin/enc2xs a0685329f5e713b1f3866d90b61e3210fe943d8b
 Encode cpan/Encode/Byte/Makefile.PL 0986e25f981a3bf182a13a0060d28d4efedd87e6
 Encode cpan/Encode/CN/Makefile.PL 5507a49d822d0c1d14e967f4595e29e9c873540b
 Encode cpan/Encode/EBCDIC/Makefile.PL 574289638393eb6b1109eb9a6874bfe8c5d2ddea
-Encode cpan/Encode/Encode.pm fc26f74b44148a4f0c9e8ec2b0a9c20eae96249d
+Encode cpan/Encode/Encode.pm f0961aba6e6917cefd47e2953d8c428d22ebc55e
 Encode cpan/Encode/Encode.xs 9ee24e3915319bdec044535667a39e3dc531fdcf
 Encode cpan/Encode/Encode/Makefile_PL.e2x 4d0420b19cea75c513842329c1906221130bdb6b
 Encode cpan/Encode/JP/Makefile.PL a9ca9c836424cc2ecbefa4933d9da5db54131b98
Index: gnu/usr.bin/perl/utils/c2ph.PL
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/utils/c2ph.PL,v
retrieving revision 1.13
diff -u -p -r1.13 c2ph.PL
--- gnu/usr.bin/perl/utils/c2ph.PL	25 Mar 2013 20:41:00 -0000	1.13
+++ gnu/usr.bin/perl/utils/c2ph.PL	5 Aug 2016 16:34:29 -0000
@@ -280,6 +280,7 @@ Anyway, here it is.  Should run on perl 
 
 $RCSID = '$Id: c2ph,v 1.7 95/10/28 10:41:47 tchrist Exp Locker: tchrist $';
 
+BEGIN { pop @INC if $INC[-1] eq '.' }
 use File::Temp;
 
 ######################################################################
Index: gnu/usr.bin/perl/utils/h2ph.PL
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/utils/h2ph.PL,v
retrieving revision 1.25
diff -u -p -r1.25 h2ph.PL
--- gnu/usr.bin/perl/utils/h2ph.PL	25 Apr 2015 19:26:23 -0000	1.25
+++ gnu/usr.bin/perl/utils/h2ph.PL	5 Aug 2016 16:34:29 -0000
@@ -36,6 +36,8 @@ $Config{startperl}
 
 print OUT <<'!NO!SUBS!';
 
+BEGIN { pop @INC if $INC[-1] eq '.' }
+
 use strict;
 
 use Config;
Index: gnu/usr.bin/perl/utils/h2xs.PL
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/utils/h2xs.PL,v
retrieving revision 1.16
diff -u -p -r1.16 h2xs.PL
--- gnu/usr.bin/perl/utils/h2xs.PL	17 Nov 2014 20:57:08 -0000	1.16
+++ gnu/usr.bin/perl/utils/h2xs.PL	5 Aug 2016 16:34:29 -0000
@@ -35,6 +35,8 @@ $Config{startperl}
 
 print OUT <<'!NO!SUBS!';
 
+BEGIN { pop @INC if $INC[-1] eq '.' }
+
 use warnings;
 
 =head1 NAME
Index: gnu/usr.bin/perl/utils/libnetcfg.PL
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/utils/libnetcfg.PL,v
retrieving revision 1.5
diff -u -p -r1.5 libnetcfg.PL
--- gnu/usr.bin/perl/utils/libnetcfg.PL	24 Mar 2014 15:05:33 -0000	1.5
+++ gnu/usr.bin/perl/utils/libnetcfg.PL	5 Aug 2016 16:34:29 -0000
@@ -97,6 +97,7 @@ Jarkko Hietaniemi, conversion into libne
 
 # $Id: Configure,v 1.8 1997/03/04 09:22:32 gbarr Exp $
 
+BEGIN { pop @INC if $INC[-1] eq '.' }
 use strict;
 use IO::File;
 use Getopt::Std;
Index: gnu/usr.bin/perl/utils/perlbug.PL
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/utils/perlbug.PL,v
retrieving revision 1.19
diff -u -p -r1.19 perlbug.PL
--- gnu/usr.bin/perl/utils/perlbug.PL	25 Apr 2015 19:26:23 -0000	1.19
+++ gnu/usr.bin/perl/utils/perlbug.PL	5 Aug 2016 16:34:29 -0000
@@ -57,6 +57,7 @@ print OUT <<'!NO!SUBS!';
 my @patches = Config::local_patches();
 my $patch_tags = join "", map /(\S+)/ ? "+$1 " : (), @patches;
 
+BEGIN { pop @INC if $INC[-1] eq '.' }
 use warnings;
 use strict;
 use Config;
Index: gnu/usr.bin/perl/utils/perldoc.PL
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/utils/perldoc.PL,v
retrieving revision 1.7
diff -u -p -r1.7 perldoc.PL
--- gnu/usr.bin/perl/utils/perldoc.PL	3 Dec 2003 03:02:50 -0000	1.7
+++ gnu/usr.bin/perl/utils/perldoc.PL	5 Aug 2016 16:34:29 -0000
@@ -44,7 +44,10 @@ $Config{startperl}
 # This "$file" file was generated by "$0"
 
 require 5;
-BEGIN { \$^W = 1 if \$ENV{'PERLDOCDEBUG'} }
+BEGIN {
+    \$^W = 1 if \$ENV{'PERLDOCDEBUG'};
+    pop \@INC if \$INC[-1] eq '.';
+}
 use Pod::Perldoc;
 exit( Pod::Perldoc->run() );
 
Index: gnu/usr.bin/perl/utils/perlivp.PL
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/utils/perlivp.PL,v
retrieving revision 1.1.1.8
diff -u -p -r1.1.1.8 perlivp.PL
--- gnu/usr.bin/perl/utils/perlivp.PL	25 Mar 2013 20:09:40 -0000	1.1.1.8
+++ gnu/usr.bin/perl/utils/perlivp.PL	5 Aug 2016 16:34:29 -0000
@@ -39,6 +39,8 @@ print OUT "\n# perlivp $^V\n";
 
 print OUT <<'!NO!SUBS!';
 
+BEGIN { pop @INC if $INC[-1] eq '.' }
+
 sub usage {
     warn "@_\n" if @_;
     print << "    EOUSAGE";
Index: gnu/usr.bin/perl/utils/splain.PL
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/utils/splain.PL,v
retrieving revision 1.3
diff -u -p -r1.3 splain.PL
--- gnu/usr.bin/perl/utils/splain.PL	27 Oct 2002 22:25:38 -0000	1.3
+++ gnu/usr.bin/perl/utils/splain.PL	5 Aug 2016 16:34:29 -0000
@@ -38,6 +38,12 @@ $Config{startperl}
 	if \$running_under_some_shell;
 !GROK!THIS!
 
+print <<'!NO!SUBS!';
+
+BEGIN { pop @INC if $INC[-1] eq '.' }
+
+!NO!SUBS!
+
 while (<IN>) {
     print OUT unless /^package diagnostics/;
 }
Index: gnu/usr.bin/perl/x2p/find2perl.PL
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/x2p/find2perl.PL,v
retrieving revision 1.14
diff -u -p -r1.14 find2perl.PL
--- gnu/usr.bin/perl/x2p/find2perl.PL	17 Nov 2014 20:57:08 -0000	1.14
+++ gnu/usr.bin/perl/x2p/find2perl.PL	5 Aug 2016 16:34:29 -0000
@@ -1,5 +1,6 @@
 #!/usr/local/bin/perl
 
+BEGIN { pop @INC if $INC[-1] eq '.' }
 use Config;
 use File::Basename qw(&basename &dirname);
 use Cwd;
Index: gnu/usr.bin/perl/x2p/s2p.PL
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/x2p/s2p.PL,v
retrieving revision 1.10
diff -u -p -r1.10 s2p.PL
--- gnu/usr.bin/perl/x2p/s2p.PL	25 Mar 2013 20:41:01 -0000	1.10
+++ gnu/usr.bin/perl/x2p/s2p.PL	5 Aug 2016 16:34:29 -0000
@@ -1,5 +1,6 @@
 #!/usr/bin/perl
 
+BEGIN { pop @INC if $INC[-1] eq '.' }
 use Config;
 use File::Basename qw(&basename &dirname);
 use Cwd;
