untrusted comment: signature from openbsd 5.8 base secret key
RWQNNZXtC/MqP4VG0J8sxlI5EmccbpzyhSN/3N9gzvfZDMhLbyifraBvvCho7eZ6xtG2oZ3i0RptJO4jTk/i+3GuPBg3zDAx5gU=

OpenBSD 5.8 errata 14, May 17, 2016:

Insufficient checks in the uvideo(4) V4L2 ioctl handling leak kernel
memory contents to a local user.

Apply by doing:
    signify -Vep /etc/signify/openbsd-58-base.pub -x 014_uvideo.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/dev/usb/uvideo.c
===================================================================
RCS file: /cvs/src/sys/dev/usb/uvideo.c,v
retrieving revision 1.181
diff -u -p -r1.181 uvideo.c
--- sys/dev/usb/uvideo.c	9 Jul 2015 14:58:32 -0000	1.181
+++ sys/dev/usb/uvideo.c	17 May 2016 13:03:20 -0000
@@ -31,6 +31,7 @@
 #include <sys/poll.h>
 #include <sys/timeout.h>
 #include <sys/kthread.h>
+#include <sys/stdint.h>
 
 #include <uvm/uvm_extern.h>
 
@@ -74,6 +75,7 @@ struct uvideo_softc {
 
 	struct uvideo_mmap			 sc_mmap[UVIDEO_MAX_BUFFERS];
 	uint8_t					*sc_mmap_buffer;
+	size_t					 sc_mmap_buffer_size;
 	q_mmap					 sc_mmap_q;
 	int					 sc_mmap_count;
 	int					 sc_mmap_cur;
@@ -1686,8 +1688,9 @@ uvideo_vs_free_frame(struct uvideo_softc
 	}
 
 	if (sc->sc_mmap_buffer != NULL) {
-		free(sc->sc_mmap_buffer, M_DEVBUF, 0);
+		free(sc->sc_mmap_buffer, M_DEVBUF, sc->sc_mmap_buffer_size);
 		sc->sc_mmap_buffer = NULL;
+		sc->sc_mmap_buffer_size = 0;
 	}
 
 	while (!SIMPLEQ_EMPTY(&sc->sc_mmap_q))
@@ -3172,13 +3175,20 @@ uvideo_reqbufs(void *v, struct v4l2_requ
 
 	/* allocate the total mmap buffer */	
 	buf_size = UGETDW(sc->sc_desc_probe.dwMaxVideoFrameSize);
+	if (buf_size >= SIZE_MAX / UVIDEO_MAX_BUFFERS) {
+		printf("%s: video frame size too large!\n", DEVNAME(sc));
+		sc->sc_mmap_count = 0;
+		return (EINVAL);
+	}
 	buf_size_total = sc->sc_mmap_count * buf_size;
 	buf_size_total = round_page(buf_size_total); /* page align buffer */
 	sc->sc_mmap_buffer = malloc(buf_size_total, M_DEVBUF, M_NOWAIT);
 	if (sc->sc_mmap_buffer == NULL) {
 		printf("%s: can't allocate mmap buffer!\n", DEVNAME(sc));
+		sc->sc_mmap_count = 0;
 		return (EINVAL);
 	}
+	sc->sc_mmap_buffer_size = buf_size_total;
 	DPRINTF(1, "%s: allocated %d bytes mmap buffer\n",
 	    DEVNAME(sc), buf_size_total);
 
@@ -3217,7 +3227,8 @@ uvideo_querybuf(void *v, struct v4l2_buf
 	struct uvideo_softc *sc = v;
 
 	if (qb->type != V4L2_BUF_TYPE_VIDEO_CAPTURE ||
-	    qb->memory != V4L2_MEMORY_MMAP)
+	    qb->memory != V4L2_MEMORY_MMAP ||
+	    qb->index >= sc->sc_mmap_count)
 		return (EINVAL);
 
 	bcopy(&sc->sc_mmap[qb->index].v4l2_buf, qb,
@@ -3237,6 +3248,11 @@ uvideo_qbuf(void *v, struct v4l2_buffer 
 {
 	struct uvideo_softc *sc = v;
 
+	if (qb->type != V4L2_BUF_TYPE_VIDEO_CAPTURE ||
+	    qb->memory != V4L2_MEMORY_MMAP ||
+	    qb->index >= sc->sc_mmap_count)
+		return (EINVAL);
+
 	sc->sc_mmap[qb->index].v4l2_buf.flags &= ~V4L2_BUF_FLAG_DONE;
 	sc->sc_mmap[qb->index].v4l2_buf.flags |= V4L2_BUF_FLAG_MAPPED;
 	sc->sc_mmap[qb->index].v4l2_buf.flags |= V4L2_BUF_FLAG_QUEUED;
@@ -3254,6 +3270,10 @@ uvideo_dqbuf(void *v, struct v4l2_buffer
 	struct uvideo_mmap *mmap;
 	int error;
 
+	if (dqb->type != V4L2_BUF_TYPE_VIDEO_CAPTURE ||
+	    dqb->memory != V4L2_MEMORY_MMAP)
+		return (EINVAL);
+
 	if (SIMPLEQ_EMPTY(&sc->sc_mmap_q)) {
 		/* mmap queue is empty, block until first frame is queued */
 		error = tsleep(sc, 0, "vid_mmap", 10 * hz);
@@ -3570,6 +3590,9 @@ uvideo_mappage(void *v, off_t off, int p
 {
 	struct uvideo_softc *sc = v;
 	caddr_t p;
+
+	if (off >= sc->sc_mmap_buffer_size)
+		return NULL;
 
 	if (!sc->sc_mmap_flag)
 		sc->sc_mmap_flag = 1;
