/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyEditor;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.CellRendererPane;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;

class ButtonPanel
extends JComponent
implements InplaceEditor {
    public static final Object editorActionKey = "openCustomEditor";
    private final boolean log = PropUtils.isLoggable(ButtonPanel.class);
    JComponent comp = null;
    private ConditionallyFocusableButton button;
    boolean needLayout = true;
    private InplaceEditor inplace = null;
    boolean clearing = false;

    public ButtonPanel() {
        this.createButton();
        this.setOpaque(true);
    }

    private void createButton() {
        this.button = new ConditionallyFocusableButton();
        int n = PropUtils.getCustomButtonWidth();
        this.button.setBounds(this.getWidth() - n, 0, n, this.getHeight());
        this.button.setIcon(PropUtils.getCustomButtonIcon());
        this.button.setRolloverIcon(PropUtils.getCustomButtonIcon());
        this.button.setMargin(null);
        this.button.setName("Custom editor button - editor instance");
        this.button.setText(null);
        this.button.putClientProperty("hideActionText", Boolean.TRUE);
        this.add(this.button);
    }

    void setButtonAction(Action action) {
        this.button.setAction(action);
        this.button.setIcon(PropUtils.getCustomButtonIcon());
        this.button.setRolloverIcon(PropUtils.getCustomButtonIcon());
    }

    public void setOpaque(boolean bl) {
        if (this.getInplaceEditor() != null) {
            this.getInplaceEditor().getComponent().setOpaque(true);
        }
    }

    public void setFont(Font font) {
        if (this.comp != null) {
            this.comp.setFont(font);
        }
        super.setFont(font);
    }

    public InplaceEditor getInplaceEditor() {
        return this.inplace;
    }

    public void setCustomButtonBackground(Color color) {
        this.button.setBackground(color);
    }

    public void setRolloverPoint(Point point) {
        if (point != null) {
            if (point.x < this.getWidth() - PropUtils.getCustomButtonWidth()) {
                this.button.getModel().setRollover(false);
                if (this.comp instanceof AbstractButton) {
                    ((AbstractButton)this.comp).getModel().setRollover(true);
                }
            } else {
                this.button.getModel().setRollover(true);
                if (this.comp instanceof AbstractButton) {
                    ((AbstractButton)this.comp).getModel().setRollover(false);
                }
            }
        } else {
            this.button.getModel().setRollover(false);
            if (this.comp instanceof AbstractButton) {
                ((AbstractButton)this.comp).getModel().setRollover(false);
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension;
        if (this.comp != null) {
            dimension = new Dimension(this.comp.getPreferredSize());
            dimension.width += this.button.getWidth();
            dimension.height = Math.max(dimension.height, this.button.getPreferredSize().height);
        } else {
            dimension = new Dimension(this.button.getPreferredSize());
        }
        return dimension;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.comp != null) {
            this.comp.setEnabled(bl);
        }
        this.button.setEnabled(true);
    }

    private void setComponent(JComponent jComponent) {
        if (jComponent == this.comp) {
            return;
        }
        if (this.comp != null && this.comp.getParent() == this) {
            this.remove(this.comp);
        }
        if (this.log) {
            PropUtils.log(ButtonPanel.class, "Button panel setComponent to " + jComponent);
        }
        this.comp = jComponent;
        if (this.comp != null) {
            this.comp.setBackground(this.getBackground());
            this.comp.setForeground(this.getForeground());
            if (this.comp.isEnabled() != this.isEnabled()) {
                this.comp.setEnabled(this.isEnabled());
            }
            this.add(this.comp);
        }
        this.needLayout = true;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.comp != null) {
            this.comp.setBackground(color);
            Color color2 = PropUtils.getButtonColor();
            if (color2 == null) {
                this.button.setBackground(color);
            } else {
                this.button.setBackground(color2);
            }
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.comp != null) {
            this.comp.setForeground(color);
            if (PropUtils.getButtonColor() == null) {
                this.button.setForeground(color);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        if (this.isShowing()) {
            super.paint(graphics);
            return;
        }
        if (this.needLayout) {
            this.doLayout();
        }
        int n = this.getWidth();
        Graphics graphics2 = graphics.create(0, 0, n - this.button.getWidth(), this.getHeight());
        try {
            if (this.comp instanceof InplaceEditor) {
                this.comp.paint(graphics2);
                if (this.comp.getParent() != this) {
                    this.add(this.comp);
                }
            }
        }
        finally {
            graphics2.dispose();
        }
        graphics2 = graphics.create(n - this.button.getWidth(), 0, this.button.getWidth(), this.getHeight());
        try {
            this.button.paint(graphics2);
        }
        finally {
            graphics2.dispose();
        }
        if (this.getParent() instanceof CellRendererPane) {
            RepaintManager.currentManager(this).markCompletelyClean(this);
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.needLayout = true;
    }

    public void requestFocus() {
        if (this.comp != null) {
            this.comp.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        if (this.comp != null) {
            return this.comp.requestFocusInWindow();
        }
        return false;
    }

    public void addFocusListener(FocusListener focusListener) {
        if (this.comp != null) {
            this.button.addFocusListener(focusListener);
            this.comp.addFocusListener(focusListener);
        }
    }

    public void removeFocusListener(FocusListener focusListener) {
        if (this.comp != null) {
            this.button.removeFocusListener(focusListener);
            this.comp.removeFocusListener(focusListener);
        }
    }

    public void setInplaceEditor(InplaceEditor inplaceEditor) {
        if (this.inplace == inplaceEditor && this.isAncestorOf(this.inplace.getComponent())) {
            return;
        }
        if (this.inplace != null) {
            this.setComponent(null);
        }
        this.inplace = inplaceEditor;
        this.setComponent(this.inplace.getComponent());
        this.needLayout = true;
    }

    public void addActionListener(ActionListener actionListener) {
        this.inplace.addActionListener(actionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.clearing = true;
        try {
            this.inplace.clear();
            this.inplace = null;
            this.setComponent(null);
        }
        finally {
            this.clearing = false;
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public void connect(PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
        this.inplace.connect(propertyEditor, propertyEnv);
    }

    public KeyStroke[] getKeyStrokes() {
        return this.inplace.getKeyStrokes();
    }

    public PropertyEditor getPropertyEditor() {
        return this.inplace.getPropertyEditor();
    }

    public PropertyModel getPropertyModel() {
        return this.inplace.getPropertyModel();
    }

    public Object getValue() {
        return this.inplace.getValue();
    }

    public boolean isKnownComponent(Component component) {
        return component == this || this.inplace.isKnownComponent(component);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.inplace.removeActionListener(actionListener);
    }

    public void reset() {
        this.inplace.reset();
    }

    public void setPropertyModel(PropertyModel propertyModel) {
        this.inplace.setPropertyModel(propertyModel);
    }

    public void setValue(Object object) {
        this.inplace.setValue(object);
    }

    public boolean supportsTextEntry() {
        return this.inplace.supportsTextEntry();
    }

    public void doLayout() {
        if (this.comp != null) {
            this.comp.setBounds(0, 0, this.getWidth() - PropUtils.getCustomButtonWidth(), this.getHeight());
            this.comp.doLayout();
        }
        this.button.setBounds(this.getWidth() - PropUtils.getCustomButtonWidth(), 0, PropUtils.getCustomButtonWidth(), this.getHeight());
        if (this.log) {
            PropUtils.log(ButtonPanel.class, "Laying out button panel.  Bounds are " + this.getBounds() + ", custom editor button bounds: " + this.button.getBounds() + " comp is " + this.comp);
        }
        this.needLayout = false;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private class ConditionallyFocusableButton
    extends JButton {
        private AffineTransform at = AffineTransform.getTranslateInstance(0.0, 0.0);
        private BufferedImage snapshot = null;

        public boolean isFocusable() {
            return ButtonPanel.this.getParent() != null && !ButtonPanel.this.clearing;
        }

        public void paint(Graphics graphics) {
            if (PropUtils.useOptimizedCustomButtonPainting() && !this.hasFocus()) {
                if (ButtonPanel.this.log) {
                    PropUtils.log(ButtonPanel.class, "Blitting custom editor button backing store for button at " + this.getBounds() + " in " + (this.getParent() == null ? " null parent" : this.getParent() + "editor=" + ButtonPanel.this.inplace));
                }
                ((Graphics2D)graphics).drawRenderedImage(this.getSnapshot(), this.at);
            } else {
                if (ButtonPanel.this.log) {
                    PropUtils.log(ButtonPanel.class, "Painting unoptimized custom editor button button at " + this.getBounds() + " in " + (this.getParent() == null ? " null parent" : this.getParent() + "editor=" + ButtonPanel.this.inplace));
                }
                super.paint(graphics);
            }
        }

        public BufferedImage getSnapshot() {
            if (this.snapshot == null) {
                this.snapshot = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.getWidth(), this.getHeight());
                if (ButtonPanel.this.log) {
                    PropUtils.log(ButtonPanel.class, "Created " + this.snapshot + " custom editor button backing image");
                }
                if (this.snapshot.getAlphaRaster() == null) {
                    this.snapshot = new BufferedImage(this.getWidth(), this.getHeight(), 2);
                }
                Graphics graphics = this.snapshot.getGraphics();
                super.paint(graphics);
            }
            return this.snapshot;
        }
    }
}

