/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.nativeaccess.transparency;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.awt.peer.ComponentPeer;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.netbeans.core.nativeaccess.transparency.RasterRangesUtils;
import org.netbeans.core.nativeaccess.transparency.unix.X11;
import org.netbeans.core.nativeaccess.transparency.win32.GDI32;
import org.netbeans.core.nativeaccess.transparency.win32.User32;
import org.netbeans.core.nativeaccess.transparency.win32.W32API;

public class WindowUtils {
    private static final String TRANSPARENT_OLD_BG = "transparent-old-bg";
    private static final String TRANSPARENT_OLD_OPAQUE = "transparent-old-opaque";
    private static final String TRANSPARENT_ALPHA = "transparent-alpha";
    public static final Shape MASK_NONE = null;

    private static NativeWindowUtils getInstance() {
        return Holder.INSTANCE;
    }

    public static void setWindowMask(Window window, Shape shape) {
        WindowUtils.getInstance().setWindowMask((Component)window, shape);
    }

    public static void setComponentMask(Component component, Shape shape) {
        WindowUtils.getInstance().setWindowMask(component, shape);
    }

    public static void setWindowMask(Window window, Icon icon) {
        WindowUtils.getInstance().setWindowMask((Component)window, icon);
    }

    public static boolean isWindowAlphaSupported() {
        return WindowUtils.getInstance().isWindowAlphaSupported();
    }

    public static GraphicsConfiguration getAlphaCompatibleGraphicsConfiguration() {
        return WindowUtils.getInstance().getAlphaCompatibleGraphicsConfiguration();
    }

    public static void setWindowAlpha(Window window, float f) {
        WindowUtils.getInstance().setWindowAlpha(window, Math.max(0.0f, Math.min(f, 1.0f)));
    }

    public static void setWindowTransparent(Window window, boolean bl) {
        WindowUtils.getInstance().setWindowTransparent(window, bl);
    }

    private static class X11WindowUtils
    extends NativeWindowUtils {
        private boolean didCheck;
        private long[] alphaVisualIDs = new long[0];
        private static final long OPAQUE = 0xFFFFFFFFL;
        private static final String OPACITY = "_NET_WM_WINDOW_OPACITY";

        private X11WindowUtils() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private X11.Pixmap createBitmap(final X11.Display display, X11.Window window, Raster raster) {
            final X11 x11 = X11.INSTANCE;
            Rectangle rectangle = raster.getBounds();
            int n = rectangle.x + rectangle.width;
            int n2 = rectangle.y + rectangle.height;
            final X11.Pixmap pixmap = x11.XCreatePixmap(display, window, n, n2, 1);
            final X11.GC gC = x11.XCreateGC(display, pixmap, new NativeLong(0L), null);
            if (gC == null) {
                return null;
            }
            x11.XSetForeground(display, gC, new NativeLong(0L));
            x11.XFillRectangle(display, pixmap, gC, 0, 0, n, n2);
            x11.XSetForeground(display, gC, new NativeLong(1L));
            X11.XWindowAttributes xWindowAttributes = new X11.XWindowAttributes();
            int n3 = x11.XGetWindowAttributes(display, window, xWindowAttributes);
            if (n3 == 0) {
                return null;
            }
            try {
                RasterRangesUtils.outputOccupiedRanges(raster, new RasterRangesUtils.RangesOutput(){

                    public boolean outputRange(int n, int n2, int n3, int n4) {
                        return x11.XFillRectangle(display, pixmap, gC, n, n2, n3, n4) != 0;
                    }
                });
            }
            finally {
                x11.XFreeGC(display, gC);
            }
            return pixmap;
        }

        public boolean isWindowAlphaSupported() {
            return this.getAlphaVisualIDs().length > 0;
        }

        private long getVisualID(GraphicsConfiguration graphicsConfiguration) {
            try {
                Object object = graphicsConfiguration.getClass().getMethod("getVisual", null).invoke((Object)graphicsConfiguration, (Object[])null);
                return ((Number)object).longValue();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return -1L;
            }
        }

        public GraphicsConfiguration getAlphaCompatibleGraphicsConfiguration() {
            if (this.isWindowAlphaSupported()) {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
                for (int i = 0; i < graphicsDeviceArray.length; ++i) {
                    GraphicsConfiguration[] graphicsConfigurationArray = graphicsDeviceArray[i].getConfigurations();
                    for (int j = 0; j < graphicsConfigurationArray.length; ++j) {
                        long l = this.getVisualID(graphicsConfigurationArray[j]);
                        long[] lArray = this.getAlphaVisualIDs();
                        for (int k = 0; k < lArray.length; ++k) {
                            if (l != lArray[k]) continue;
                            return graphicsConfigurationArray[j];
                        }
                    }
                }
            }
            return super.getAlphaCompatibleGraphicsConfiguration();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized long[] getAlphaVisualIDs() {
            if (this.didCheck) {
                return this.alphaVisualIDs;
            }
            this.didCheck = true;
            X11 x11 = X11.INSTANCE;
            X11.Display display = x11.XOpenDisplay(null);
            if (display == null) {
                return this.alphaVisualIDs;
            }
            X11.XVisualInfo xVisualInfo = null;
            try {
                int n = x11.XDefaultScreen(display);
                X11.XVisualInfo xVisualInfo2 = new X11.XVisualInfo();
                xVisualInfo2.screen = n;
                xVisualInfo2.depth = 32;
                xVisualInfo2.c_class = 4;
                NativeLong nativeLong = new NativeLong(14L);
                IntByReference intByReference = new IntByReference();
                xVisualInfo = x11.XGetVisualInfo(display, nativeLong, xVisualInfo2, intByReference);
                if (xVisualInfo != null) {
                    int n2;
                    ArrayList<X11.VisualID> arrayList = new ArrayList<X11.VisualID>();
                    X11.XVisualInfo[] xVisualInfoArray = (X11.XVisualInfo[])xVisualInfo.toArray(intByReference.getValue());
                    for (n2 = 0; n2 < xVisualInfoArray.length; ++n2) {
                        X11.Xrender.XRenderPictFormat xRenderPictFormat = X11.Xrender.INSTANCE.XRenderFindVisualFormat(display, xVisualInfoArray[n2].visual);
                        if (xRenderPictFormat.type != 1 || xRenderPictFormat.direct.alphaMask == 0) continue;
                        arrayList.add(xVisualInfoArray[n2].visualid);
                    }
                    this.alphaVisualIDs = new long[arrayList.size()];
                    for (n2 = 0; n2 < this.alphaVisualIDs.length; ++n2) {
                        this.alphaVisualIDs[n2] = ((Number)arrayList.get(n2)).longValue();
                    }
                    long[] lArray = this.alphaVisualIDs;
                    return lArray;
                }
            }
            finally {
                if (xVisualInfo != null) {
                    x11.XFree(xVisualInfo.getPointer());
                }
                x11.XCloseDisplay(display);
            }
            return this.alphaVisualIDs;
        }

        private X11.Window getContentWindow(Window window, X11.Display display, X11.Window window2, Point point) {
            if (window instanceof Frame && !((Frame)window).isUndecorated() || window instanceof Dialog && !((Dialog)window).isUndecorated()) {
                X11 x11 = X11.INSTANCE;
                X11.WindowByReference windowByReference = new X11.WindowByReference();
                X11.WindowByReference windowByReference2 = new X11.WindowByReference();
                PointerByReference pointerByReference = new PointerByReference();
                IntByReference intByReference = new IntByReference();
                x11.XQueryTree(display, window2, windowByReference, windowByReference2, pointerByReference, intByReference);
                Pointer pointer = pointerByReference.getValue();
                int[] nArray = pointer.getIntArray(0L, intByReference.getValue());
                int n = 0;
                if (n < nArray.length) {
                    X11.Window window3 = new X11.Window(nArray[n]);
                    X11.XWindowAttributes xWindowAttributes = new X11.XWindowAttributes();
                    x11.XGetWindowAttributes(display, window3, xWindowAttributes);
                    point.x = -xWindowAttributes.x;
                    point.y = -xWindowAttributes.y;
                    window2 = window3;
                }
                if (pointer != null) {
                    x11.XFree(pointer);
                }
            }
            return window2;
        }

        private X11.Window getDrawable(Component component) {
            int n = (int)Native.getComponentID((Component)component);
            if (n == 0) {
                return null;
            }
            return new X11.Window(n);
        }

        public void setWindowAlpha(final Window window, final float f) {
            if (!this.isWindowAlphaSupported()) {
                throw new UnsupportedOperationException("This X11 display does not provide a 32-bit visual");
            }
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    X11 x11 = X11.INSTANCE;
                    X11.Display display = x11.XOpenDisplay(null);
                    if (display == null) {
                        return;
                    }
                    try {
                        X11.Window window2 = X11WindowUtils.this.getDrawable(window);
                        if (f == 1.0f) {
                            x11.XDeleteProperty(display, window2, x11.XInternAtom(display, X11WindowUtils.OPACITY, false));
                        } else {
                            int n = (int)((long)(f * 4.2949673E9f) & 0xFFFFFFFFFFFFFFFFL);
                            IntByReference intByReference = new IntByReference(n);
                            x11.XChangeProperty(display, window2, x11.XInternAtom(display, X11WindowUtils.OPACITY, false), X11.XA_CARDINAL, 32, 0, intByReference.getPointer(), 1);
                        }
                    }
                    finally {
                        x11.XCloseDisplay(display);
                    }
                }
            };
            this.whenDisplayable(window, runnable);
        }

        public void setWindowTransparent(final Window window, final boolean bl) {
            boolean bl2;
            if (!(window instanceof RootPaneContainer)) {
                throw new IllegalArgumentException("Window must be a RootPaneContainer");
            }
            if (!this.isWindowAlphaSupported()) {
                throw new UnsupportedOperationException("This X11 display does not provide a 32-bit visual");
            }
            if (!window.getGraphicsConfiguration().equals(this.getAlphaCompatibleGraphicsConfiguration())) {
                throw new IllegalArgumentException("Window GraphicsConfiguration '" + window.getGraphicsConfiguration() + "' does not support transparency");
            }
            boolean bl3 = bl2 = window.getBackground() != null && window.getBackground().getAlpha() == 0;
            if (bl == bl2) {
                return;
            }
            this.whenDisplayable(window, new Runnable(){

                public void run() {
                    JRootPane jRootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                    JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
                    Container container = jRootPane.getContentPane();
                    if (container instanceof X11TransparentContent) {
                        ((X11TransparentContent)container).setTransparent(bl);
                    } else if (bl) {
                        X11TransparentContent x11TransparentContent = new X11TransparentContent(container);
                        jRootPane.setContentPane(x11TransparentContent);
                        jLayeredPane.add((Component)new RepaintTrigger(x11TransparentContent), JLayeredPane.DRAG_LAYER);
                    }
                    X11WindowUtils.this.setLayersTransparent(window, bl);
                    X11WindowUtils.this.setForceHeavyweightPopups(window, bl);
                    X11WindowUtils.this.setDoubleBuffered(window, !bl);
                }
            });
        }

        protected void setMask(final Component component, final Raster raster) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    X11.Display display;
                    X11 x11;
                    block6: {
                        x11 = X11.INSTANCE;
                        X11.Xext xext = X11.Xext.INSTANCE;
                        display = x11.XOpenDisplay(null);
                        if (display == null) {
                            return;
                        }
                        X11.Pixmap pixmap = null;
                        try {
                            X11.Window window = X11WindowUtils.this.getDrawable(component);
                            if (raster == null || (pixmap = X11WindowUtils.this.createBitmap(display, window, raster)) == null) {
                                xext.XShapeCombineMask(display, window, 0, 0, 0, X11.Pixmap.None, 0);
                            } else {
                                xext.XShapeCombineMask(display, window, 0, 0, 0, pixmap, 0);
                            }
                            if (pixmap == null) break block6;
                            x11.XFreePixmap(display, pixmap);
                        }
                        catch (Throwable throwable) {
                            if (pixmap != null) {
                                x11.XFreePixmap(display, pixmap);
                            }
                            x11.XCloseDisplay(display);
                            throw throwable;
                        }
                    }
                    x11.XCloseDisplay(display);
                    X11WindowUtils.this.setForceHeavyweightPopups(X11WindowUtils.this.getWindow(component), raster != null);
                }
            };
            this.whenDisplayable(component, runnable);
        }

        private class X11TransparentContent
        extends NativeWindowUtils.TransparentContent {
            private Memory buffer;
            private int[] pixels;
            private int[] pixel;

            public X11TransparentContent(Container container) {
                super(container);
                this.pixel = new int[4];
            }

            protected void paintDirect(BufferedImage bufferedImage, Rectangle rectangle) {
                Window window = SwingUtilities.getWindowAncestor(this);
                X11 x11 = X11.INSTANCE;
                X11.Display display = x11.XOpenDisplay(null);
                X11.Window window2 = X11WindowUtils.this.getDrawable(window);
                Point point = new Point();
                window2 = X11WindowUtils.this.getContentWindow(window, display, window2, point);
                X11.GC gC = x11.XCreateGC(display, window2, new NativeLong(0L), null);
                Raster raster = bufferedImage.getData();
                int n = rectangle.width;
                int n2 = rectangle.height;
                if (this.buffer == null || this.buffer.getSize() != (long)(n * n2 * 4)) {
                    this.buffer = new Memory((long)(n * n2 * 4));
                    this.pixels = new int[n * n2];
                }
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        raster.getPixel(j, i, this.pixel);
                        int n3 = this.pixel[3] & 0xFF;
                        int n4 = this.pixel[2] & 0xFF;
                        int n5 = this.pixel[1] & 0xFF;
                        int n6 = this.pixel[0] & 0xFF;
                        this.pixels[i * n + j] = n3 << 24 | n6 << 16 | n5 << 8 | n4;
                    }
                }
                X11.XWindowAttributes xWindowAttributes = new X11.XWindowAttributes();
                x11.XGetWindowAttributes(display, window2, xWindowAttributes);
                X11.XImage xImage = x11.XCreateImage(display, xWindowAttributes.visual, 32, 2, 0, (Pointer)this.buffer, n, n2, 32, n * 4);
                this.buffer.write(0L, this.pixels, 0, this.pixels.length);
                point.x += rectangle.x;
                point.y += rectangle.y;
                x11.XPutImage(display, window2, gC, xImage, 0, 0, point.x, point.y, n, n2);
                x11.XFree(xImage.getPointer());
                x11.XFreeGC(display, gC);
                x11.XCloseDisplay(display);
            }
        }
    }

    private static class MacWindowUtils
    extends NativeWindowUtils {
        private MacWindowUtils() {
        }

        public boolean isWindowAlphaSupported() {
            return true;
        }

        private OSXTransparentContent installTransparentContent(Window window) {
            OSXTransparentContent oSXTransparentContent;
            if (window instanceof RootPaneContainer) {
                RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)window);
                Container container = rootPaneContainer.getContentPane();
                if (container instanceof OSXTransparentContent) {
                    oSXTransparentContent = (OSXTransparentContent)container;
                } else {
                    oSXTransparentContent = new OSXTransparentContent(container);
                    rootPaneContainer.setContentPane(oSXTransparentContent);
                }
            } else {
                Component component;
                Component component2 = component = window.getComponentCount() > 0 ? window.getComponent(0) : null;
                if (component instanceof OSXTransparentContent) {
                    oSXTransparentContent = (OSXTransparentContent)component;
                } else {
                    oSXTransparentContent = new OSXTransparentContent(component);
                    window.add(oSXTransparentContent);
                }
            }
            return oSXTransparentContent;
        }

        public void setWindowTransparent(Window window, boolean bl) {
            boolean bl2;
            boolean bl3 = bl2 = window.getBackground() != null && window.getBackground().getAlpha() == 0;
            if (bl != bl2) {
                this.installTransparentContent(window);
                this.setBackgroundTransparent(window, bl);
                this.setLayersTransparent(window, bl);
            }
        }

        public void setWindowAlpha(final Window window, final float f) {
            this.whenDisplayable(window, new Runnable(){

                public void run() {
                    block2: {
                        ComponentPeer componentPeer = window.getPeer();
                        try {
                            componentPeer.getClass().getMethod("setAlpha", Float.TYPE).invoke((Object)componentPeer, new Float(f));
                        }
                        catch (Exception exception) {
                            if (!(window instanceof RootPaneContainer)) break block2;
                            JRootPane jRootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                            jRootPane.putClientProperty("Window.alpha", new Float(f));
                        }
                    }
                }
            });
        }

        protected void setWindowMask(Component component, Raster raster) {
            if (raster != null) {
                this.setWindowMask(component, this.toShape(raster));
            } else {
                this.setWindowMask(component, new Rectangle(0, 0, component.getWidth(), component.getHeight()));
            }
        }

        public void setWindowMask(Component component, Shape shape) {
            if (component instanceof Window) {
                Window window = (Window)component;
                OSXTransparentContent oSXTransparentContent = this.installTransparentContent(window);
                oSXTransparentContent.setMask(shape);
                this.setBackgroundTransparent(window, shape != MASK_NONE);
            }
        }

        private void setBackgroundTransparent(Window window, boolean bl) {
            if (bl) {
                window.setBackground(new Color(0, 0, 0, 0));
            } else {
                window.setBackground(null);
            }
        }

        private static class OSXTransparentContent
        extends JPanel {
            private Shape shape;

            public OSXTransparentContent(Component component) {
                super(new BorderLayout());
                if (component != null) {
                    this.add(component, "Center");
                }
            }

            public void setMask(Shape shape) {
                this.shape = shape;
                this.repaint();
            }

            public void paint(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setComposite(AlphaComposite.Clear);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics2D.dispose();
                if (this.shape != null) {
                    graphics2D = (Graphics2D)graphics.create();
                    graphics2D.setClip(this.shape);
                    super.paint(graphics2D);
                    graphics2D.dispose();
                } else {
                    super.paint(graphics);
                }
            }
        }
    }

    private static class W32WindowUtils
    extends NativeWindowUtils {
        private W32WindowUtils() {
        }

        private W32API.HWND getHWnd(Component component) {
            W32API.HWND hWND = new W32API.HWND();
            hWND.setPointer(Native.getComponentPointer((Component)component));
            return hWND;
        }

        public boolean isWindowAlphaSupported() {
            return Boolean.getBoolean("sun.java2d.noddraw");
        }

        private boolean usingUpdateLayeredWindow(Window window) {
            if (window instanceof RootPaneContainer) {
                JRootPane jRootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                return jRootPane.getClientProperty(WindowUtils.TRANSPARENT_OLD_BG) != null;
            }
            return false;
        }

        private void storeAlpha(Window window, byte by) {
            if (window instanceof RootPaneContainer) {
                JRootPane jRootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                Byte by2 = by == -1 ? null : new Byte(by);
                jRootPane.putClientProperty(WindowUtils.TRANSPARENT_ALPHA, by2);
            }
        }

        private byte getAlpha(Window window) {
            JRootPane jRootPane;
            Byte by;
            if (window instanceof RootPaneContainer && (by = (Byte)(jRootPane = ((RootPaneContainer)((Object)window)).getRootPane()).getClientProperty(WindowUtils.TRANSPARENT_ALPHA)) != null) {
                return by;
            }
            return -1;
        }

        public void setWindowAlpha(final Window window, final float f) {
            if (!this.isWindowAlphaSupported()) {
                throw new UnsupportedOperationException("Set sun.java2d.noddraw=true to enable transparent windows");
            }
            this.whenDisplayable(window, new Runnable(){

                public void run() {
                    W32API.HWND hWND = W32WindowUtils.this.getHWnd(window);
                    User32 user32 = User32.INSTANCE;
                    int n = user32.GetWindowLong(hWND, -20);
                    byte by = (byte)((int)(255.0f * f) & 0xFF);
                    if (W32WindowUtils.this.usingUpdateLayeredWindow(window)) {
                        User32.BLENDFUNCTION bLENDFUNCTION = new User32.BLENDFUNCTION();
                        bLENDFUNCTION.SourceConstantAlpha = by;
                        bLENDFUNCTION.AlphaFormat = 1;
                        user32.UpdateLayeredWindow(hWND, null, null, null, null, null, 0, bLENDFUNCTION, 2);
                    } else if (f == 1.0f) {
                        user32.SetWindowLong(hWND, -20, n &= 0xFFF7FFFF);
                    } else {
                        user32.SetWindowLong(hWND, -20, n |= 0x80000);
                        user32.SetLayeredWindowAttributes(hWND, 0, by, 2);
                    }
                    W32WindowUtils.this.setForceHeavyweightPopups(window, f != 1.0f);
                    W32WindowUtils.this.storeAlpha(window, by);
                }
            });
        }

        public void setWindowTransparent(final Window window, final boolean bl) {
            boolean bl2;
            if (!(window instanceof RootPaneContainer)) {
                throw new IllegalArgumentException("Window must be a RootPaneContainer");
            }
            if (!this.isWindowAlphaSupported()) {
                throw new UnsupportedOperationException("Set sun.java2d.noddraw=true to enable transparent windows");
            }
            boolean bl3 = bl2 = window.getBackground() != null && window.getBackground().getAlpha() == 0;
            if (bl == bl2) {
                return;
            }
            this.whenDisplayable(window, new Runnable(){

                public void run() {
                    User32 user32 = User32.INSTANCE;
                    W32API.HWND hWND = W32WindowUtils.this.getHWnd(window);
                    int n = user32.GetWindowLong(hWND, -20);
                    JRootPane jRootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                    JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
                    Container container = jRootPane.getContentPane();
                    if (container instanceof W32TransparentContent) {
                        ((W32TransparentContent)container).setTransparent(bl);
                    } else if (bl) {
                        W32TransparentContent w32TransparentContent = new W32TransparentContent(container);
                        jRootPane.setContentPane(w32TransparentContent);
                        jLayeredPane.add((Component)new RepaintTrigger(w32TransparentContent), JLayeredPane.DRAG_LAYER);
                    }
                    if (bl && !W32WindowUtils.this.usingUpdateLayeredWindow(window)) {
                        user32.SetWindowLong(hWND, -20, n |= 0x80000);
                    } else if (!bl && W32WindowUtils.this.usingUpdateLayeredWindow(window)) {
                        user32.SetWindowLong(hWND, -20, n &= 0xFFF7FFFF);
                    }
                    W32WindowUtils.this.setLayersTransparent(window, bl);
                    W32WindowUtils.this.setForceHeavyweightPopups(window, bl);
                    W32WindowUtils.this.setDoubleBuffered(window, !bl);
                }
            });
        }

        protected void setMask(final Component component, final Raster raster) {
            this.whenDisplayable(component, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    GDI32 gDI32 = GDI32.INSTANCE;
                    User32 user32 = User32.INSTANCE;
                    W32API.HWND hWND = W32WindowUtils.this.getHWnd(component);
                    final W32API.HRGN hRGN = gDI32.CreateRectRgn(0, 0, 0, 0);
                    try {
                        if (raster == null) {
                            gDI32.SetRectRgn(hRGN, 0, 0, component.getWidth(), component.getHeight());
                        } else {
                            final W32API.HRGN hRGN2 = gDI32.CreateRectRgn(0, 0, 0, 0);
                            try {
                                RasterRangesUtils.outputOccupiedRanges(raster, new RasterRangesUtils.RangesOutput(){

                                    public boolean outputRange(int n, int n2, int n3, int n4) {
                                        GDI32 gDI32 = GDI32.INSTANCE;
                                        gDI32.SetRectRgn(hRGN2, n, n2, n + n3, n2 + n4);
                                        return gDI32.CombineRgn(hRGN, hRGN, hRGN2, 2) != 0;
                                    }
                                });
                            }
                            finally {
                                gDI32.DeleteObject(hRGN2);
                            }
                        }
                        user32.SetWindowRgn(hWND, hRGN, true);
                    }
                    finally {
                        gDI32.DeleteObject(hRGN);
                    }
                    W32WindowUtils.this.setForceHeavyweightPopups(W32WindowUtils.this.getWindow(component), raster != null);
                }
            });
        }

        private class W32TransparentContent
        extends NativeWindowUtils.TransparentContent {
            private W32API.HDC memDC;
            private W32API.HBITMAP hBitmap;
            private Pointer pbits;
            private Dimension bitmapSize;

            public W32TransparentContent(Container container) {
                super(container);
            }

            private void disposeBackingStore() {
                GDI32 gDI32 = GDI32.INSTANCE;
                if (this.hBitmap != null) {
                    gDI32.DeleteObject(this.hBitmap);
                    this.hBitmap = null;
                }
                if (this.memDC != null) {
                    gDI32.DeleteDC(this.memDC);
                    this.memDC = null;
                }
            }

            public void removeNotify() {
                super.removeNotify();
                this.disposeBackingStore();
            }

            public void setTransparent(boolean bl) {
                super.setTransparent(bl);
                if (!bl) {
                    this.disposeBackingStore();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void paintDirect(BufferedImage bufferedImage, Rectangle rectangle) {
                Window window = SwingUtilities.getWindowAncestor(this);
                GDI32 gDI32 = GDI32.INSTANCE;
                User32 user32 = User32.INSTANCE;
                int n = rectangle.x;
                int n2 = rectangle.y;
                Point point = SwingUtilities.convertPoint(this, n, n2, window);
                int n3 = rectangle.width;
                int n4 = rectangle.height;
                int n5 = window.getWidth();
                int n6 = window.getHeight();
                W32API.HDC hDC = user32.GetDC(null);
                W32API.HANDLE hANDLE = null;
                try {
                    Object object;
                    Object object2;
                    if (this.memDC == null) {
                        this.memDC = gDI32.CreateCompatibleDC(hDC);
                    }
                    if (this.hBitmap == null || !window.getSize().equals(this.bitmapSize)) {
                        if (this.hBitmap != null) {
                            gDI32.DeleteObject(this.hBitmap);
                            this.hBitmap = null;
                        }
                        object2 = new GDI32.BITMAPINFO();
                        ((GDI32.BITMAPINFO)((Object)object2)).bmiHeader.biWidth = n5;
                        ((GDI32.BITMAPINFO)((Object)object2)).bmiHeader.biHeight = n6;
                        ((GDI32.BITMAPINFO)((Object)object2)).bmiHeader.biPlanes = 1;
                        ((GDI32.BITMAPINFO)((Object)object2)).bmiHeader.biBitCount = (short)32;
                        ((GDI32.BITMAPINFO)((Object)object2)).bmiHeader.biCompression = 0;
                        ((GDI32.BITMAPINFO)((Object)object2)).bmiHeader.biSizeImage = n5 * n6 * 4;
                        object = new PointerByReference();
                        this.hBitmap = gDI32.CreateDIBSection(this.memDC, (GDI32.BITMAPINFO)((Object)object2), 0, (PointerByReference)object, null, 0);
                        this.pbits = object.getValue();
                        this.bitmapSize = new Dimension(n5, n6);
                    }
                    hANDLE = gDI32.SelectObject(this.memDC, this.hBitmap);
                    object2 = bufferedImage.getData();
                    object = new int[4];
                    int[] nArray = new int[n3];
                    for (int i = 0; i < n4; ++i) {
                        int n7;
                        for (n7 = 0; n7 < n3; ++n7) {
                            ((Raster)object2).getPixel(n7, i, (int[])object);
                            int n8 = (object[3] & 0xFF) << 24;
                            int n9 = object[2] & 0xFF;
                            int n10 = (object[1] & 0xFF) << 8;
                            int n11 = (object[0] & 0xFF) << 16;
                            nArray[n7] = n8 | n9 | n10 | n11;
                        }
                        n7 = n6 - (point.y + i) - 1;
                        this.pbits.write((long)((n7 * n5 + point.x) * 4), nArray, 0, nArray.length);
                    }
                    User32.SIZE sIZE = new User32.SIZE();
                    sIZE.cx = window.getWidth();
                    sIZE.cy = window.getHeight();
                    User32.POINT pOINT = new User32.POINT();
                    pOINT.x = window.getX();
                    pOINT.y = window.getY();
                    User32.POINT pOINT2 = new User32.POINT();
                    User32.BLENDFUNCTION bLENDFUNCTION = new User32.BLENDFUNCTION();
                    W32API.HWND hWND = W32WindowUtils.this.getHWnd(window);
                    ByteByReference byteByReference = new ByteByReference();
                    IntByReference intByReference = new IntByReference();
                    byte by = W32WindowUtils.this.getAlpha(window);
                    if (user32.GetLayeredWindowAttributes(hWND, null, byteByReference, intByReference) && (intByReference.getValue() & 2) != 0) {
                        by = byteByReference.getValue();
                    }
                    bLENDFUNCTION.SourceConstantAlpha = by;
                    bLENDFUNCTION.AlphaFormat = 1;
                    user32.UpdateLayeredWindow(hWND, hDC, pOINT, sIZE, this.memDC, pOINT2, 0, bLENDFUNCTION, 2);
                    user32.ReleaseDC(null, hDC);
                }
                catch (Throwable throwable) {
                    user32.ReleaseDC(null, hDC);
                    if (this.memDC != null && hANDLE != null) {
                        gDI32.SelectObject(this.memDC, hANDLE);
                    }
                    throw throwable;
                }
                if (this.memDC != null && hANDLE != null) {
                    gDI32.SelectObject(this.memDC, hANDLE);
                }
            }
        }
    }

    private static class Holder {
        public static boolean requiresVisible;
        public static final NativeWindowUtils INSTANCE;

        private Holder() {
        }

        static {
            if (Platform.isWindows()) {
                INSTANCE = new W32WindowUtils();
            } else if (Platform.isMac()) {
                INSTANCE = new MacWindowUtils();
            } else if (Platform.isX11()) {
                INSTANCE = new X11WindowUtils();
                requiresVisible = System.getProperty("java.version").matches("^1\\.4\\..*");
            } else {
                String string = System.getProperty("os.name");
                throw new UnsupportedOperationException("No support for " + string);
            }
        }
    }

    public static abstract class NativeWindowUtils {
        protected Window getWindow(Component component) {
            return component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        }

        protected void whenDisplayable(Component component, final Runnable runnable) {
            if (component.isDisplayable() && (!Holder.requiresVisible || component.isVisible())) {
                runnable.run();
            } else if (Holder.requiresVisible) {
                this.getWindow(component).addWindowListener(new WindowAdapter(){

                    public void windowOpened(WindowEvent windowEvent) {
                        windowEvent.getWindow().removeWindowListener(this);
                        runnable.run();
                    }

                    public void windowClosed(WindowEvent windowEvent) {
                        windowEvent.getWindow().removeWindowListener(this);
                    }
                });
            } else {
                component.addHierarchyListener(new HierarchyListener(){

                    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                        if ((hierarchyEvent.getChangeFlags() & 2L) != 0L && hierarchyEvent.getComponent().isDisplayable()) {
                            hierarchyEvent.getComponent().removeHierarchyListener(this);
                            runnable.run();
                        }
                    }
                });
            }
        }

        protected Raster toRaster(Shape shape) {
            WritableRaster writableRaster = null;
            if (shape != MASK_NONE) {
                Rectangle rectangle = shape.getBounds();
                if (rectangle.width > 0 && rectangle.height > 0) {
                    BufferedImage bufferedImage = new BufferedImage(rectangle.x + rectangle.width, rectangle.y + rectangle.height, 2);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.setComposite(AlphaComposite.Clear);
                    graphics2D.fillRect(0, 0, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                    graphics2D.setComposite(AlphaComposite.SrcOver);
                    graphics2D.setColor(Color.white);
                    graphics2D.fill(shape);
                    writableRaster = bufferedImage.getAlphaRaster();
                }
            }
            return writableRaster;
        }

        protected Raster toRaster(Component component, Icon icon) {
            WritableRaster writableRaster = null;
            if (icon != null) {
                Rectangle rectangle = new Rectangle(0, 0, icon.getIconWidth(), icon.getIconHeight());
                BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setComposite(AlphaComposite.Clear);
                graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
                graphics2D.setComposite(AlphaComposite.SrcOver);
                icon.paintIcon(component, graphics2D, 0, 0);
                writableRaster = bufferedImage.getAlphaRaster();
            }
            return writableRaster;
        }

        protected Shape toShape(Raster raster) {
            final Area area = new Area(new Rectangle(0, 0, 0, 0));
            RasterRangesUtils.outputOccupiedRanges(raster, new RasterRangesUtils.RangesOutput(){

                public boolean outputRange(int n, int n2, int n3, int n4) {
                    area.add(new Area(new Rectangle(n, n2, n3, n4)));
                    return true;
                }
            });
            return area;
        }

        public void setWindowAlpha(Window window, float f) {
        }

        public boolean isWindowAlphaSupported() {
            return false;
        }

        public GraphicsConfiguration getAlphaCompatibleGraphicsConfiguration() {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            return graphicsDevice.getDefaultConfiguration();
        }

        public void setWindowTransparent(Window window, boolean bl) {
        }

        protected void setDoubleBuffered(Component component, boolean bl) {
            if (component instanceof JComponent) {
                ((JComponent)component).setDoubleBuffered(bl);
            }
            if (component instanceof JRootPane && bl) {
                ((JRootPane)component).setDoubleBuffered(true);
            } else if (component instanceof Container) {
                Component[] componentArray = ((Container)component).getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    this.setDoubleBuffered(componentArray[i], bl);
                }
            }
        }

        protected void setLayersTransparent(Window window, boolean bl) {
            Color color;
            Color color2 = color = bl ? new Color(0, 0, 0, 0) : null;
            if (window instanceof RootPaneContainer) {
                JComponent jComponent;
                RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)window);
                JRootPane jRootPane = rootPaneContainer.getRootPane();
                JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
                Container container = jRootPane.getContentPane();
                JComponent jComponent2 = jComponent = container instanceof JComponent ? (JComponent)container : null;
                if (bl) {
                    jLayeredPane.putClientProperty(WindowUtils.TRANSPARENT_OLD_OPAQUE, jLayeredPane.isOpaque());
                    jLayeredPane.setOpaque(false);
                    jRootPane.putClientProperty(WindowUtils.TRANSPARENT_OLD_OPAQUE, jRootPane.isOpaque());
                    jRootPane.setOpaque(false);
                    if (jComponent != null) {
                        jComponent.putClientProperty(WindowUtils.TRANSPARENT_OLD_OPAQUE, jComponent.isOpaque());
                        jComponent.setOpaque(false);
                    }
                    jRootPane.putClientProperty(WindowUtils.TRANSPARENT_OLD_BG, jRootPane.getParent().getBackground());
                } else {
                    jLayeredPane.setOpaque(Boolean.TRUE.equals(jLayeredPane.getClientProperty(WindowUtils.TRANSPARENT_OLD_OPAQUE)));
                    jRootPane.setOpaque(Boolean.TRUE.equals(jRootPane.getClientProperty(WindowUtils.TRANSPARENT_OLD_OPAQUE)));
                    if (jComponent != null) {
                        jComponent.setOpaque(Boolean.TRUE.equals(jComponent.getClientProperty(WindowUtils.TRANSPARENT_OLD_OPAQUE)));
                    }
                    color = (Color)jRootPane.getClientProperty(WindowUtils.TRANSPARENT_OLD_BG);
                }
            }
            window.setBackground(color);
        }

        protected void setMask(Component component, Raster raster) {
            throw new UnsupportedOperationException("Window masking is not available");
        }

        protected void setWindowMask(Component component, Raster raster) {
            if (component.isLightweight()) {
                throw new IllegalArgumentException("Component must be heavyweight: " + component);
            }
            this.setMask(component, raster);
        }

        public void setWindowMask(Component component, Shape shape) {
            this.setWindowMask(component, this.toRaster(shape));
        }

        public void setWindowMask(Component component, Icon icon) {
            this.setWindowMask(component, this.toRaster(component, icon));
        }

        protected void setForceHeavyweightPopups(Window window, boolean bl) {
            if (!(window instanceof HeavyweightForcer)) {
                Window[] windowArray = window.getOwnedWindows();
                for (int i = 0; i < windowArray.length; ++i) {
                    if (!(windowArray[i] instanceof HeavyweightForcer)) continue;
                    if (bl) {
                        return;
                    }
                    windowArray[i].dispose();
                }
                Boolean bl2 = Boolean.valueOf(System.getProperty("jna.force_hw_popups", "true"));
                if (bl && bl2.booleanValue()) {
                    new HeavyweightForcer(window);
                }
            }
        }

        protected abstract class TransparentContent
        extends JPanel {
            private boolean transparent;

            public TransparentContent(Container container) {
                super(new BorderLayout());
                this.add((Component)container, "Center");
                this.setTransparent(true);
                if (container instanceof JPanel) {
                    ((JComponent)container).setOpaque(false);
                }
            }

            public void setTransparent(boolean bl) {
                this.transparent = bl;
                this.setOpaque(!bl);
                this.setDoubleBuffered(!bl);
                this.repaint();
            }

            public void paint(Graphics graphics) {
                if (this.transparent) {
                    Rectangle rectangle = graphics.getClipBounds();
                    int n = rectangle.width;
                    int n2 = rectangle.height;
                    if (this.getWidth() > 0 && this.getHeight() > 0) {
                        BufferedImage bufferedImage = new BufferedImage(n, n2, 3);
                        Graphics2D graphics2D = bufferedImage.createGraphics();
                        graphics2D.setComposite(AlphaComposite.Clear);
                        graphics2D.fillRect(0, 0, n, n2);
                        graphics2D.dispose();
                        graphics2D = bufferedImage.createGraphics();
                        graphics2D.translate(-rectangle.x, -rectangle.y);
                        super.paint(graphics2D);
                        graphics2D.dispose();
                        this.paintDirect(bufferedImage, rectangle);
                    }
                } else {
                    super.paint(graphics);
                }
            }

            protected abstract void paintDirect(BufferedImage var1, Rectangle var2);
        }
    }

    protected static class RepaintTrigger
    extends JComponent {
        private Listener listener = this.createListener();
        private JComponent content;
        private Rectangle dirty;

        public RepaintTrigger(JComponent jComponent) {
            this.content = jComponent;
        }

        public void addNotify() {
            super.addNotify();
            Window window = SwingUtilities.getWindowAncestor(this);
            this.setSize(this.getParent().getSize());
            window.addComponentListener(this.listener);
            window.addWindowListener(this.listener);
        }

        public void removeNotify() {
            Window window = SwingUtilities.getWindowAncestor(this);
            window.removeComponentListener(this.listener);
            window.removeWindowListener(this.listener);
            super.removeNotify();
        }

        protected void paintComponent(Graphics graphics) {
            Rectangle rectangle = graphics.getClipBounds();
            if (this.dirty == null || !this.dirty.contains(rectangle)) {
                this.dirty = this.dirty == null ? rectangle : this.dirty.union(rectangle);
                this.content.repaint(this.dirty);
            } else {
                this.dirty = null;
            }
        }

        protected Listener createListener() {
            return new Listener();
        }

        protected class Listener
        extends WindowAdapter
        implements ComponentListener,
        HierarchyListener {
            protected Listener() {
            }

            public void windowOpened(WindowEvent windowEvent) {
                RepaintTrigger.this.repaint();
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                RepaintTrigger.this.setSize(RepaintTrigger.this.getParent().getSize());
                RepaintTrigger.this.repaint();
            }

            public void componentShown(ComponentEvent componentEvent) {
                RepaintTrigger.this.repaint();
            }

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                RepaintTrigger.this.repaint();
            }
        }
    }

    private static class HeavyweightForcer
    extends Window {
        private boolean packed;

        public HeavyweightForcer(Window window) {
            super(window);
            this.pack();
            this.packed = true;
        }

        public boolean isVisible() {
            return this.packed;
        }

        public Rectangle getBounds() {
            return this.getOwner().getBounds();
        }
    }
}

