/*
 * Decompiled with CFR 0.152.
 */
package tr.model;

import java.util.Iterator;
import tr.model.Data;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.action.ActionState;
import tr.model.action.ActionStateASAP;
import tr.model.future.Future;
import tr.model.information.Information;
import tr.model.project.Project;
import tr.util.HTML;

public class DataUpgrade1to2 {
    public static void process(Data data) {
        if (data.version == 1) {
            DataUpgrade1to2.upgrade(data);
            data.version = 2;
        }
    }

    private static void upgrade(Data data) {
        System.out.print("Upgrading data from version 1 to version 2 ... ");
        DataUpgrade1to2.processProjects(data);
        DataUpgrade1to2.processSingleActions(data);
        DataUpgrade1to2.processFutureItems(data);
        DataUpgrade1to2.processInformationItems(data);
        System.out.println("Done");
    }

    private static void processProjects(Data data) {
        Iterator<Project> i = data.getRootProjects().iterator(Project.class);
        while (i.hasNext()) {
            DataUpgrade1to2.processProject(i.next());
        }
    }

    private static void processProject(Project project) {
        String notes = project.getNotes();
        if (DataUpgrade1to2.isHTML(notes)) {
            project.setNotes(HTML.html2text((String)notes));
        }
        Iterator<Item> i = project.iterator(Item.class);
        while (i.hasNext()) {
            Item child = i.next();
            if (child instanceof Action) {
                DataUpgrade1to2.processAction((Action)child);
                continue;
            }
            if (!(child instanceof Project)) continue;
            DataUpgrade1to2.processProject((Project)child);
        }
    }

    private static void processSingleActions(Data data) {
        Iterator<Action> i = data.getRootActions().iterator(Action.class);
        while (i.hasNext()) {
            DataUpgrade1to2.processAction(i.next());
        }
    }

    private static void processAction(Action action) {
        ActionState actionState;
        String notes = action.getNotes();
        if (DataUpgrade1to2.isHTML(notes)) {
            action.setNotes(HTML.html2text((String)notes));
        }
        if ((actionState = action.getState()) instanceof ActionStateASAP) {
            ActionStateASAP stateDoASAP = (ActionStateASAP)actionState;
            action.setDueDate(stateDoASAP.getDueDate());
        }
    }

    private static void processFutureItems(Data data) {
        for (Future future : data.getFutureManager().list()) {
            String notes = future.getNotes();
            if (!DataUpgrade1to2.isHTML(notes)) continue;
            future.setNotes(HTML.html2text((String)notes));
        }
    }

    private static void processInformationItems(Data data) {
        for (Information information : data.getInformationManager().list()) {
            String notes = information.getNotes();
            if (!DataUpgrade1to2.isHTML(notes)) continue;
            information.setNotes(HTML.html2text((String)notes));
        }
    }

    private static boolean isHTML(String s) {
        if (s == null) {
            return false;
        }
        return (s = s.trim()).startsWith("<html>") || s.startsWith("<HTML>");
    }
}

