/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.server.data;

import com.projectlibre1.pm.calendar.WorkCalendar;
import com.projectlibre1.pm.resource.EnterpriseResource;
import com.projectlibre1.pm.resource.ResourceImpl;
import com.projectlibre1.server.data.DataObject;
import com.projectlibre1.server.data.SerializedDataObject;
import com.projectlibre1.server.data.SerializedDataObjectFactory;
import com.projectlibre1.session.Session;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class SerializeUtil {
    public static final boolean ZIP = true;

    public static byte[] serializeToByteArray(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static Object deserializeFromByteArray(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    public static SerializedDataObject serialize(DataObject dataObject, SerializedDataObjectFactory serializedDataObjectFactory) throws IOException {
        ObjectOutputStream objectOutputStream;
        SerializedDataObject serializedDataObject = serializedDataObjectFactory.createSerializedDataObject();
        serializedDataObject.setUniqueId(dataObject.getUniqueId());
        serializedDataObject.setName(dataObject.getName());
        serializedDataObject.setDirty(dataObject.isDirty());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (dataObject instanceof WorkCalendar || dataObject instanceof EnterpriseResource || dataObject instanceof ResourceImpl) {
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            zipOutputStream.putNextEntry(new ZipEntry("Serialized"));
            objectOutputStream = new ObjectOutputStream(zipOutputStream);
        } else {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        }
        objectOutputStream.writeObject(dataObject);
        objectOutputStream.close();
        byteArrayOutputStream.close();
        serializedDataObject.setSerialized(byteArrayOutputStream.toByteArray());
        return serializedDataObject;
    }

    public static DataObject deserialize(SerializedDataObject serializedDataObject, Session session) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream;
        Object object;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(serializedDataObject.getSerialized());
        if (serializedDataObject.getType() == 1 || serializedDataObject.getType() == 3 || serializedDataObject.getType() == 4) {
            object = new ZipInputStream(byteArrayInputStream);
            ((ZipInputStream)object).getNextEntry();
            objectInputStream = new ObjectInputStream((InputStream)object);
        } else {
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
        }
        object = (DataObject)objectInputStream.readObject();
        object.setUniqueId(session == null ? serializedDataObject.getUniqueId() : session.getId());
        object.setName(serializedDataObject.getName());
        return object;
    }
}

