/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import net.i2p.data.DataHelper;

public class URIUtil {
    public static String encodePath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        StringBuilder buf = URIUtil.encodePath(null, path);
        return buf == null ? path : buf.toString();
    }

    public static StringBuilder encodePath(StringBuilder buf, String path) {
        int i;
        byte[] bytes = null;
        if (buf == null) {
            block38: for (i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                switch (c) {
                    case ' ': 
                    case '\"': 
                    case '#': 
                    case '%': 
                    case '&': 
                    case '\'': 
                    case ':': 
                    case ';': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '|': {
                        buf = new StringBuilder(path.length() * 2);
                        break block38;
                    }
                    default: {
                        if (c < '\u007f' && c > '\u001f') continue block38;
                        bytes = DataHelper.getUTF8(path);
                        buf = new StringBuilder(path.length() * 2);
                        break block38;
                    }
                }
            }
            if (buf == null) {
                return null;
            }
        }
        if (bytes != null) {
            block39: for (i = 0; i < bytes.length; ++i) {
                void var4_5 = bytes[i];
                switch (var4_5) {
                    case 37: {
                        buf.append("%25");
                        continue block39;
                    }
                    case 63: {
                        buf.append("%3F");
                        continue block39;
                    }
                    case 59: {
                        buf.append("%3B");
                        continue block39;
                    }
                    case 35: {
                        buf.append("%23");
                        continue block39;
                    }
                    case 34: {
                        buf.append("%22");
                        continue block39;
                    }
                    case 39: {
                        buf.append("%27");
                        continue block39;
                    }
                    case 60: {
                        buf.append("%3C");
                        continue block39;
                    }
                    case 62: {
                        buf.append("%3E");
                        continue block39;
                    }
                    case 32: {
                        buf.append("%20");
                        continue block39;
                    }
                    case 127: {
                        buf.append("%7F");
                        continue block39;
                    }
                    case 58: {
                        buf.append("%3A");
                        continue block39;
                    }
                    case 91: {
                        buf.append("%5B");
                        continue block39;
                    }
                    case 93: {
                        buf.append("%5D");
                        continue block39;
                    }
                    case 38: {
                        buf.append("%26");
                        continue block39;
                    }
                    case 124: {
                        buf.append("%7C");
                        continue block39;
                    }
                    case 92: {
                        buf.append("%5C");
                        continue block39;
                    }
                    default: {
                        if (var4_5 <= 31) {
                            URIUtil.toHex((byte)var4_5, buf);
                            continue block39;
                        }
                        buf.append((char)var4_5);
                        continue block39;
                    }
                }
            }
        } else {
            block40: for (i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                switch (c) {
                    case '%': {
                        buf.append("%25");
                        continue block40;
                    }
                    case '?': {
                        buf.append("%3F");
                        continue block40;
                    }
                    case ';': {
                        buf.append("%3B");
                        continue block40;
                    }
                    case '#': {
                        buf.append("%23");
                        continue block40;
                    }
                    case '\"': {
                        buf.append("%22");
                        continue block40;
                    }
                    case '\'': {
                        buf.append("%27");
                        continue block40;
                    }
                    case '<': {
                        buf.append("%3C");
                        continue block40;
                    }
                    case '>': {
                        buf.append("%3E");
                        continue block40;
                    }
                    case ' ': {
                        buf.append("%20");
                        continue block40;
                    }
                    case ':': {
                        buf.append("%3A");
                        continue block40;
                    }
                    case '[': {
                        buf.append("%5B");
                        continue block40;
                    }
                    case ']': {
                        buf.append("%5D");
                        continue block40;
                    }
                    case '&': {
                        buf.append("%26");
                        continue block40;
                    }
                    case '|': {
                        buf.append("%7C");
                        continue block40;
                    }
                    case '\\': {
                        buf.append("%5C");
                        continue block40;
                    }
                    default: {
                        if (c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || Character.isSpaceChar(c)) {
                            URIUtil.toHex(c, buf);
                            continue block40;
                        }
                        buf.append(c);
                        continue block40;
                    }
                }
            }
        }
        return buf;
    }

    private static void toHex(byte b, StringBuilder buf) {
        buf.append('%');
        int d = 0xF & (0xF0 & b) >> 4;
        buf.append((char)((d > 9 ? 55 : 48) + d));
        d = 0xF & b;
        buf.append((char)((d > 9 ? 55 : 48) + d));
    }

    private static void toHex(char c, StringBuilder buf) {
        if (c > '\u007f') {
            byte[] b = DataHelper.getUTF8(Character.toString(c));
            for (int i = 0; i < b.length; ++i) {
                URIUtil.toHex(b[i], buf);
            }
        } else {
            URIUtil.toHex((byte)c, buf);
        }
    }
}

