/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.apache.http.conn.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import net.i2p.apache.http.conn.util.PublicSuffixList;

public final class PublicSuffixListParser {
    private static final int MAX_LINE_LEN = 256;

    public PublicSuffixList parse(Reader reader) throws IOException {
        ArrayList<String> rules = new ArrayList<String>();
        ArrayList<String> exceptions = new ArrayList<String>();
        BufferedReader r = new BufferedReader(reader);
        StringBuilder sb = new StringBuilder(256);
        boolean more = true;
        while (more) {
            boolean isException;
            more = this.readLine(r, sb);
            String line = sb.toString();
            if (line.isEmpty() || line.startsWith("//")) continue;
            if (line.startsWith(".")) {
                line = line.substring(1);
            }
            if (isException = line.startsWith("!")) {
                line = line.substring(1);
            }
            if (isException) {
                exceptions.add(line);
                continue;
            }
            rules.add(line);
        }
        return new PublicSuffixList(rules, exceptions);
    }

    private boolean readLine(Reader r, StringBuilder sb) throws IOException {
        char c;
        int b;
        sb.setLength(0);
        boolean hitWhitespace = false;
        while ((b = r.read()) != -1 && (c = (char)b) != '\n') {
            if (Character.isWhitespace(c)) {
                hitWhitespace = true;
            }
            if (!hitWhitespace) {
                sb.append(c);
            }
            if (sb.length() <= 256) continue;
            return false;
        }
        return b != -1;
    }
}

