/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.data.Hash;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.util.Log;

abstract class FloodSearchJob
extends JobImpl {
    protected final Log _log;
    protected final FloodfillNetworkDatabaseFacade _facade;
    protected final Hash _key;
    protected final List<Job> _onFind;
    protected final List<Job> _onFailed;
    protected long _expiration;
    protected int _timeoutMs;
    protected final boolean _isLease;
    protected final AtomicInteger _lookupsRemaining = new AtomicInteger();
    protected volatile boolean _dead;
    protected final long _created;
    protected boolean _success;
    protected static final int CONCURRENT_SEARCHES = 2;
    private static final int FLOOD_SEARCH_TIME_FACTOR = 2;

    public FloodSearchJob(RouterContext ctx, FloodfillNetworkDatabaseFacade facade, Hash key, Job onFind, Job onFailed, int timeoutMs, boolean isLease) {
        super(ctx);
        int timeout;
        this._log = ctx.logManager().getLog(this.getClass());
        this._facade = facade;
        this._key = key;
        this._onFind = new CopyOnWriteArrayList<Job>();
        if (onFind != null) {
            this._onFind.add(onFind);
        }
        this._onFailed = new CopyOnWriteArrayList<Job>();
        if (onFailed != null) {
            this._onFailed.add(onFailed);
        }
        if ((timeout = timeoutMs / 2) < timeoutMs) {
            timeout = timeoutMs;
        }
        this._timeoutMs = timeout;
        this._expiration = (long)timeout + ctx.clock().now();
        this._isLease = isLease;
        this._created = System.currentTimeMillis();
    }

    public long getCreated() {
        return this._created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDeferred(Job onFind, Job onFailed, long timeoutMs, boolean isLease) {
        boolean success;
        FloodSearchJob floodSearchJob = this;
        synchronized (floodSearchJob) {
            if (!this._dead) {
                if (onFind != null) {
                    this._onFind.add(onFind);
                }
                if (onFailed != null) {
                    this._onFailed.add(onFailed);
                }
                return;
            }
            success = this._success;
        }
        if (success && onFind != null) {
            this.getContext().jobQueue().addJob(onFind);
        } else if (!success && onFailed != null) {
            this.getContext().jobQueue().addJob(onFailed);
        }
    }

    public long getExpiration() {
        return this._expiration;
    }

    @Override
    public void runJob() {
        throw new UnsupportedOperationException("use override");
    }

    @Override
    public String getName() {
        return "NetDb search (phase 1)";
    }

    public Hash getKey() {
        return this._key;
    }

    protected int decrementRemaining() {
        int n;
        do {
            if ((n = this._lookupsRemaining.get()) > 0) continue;
            return 0;
        } while (!this._lookupsRemaining.compareAndSet(n, n - 1));
        return n - 1;
    }

    protected int getLookupsRemaining() {
        return this._lookupsRemaining.get();
    }

    void failed() {
        throw new UnsupportedOperationException("use override");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void success() {
        FloodSearchJob floodSearchJob = this;
        synchronized (floodSearchJob) {
            this._success = true;
        }
    }
}

