/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResIntValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.util.Duo;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlSerializer;

public class ResEnumAttr
extends ResAttr {
    private final Duo<ResReferenceValue, ResScalarValue>[] mItems;
    private final Map<Integer, String> mItemsCache = new HashMap<Integer, String>();
    private static final Logger LOGGER = Logger.getLogger(ResEnumAttr.class.getName());

    ResEnumAttr(ResReferenceValue parent, int type, Integer min, Integer max, Boolean l10n, Duo<ResReferenceValue, ResScalarValue>[] items) {
        super(parent, type, min, max, l10n);
        this.mItems = items;
    }

    @Override
    public String convertToResXmlFormat(ResScalarValue value) throws AndrolibException {
        String ret;
        if (value instanceof ResIntValue && (ret = this.decodeValue(((ResIntValue)value).getValue())) != null) {
            return ret;
        }
        return super.convertToResXmlFormat(value);
    }

    @Override
    protected void serializeBody(XmlSerializer serializer, ResResource res) throws AndrolibException, IOException {
        for (Duo<ResReferenceValue, ResScalarValue> duo : this.mItems) {
            int intVal = ((ResScalarValue)duo.m2).getRawIntValue();
            ResResSpec m1Referent = ((ResReferenceValue)duo.m1).getReferent();
            if (m1Referent == null && this.shouldRemoveUnknownRes()) {
                LOGGER.fine(String.format("null enum reference: m1=0x%08x(%s), m2=0x%08x(%s)", ((ResReferenceValue)duo.m1).getRawIntValue(), ((ResReferenceValue)duo.m1).getType(), ((ResScalarValue)duo.m2).getRawIntValue(), ((ResScalarValue)duo.m2).getType()));
                continue;
            }
            serializer.startTag(null, "enum");
            serializer.attribute(null, "name", m1Referent != null ? m1Referent.getName() : String.format("APKTOOL_MISSING_0x%08x", ((ResReferenceValue)duo.m1).getRawIntValue()));
            serializer.attribute(null, "value", String.valueOf(intVal));
            serializer.endTag(null, "enum");
        }
    }

    private String decodeValue(int value) throws AndrolibException {
        String value2 = this.mItemsCache.get(value);
        if (value2 == null) {
            ResReferenceValue ref = null;
            for (Duo<ResReferenceValue, ResScalarValue> duo : this.mItems) {
                if (((ResScalarValue)duo.m2).getRawIntValue() != value) continue;
                ref = (ResReferenceValue)duo.m1;
                break;
            }
            if (ref != null && !ref.referentIsNull()) {
                value2 = ref.getReferent().getName();
                this.mItemsCache.put(value, value2);
            }
        }
        return value2;
    }
}

