%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/creating-real-parenthesized-dynamics.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Snippet Repository
%% (http://lsr.di.unimi.it).
%%
%% Make any changes in the LSR itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.23.13"

\header {
%% Translation of GIT committish: 0cc270b871321ae5aa8622cea8d8262aafd16641
  texidocja = "
強弱記号に括弧を追加する一番簡単な方法は、@code{\\markup} ブロックを@c
使用することですが、この方法には欠点があります: このように作成された@c
オブジェクトは、強弱記号ではなくテキスト マークアップとして振る舞うと@c
いうことです。

しかしながら、(記譜法リファレンスで説明しているように)
@code{make-dynamic-script} 関数と共に
Scheme コードを用いることで、似たようなオブジェクトを作り出すことができます。@c
このように作成された記号は強弱記号として振る舞い、@code{\\dynamicUp} や
@code{\\dynamicDown} といったコマンドと互換性を保ちます。
"
  doctitleja = "\"本当の\"括弧付きの強弱記号を作成する"

%% Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
  texidocfr = "
Bien que le moyen le plus simple pour ajouter des parenthèses à une
indication de nuance consiste à utiliser un bloc @code{\\markup}, cette
pratique a un inconvénient : les objets ainsi créés seront considérés
comme des annotations textuelles, non comme des nuances.

Il est néanmoins possible de créer des objets particuliers en partant de
code Scheme -- comme expliqué dans le manuel de notation -- avec la
fonction @code{make-dynamic-script}.  Les @emph{markups} ainsi créés
seront alors considérés comme étant des indications de nuance, et de ce
fait pourront se voir appliquer les effets des commandes
@code{\\dynamicUp} et @code{\\dynamicDown}.
"

  doctitlefr = "Indications de nuance vraiment entre parenthèses"

%% Translation of GIT committish: 00f0ca84dbb015617f8ce36dd13db59bbfef8f11
  texidoces = "
Aunque la manera más fácil de añadir paréntesis a una indicación
de dinámica es utilizar un bloque @code{\\markup}, este método
tiene un inconveniente: los objetos que se crean se comportarán
como elementos de marcado de texto y no como indicaciones
dinámicas.

Sin embargo, es posible crear un objeto similar utilizando el código
de Scheme equivalente (como se explica en la Referencia de la
notación), en combinación con la función
@code{make-dynamic-script}. De esta forma, el elemento de marcado se
tratará como una indicación dinámica, y por tanto seguirá siendo
compatible con instrucciones como @code{\\dynamicUp} o
@code{\\dynamicDown}.

"
  doctitlees = "Crear indicaciones dinámicas \"verdaderas\"entre paréntesis"

%% Translation of GIT committish: 98ac53591234404cd70c5eebd370a598ec74095b
  texidocca = "
Tot i que la manera més fàcil d'afegir parèntesis a una indicació
de dinàmica és utilitzar un bloc @code{\\markup}, aquest mètode té
un inconvenient: els objectes que es creen es comportaran com
elements de marcatge de text i no com indicacions dinàmiques.

No obstant, és possible crear un objecte utilitzant el codi de
l'Scheme equivalent (com s'explica a la Referència de la notació),
en combinació amb la funció @code{make-dynamic-script}. D'aquesta
forma l'element de marcatge es tractarà com una indicació
dinàmica, i per tant seguirà sent compatible amb ordre com ara
@code{\\dynamicUp} o @code{\\dynamicDown}.

"
  doctitleca = "Crear indicacions dinàmiques \"vertaderes\" entre parèntesis"

  lsrtags = "expressive-marks, text, workaround"

  texidoc = "
Although the easiest way to add parentheses to a dynamic mark is to use
a @code{\\markup} block, this method has a downside: the created
objects will behave like text markups, and not like dynamics.

However, it is possible to create a similar object using the equivalent
Scheme code (as described in the Notation Reference), combined with the
@code{make-dynamic-script} function. This way, the markup will be
regarded as a dynamic, and therefore will remain compatible with
commands such as @code{\\dynamicUp} or @code{\\dynamicDown}.
"

  doctitle = "Creating \"real\" parenthesized dynamics"
} % begin verbatim


paren =
#(define-event-function (dyn) (ly:event?)
   (make-dynamic-script
    #{ \markup \concat {
         \normal-text \italic \fontsize #2 (
	 \pad-x #0.2 #(ly:music-property dyn 'text)
	 \normal-text \italic \fontsize #2 )
       }
    #}))

\relative c'' {
  c4\paren\f c c \dynamicUp c\paren\p
}



% ****************************************************************
% end ly snippet
% ****************************************************************
